/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.ecm.jcr.ECMNameValidator;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/UIFormInputSetWithAction.gtmpl")
public class UIWizardStep1
extends UIFormInputSetWithAction {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_NODETYPE = "autoInitializedRootNt";
    public static final String FIELD_PERMISSION = "permission";
    public static final String FIELD_TIMEOUT = "setLockTimeOut";
    public static final String FIELD_ISDEFAULT = "isDefault";
    private Map<String, String> permissions_ = new HashMap();

    public UIWizardStep1(String name) throws Exception {
        super(name);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(ECMNameValidator.class, new Object[0]));
        this.addChild((UIComponent)new UIFormSelectBox(FIELD_NODETYPE, FIELD_NODETYPE, this.getNodeType()));
        UIFormCheckBoxInput checkbox = new UIFormCheckBoxInput(FIELD_ISDEFAULT, FIELD_ISDEFAULT, null);
        this.addChild((UIComponent)checkbox);
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_PERMISSION, FIELD_PERMISSION, null));
        String[] actionInfor = new String[]{"EditPermission", "RemovePermission"};
        this.setActionInfo(FIELD_PERMISSION, actionInfor);
        this.setFieldActions(FIELD_PERMISSION, new String[]{"AddPermission"});
        this.showActionInfo(true);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_TIMEOUT, FIELD_TIMEOUT, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(NumberFormatValidator.class, new Object[0]));
    }

    private List<SelectItemOption<String>> getNodeType() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption("nt:unstructured", (Object)"nt:unstructured"));
        options.add(new SelectItemOption("nt:folder", (Object)"nt:folder"));
        return options;
    }

    protected void setFieldName(String name) {
        this.getUIStringInput(FIELD_NAME).setValue((Object)name);
    }

    protected String getFieldName() {
        return (String)this.getUIStringInput(FIELD_NAME).getValue();
    }

    protected String getFieldNodeType() {
        return (String)this.getUIFormSelectBox(FIELD_NODETYPE).getValue();
    }

    protected void setFieldNodeTypeSelected(String selectedValue) {
        this.getUIFormSelectBox(FIELD_NODETYPE).setValue(selectedValue);
    }

    protected void setFieldNodeType(List<SelectItemOption<String>> options) {
        this.getUIFormSelectBox(FIELD_NODETYPE).setOptions(options);
    }

    protected boolean getFieldDefault() {
        return this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).isChecked();
    }

    protected void setFieldDefault(boolean isDefault) {
        this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setChecked(isDefault);
    }

    protected void setFieldLockTime(String lockTime) {
        this.getUIStringInput(FIELD_TIMEOUT).setValue((Object)lockTime);
    }

    protected String getFieldLockTime() {
        return (String)this.getUIStringInput(FIELD_TIMEOUT).getValue();
    }

    protected void resetFields() {
        this.reset();
        this.setFieldDefault(false);
        this.setFieldNodeType(this.getNodeType());
    }

    protected void fillFields(String name, String selectedNodeType, boolean isDefaultWS, String permission, String lockTime) {
        this.setFieldName(name);
        this.setPermissionMap(permission);
        this.refreshPermissionList();
        this.setFieldDefault(isDefaultWS);
        this.setFieldNodeTypeSelected(selectedNodeType);
        this.setFieldLockTime(lockTime);
    }

    protected void lockFields(boolean isLock) {
        boolean isEdiable = !isLock;
        this.setIsView(isLock);
        this.getUIStringInput(FIELD_NAME).setEditable(isEdiable);
        this.getUIFormSelectBox(FIELD_NODETYPE).setEnable(isEdiable);
        this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setEnable(isEdiable);
        this.getUIStringInput(FIELD_TIMEOUT).setEditable(isEdiable);
        this.showActionInfo(isEdiable);
    }

    public void setPermissionMap(String permission) {
        if (permission != null) {
            ArrayList<String> userList = new ArrayList<String>();
            for (String perm : permission.split(";")) {
                String userName = perm.substring(0, perm.lastIndexOf(" "));
                if (userList.contains(userName)) continue;
                userList.add(userName);
            }
            for (String user : userList) {
                StringBuilder sb = new StringBuilder();
                for (String perm : permission.split(";")) {
                    if (!perm.contains(user)) continue;
                    if (sb.length() > 1) {
                        sb.append(";");
                    }
                    sb.append(perm);
                }
                this.permissions_.put(user, sb.toString());
            }
        }
    }

    public void refreshPermissionList() {
        StringBuilder labels = new StringBuilder();
        for (String perm : this.permissions_.keySet()) {
            if (labels.length() > 0) {
                labels.append(",");
            }
            labels.append(perm);
        }
        this.setInfoField(FIELD_PERMISSION, labels.toString());
    }

    protected void addPermissions(String user, String permissions) {
        this.permissions_.put(user, permissions);
    }

    protected void removePermission(String perm) {
        this.permissions_.remove(perm);
    }

    protected boolean isPermissionEmpty() {
        return this.permissions_.isEmpty();
    }

    protected Map<String, String> getPermissions() {
        return this.permissions_;
    }
}

