/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContentPortlet;
import org.exoplatform.ecm.webui.component.browsecontent.UIConfigTabPane;
import org.exoplatform.ecm.webui.component.browsecontent.UINewConfigForm;
import org.exoplatform.ecm.webui.component.browsecontent.UIQueryConfig;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.NumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeLangActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeStatusActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeTypeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={EditActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={BackActionListener.class})})
public class UIQueryConfig
extends UIForm {
    private final String xpathDefault_ = "/jcr:root/Documents/Live//element(*, exo:article)";
    private final String sqlDefault_ = "select * from exo:article where jcr:path like '/Documents/Live%'";
    private static final String NEW_QUERY = "New Query".intern();
    private static final String EXISTING_QUERY = "Existing Query".intern();
    private static final String PERSONAL_QUERY = "Personal Query".intern();
    private static final String SHARED_QUERY = "Shared Query".intern();
    private static final String EMPTYQUERY = "Query not found".intern();
    protected boolean isEdit_ = false;

    public UIQueryConfig() throws Exception {
        ArrayList Options = new ArrayList();
        this.addChild((UIComponent)new UIFormStringInput("repository", "repository", null));
        this.addChild((UIComponent)new UIFormStringInput("workspace", "workspace", null));
        this.addChild((UIComponent)new UIFormSelectBox("queryStatus", null, Options));
        this.addChild((UIComponent)new UIFormSelectBox("queryLanguage", null, Options));
        this.addChild(new UIFormSelectBox("queryType", null, Options).setRendered(false));
        this.addChild(new UIFormSelectBox("queryStore", null, Options).setRendered(false));
        this.addChild((UIComponent)new UIFormTextAreaInput("query", null, null));
        this.addChild((UIComponent)new UIFormSelectBox("template", null, Options));
        this.addChild((UIComponent)new UIFormStringInput("itemPerPage", "itemPerPage", null).addValidator(NumberFormatValidator.class, new Object[0]));
        this.addChild((UIComponent)new UIFormSelectBox("detailBoxTemp", null, Options));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableTagMap", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableComment", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableVote", null, null));
        this.setActions(UINewConfigForm.DEFAULT_ACTION);
    }

    public PortletPreferences getPortletPreferences() {
        return ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPortletPreferences();
    }

    public void initForm(PortletPreferences preference, String repository, String workSpace, boolean isAddNew) throws Exception {
        String queryLang = "sql";
        String queryType = PERSONAL_QUERY;
        String queryStoreName = null;
        String queryStatement = "select * from exo:article where jcr:path like '/Documents/Live%'";
        String queryNew = "true";
        String hasComment = "false";
        String hasVote = "false";
        String hasTagMap = "false";
        String itemPerPage = null;
        String detailTemp = "";
        String template = "";
        UIFormStringInput workSpaceField = (UIFormStringInput)this.getChildById("workspace");
        workSpaceField.setValue((Object)workSpace);
        workSpaceField.setEditable(false);
        UIFormStringInput repositoryField = (UIFormStringInput)this.getChildById("repository");
        repositoryField.setValue((Object)repository);
        repositoryField.setEditable(false);
        UIFormSelectBox queryStatusField = (UIFormSelectBox)this.getChildById("queryStatus");
        UIFormSelectBox queryLangField = (UIFormSelectBox)this.getChildById("queryLanguage");
        UIFormSelectBox queryTypeField = (UIFormSelectBox)this.getChildById("queryType");
        UIFormSelectBox queryStoreField = (UIFormSelectBox)this.getChildById("queryStore");
        UIFormTextAreaInput queryField = (UIFormTextAreaInput)this.getChildById("query");
        UIFormSelectBox templateField = (UIFormSelectBox)this.getChildById("template");
        UIFormStringInput numbPerPageField = (UIFormStringInput)this.getChildById("itemPerPage");
        UIFormSelectBox detailtemField = (UIFormSelectBox)this.getChildById("detailBoxTemp");
        UIFormCheckBoxInput enableTagMapField = (UIFormCheckBoxInput)this.getChildById("enableTagMap");
        UIFormCheckBoxInput enableCommentField = (UIFormCheckBoxInput)this.getChildById("enableComment");
        UIFormCheckBoxInput enableVoteField = (UIFormCheckBoxInput)this.getChildById("enableVote");
        if (this.isEdit_) {
            if (isAddNew) {
                this.setActions(UINewConfigForm.ADD_NEW_ACTION);
                templateField.setOptions(this.getQueryTemplate(repository));
                UIConfigTabPane uiConfigTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
                detailtemField.setOptions(uiConfigTabPane.getBoxTemplateOption(repository));
                queryStatusField.setOptions(this.getQueryStatus());
                queryStatusField.setValue(NEW_QUERY);
                queryLangField.setOptions(this.getQueryLang());
                queryLangField.setValue(queryLang);
                queryTypeField.setOptions(this.getQueryType());
                queryTypeField.setValue(queryType);
                this.onchangeAction((String)queryStatusField.getValue(), (String)queryTypeField.getValue(), (String)queryLangField.getValue(), null, queryStatement);
                numbPerPageField.setValue((Object)itemPerPage);
                enableTagMapField.setChecked(Boolean.parseBoolean(hasTagMap));
                enableCommentField.setChecked(Boolean.parseBoolean(hasComment));
                enableVoteField.setChecked(Boolean.parseBoolean(hasVote));
                queryStatusField.setOptions(this.getQueryStatus());
            } else {
                this.setActions(UINewConfigForm.NORMAL_ACTION);
            }
        } else {
            this.setActions(UINewConfigForm.DEFAULT_ACTION);
            repository = preference.getValue(Utils.REPOSITORY, "");
            queryNew = preference.getValue(Utils.CB_QUERY_ISNEW, "");
            queryType = preference.getValue(Utils.CB_QUERY_TYPE, "");
            queryStoreName = preference.getValue(Utils.CB_QUERY_STORE, "");
            queryStatement = preference.getValue(Utils.CB_QUERY_STATEMENT, "");
            queryLang = preference.getValue(Utils.CB_QUERY_LANGUAGE, "");
            itemPerPage = preference.getValue(Utils.CB_NB_PER_PAGE, "");
            hasTagMap = preference.getValue(Utils.CB_VIEW_TAGMAP, "");
            hasComment = preference.getValue(Utils.CB_VIEW_COMMENT, "");
            detailTemp = preference.getValue(Utils.CB_BOX_TEMPLATE, "");
            hasVote = preference.getValue(Utils.CB_VIEW_VOTE, "");
            template = preference.getValue("template", "");
            templateField.setOptions(this.getQueryTemplate(repository));
            templateField.setValue(template);
            numbPerPageField.setValue((Object)itemPerPage);
            UIConfigTabPane uiConfigTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
            detailtemField.setOptions(uiConfigTabPane.getBoxTemplateOption(repository));
            detailtemField.setValue(detailTemp);
            enableTagMapField.setChecked(Boolean.parseBoolean(hasTagMap));
            enableCommentField.setChecked(Boolean.parseBoolean(hasComment));
            enableVoteField.setChecked(Boolean.parseBoolean(hasVote));
            queryStatusField.setOptions(this.getQueryStatus());
            queryStatusField.setValue(EXISTING_QUERY);
            if (Boolean.parseBoolean(queryNew)) {
                queryStatusField.setValue(NEW_QUERY);
            }
            queryLangField.setOptions(this.getQueryLang());
            queryLangField.setValue(queryLang);
            queryTypeField.setOptions(this.getQueryType());
            queryTypeField.setValue(queryType);
            queryStoreField.setValue(queryStoreName);
            this.onchangeAction((String)queryStatusField.getValue(), (String)queryTypeField.getValue(), (String)queryLangField.getValue(), queryStoreName, queryStatement);
        }
        queryStatusField.setOnChange("ChangeStatus");
        queryLangField.setOnChange("ChangeLang");
        queryTypeField.setOnChange("ChangeType");
        queryStatusField.setEnable(this.isEdit_);
        queryLangField.setEnable(this.isEdit_);
        queryTypeField.setEnable(this.isEdit_);
        queryStoreField.setEnable(this.isEdit_);
        queryField.setEditable(this.isEdit_);
        numbPerPageField.setEditable(this.isEdit_);
        templateField.setEnable(this.isEdit_);
        detailtemField.setEnable(this.isEdit_);
        enableTagMapField.setEnable(this.isEdit_);
        enableCommentField.setEnable(this.isEdit_);
        enableVoteField.setEnable(this.isEdit_);
    }

    protected void onchangeAction(String queryStatus, String queryType, String queryLanguage, String queryStoreName, String queryStatement) throws Exception {
        boolean isNewquery = queryStatus.equals(NEW_QUERY);
        UIFormSelectBox queryStore = (UIFormSelectBox)this.getChildById("queryStore");
        UIFormSelectBox queryTypeField = (UIFormSelectBox)this.getChildById("queryType");
        UIFormTextAreaInput queryField = (UIFormTextAreaInput)this.getChildById("query");
        if (isNewquery) {
            if (queryLanguage.equals("xpath")) {
                if (queryStatement == null) {
                    queryStatement = "/jcr:root/Documents/Live//element(*, exo:article)";
                }
                queryField.setValue((Object)queryStatement);
            } else if (queryLanguage.equals("sql")) {
                if (queryStatement == null) {
                    queryStatement = "select * from exo:article where jcr:path like '/Documents/Live%'";
                }
                queryField.setValue((Object)queryStatement);
            }
        } else {
            queryStore.setOptions(this.getQueryStore(queryType, queryLanguage));
            if (queryStoreName != null) {
                queryStore.setValue(queryStoreName);
            }
        }
        queryStore.setRendered(!isNewquery);
        queryTypeField.setRendered(!isNewquery);
        queryField.setRendered(isNewquery);
    }

    private List<SelectItemOption<String>> getQueryTemplate(String repository) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List querylTemplates = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getAllTemplates("cbQueryTemplates", repository, SessionsUtils.getSystemProvider());
        for (Node node : querylTemplates) {
            options.add((SelectItemOption<String>)new SelectItemOption(node.getName(), (Object)node.getName()));
        }
        Collections.sort(options, new Utils.ItemOptionNameComparator());
        return options;
    }

    public List<SelectItemOption<String>> getWorkSpaceOption() throws Exception {
        UIConfigTabPane uiTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
        return uiTabPane.getWorkSpaceOption();
    }

    private List<SelectItemOption<String>> getQueryLang() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption("sql", (Object)"sql"));
        options.add(new SelectItemOption("xpath", (Object)"xpath"));
        return options;
    }

    private List<SelectItemOption<String>> getQueryStatus() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(NEW_QUERY, (Object)NEW_QUERY));
        options.add(new SelectItemOption(EXISTING_QUERY, (Object)EXISTING_QUERY));
        return options;
    }

    private List<SelectItemOption<String>> getQueryType() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(SHARED_QUERY, (Object)SHARED_QUERY));
        options.add(new SelectItemOption(PERSONAL_QUERY, (Object)PERSONAL_QUERY));
        return options;
    }

    private List<SelectItemOption<String>> getQueryStore(String queryType, String queryLanguage) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        String repository = (String)this.getUIStringInput("repository").getValue();
        QueryService qservice = (QueryService)this.getApplicationComponent(QueryService.class);
        SessionProvider provider = SessionsUtils.getSystemProvider();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        if (PERSONAL_QUERY.equals(queryType)) {
            List queries = qservice.getQueries(userId, repository, provider);
            for (Query queryNode : queries) {
                String path = queryNode.getStoredQueryPath();
                if (!queryNode.getLanguage().equals(queryLanguage)) continue;
                options.add((SelectItemOption<String>)new SelectItemOption(path.substring(path.lastIndexOf("/") + 1), (Object)path));
            }
        } else {
            List queries = qservice.getSharedQueries(queryLanguage, userId, repository, provider);
            for (Node queryNode : queries) {
                options.add((SelectItemOption<String>)new SelectItemOption(queryNode.getName(), (Object)queryNode.getPath()));
            }
        }
        if (options.isEmpty()) {
            options.add(new SelectItemOption(EMPTYQUERY, (Object)EMPTYQUERY));
        }
        Collections.sort(options, new Utils.ItemOptionNameComparator());
        return options;
    }

    public Session getSession() throws Exception {
        String repositoryName = (String)this.getUIStringInput("repository").getValue();
        String workspace = (String)this.getUIStringInput("workspace").getValue();
        ManageableRepository repository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repositoryName);
        if (SessionsUtils.isAnonim()) {
            return SessionsUtils.getAnonimProvider().getSession(workspace, repository);
        }
        return SessionsUtils.getSessionProvider().getSession(workspace, repository);
    }

    static /* synthetic */ String access$000() {
        return NEW_QUERY;
    }

    static /* synthetic */ String access$100() {
        return EMPTYQUERY;
    }
}

