/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.jcr.SearchValidator;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/control/UIActionBar.gtmpl", events={@EventConfig(listeners={AddFolderActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddDocumentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={EditDocumentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UploadActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={WatchDocumentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={TaggingDocumentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MultiLanguageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ViewReferencesActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ViewNodeTypeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ViewPermissionsActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ViewPropertiesActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ViewRelationsActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowJCRStructureActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ManageVersionsActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ManagePublicationsActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ManageCategoriesActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ManageRelationsActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ManageActionsActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ExportNodeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ImportNodeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SimpleSearchActionListener.class}), @EventConfig(listeners={AdvanceSearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SavedQueriesActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ViewMetadatasActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={VoteActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CommentActionListener.class}, phase=Event.Phase.DECODE)})
public class UIActionBar
extends UIForm {
    private Node view_;
    private String templateName_;
    private List<SelectItemOption<String>> tabOptions = new ArrayList();
    private List<String[]> tabs_ = new ArrayList();
    private static final String FIELD_SELECT_TAB = "tabs";
    private static final String FIELD_SIMPLE_SEARCH = "simpleSearch";
    private static final String FIELD_ADVANCE_SEARCH = "advanceSearch";
    private static final String FIELD_SEARCH_TYPE = "searchType";
    private static final String OPT_SEARCH = "Search";
    private static final String FIELD_SQL = "SQL";
    private static final String FIELD_XPATH = "xPath";
    private static final String ROOT_SQL_QUERY = "select * from nt:base where contains(*, '$1') order by exo:dateCreated DESC, jcr:primaryType DESC";
    private static final String SQL_QUERY = "select * from nt:base where jcr:path like '$0/%' and contains(*, '$1') order by jcr:path DESC, jcr:primaryType DESC";

    public UIActionBar() throws Exception {
        UIFormSelectBox selectTab = new UIFormSelectBox(FIELD_SELECT_TAB, FIELD_SELECT_TAB, this.tabOptions);
        selectTab.setOnChange("ChangeTab");
        this.addUIFormInput((UIFormInput)selectTab);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SIMPLE_SEARCH, FIELD_SIMPLE_SEARCH, null).addValidator(SearchValidator.class, new Object[0]));
        ArrayList<SelectItemOption> typeOptions = new ArrayList<SelectItemOption>();
        typeOptions.add(new SelectItemOption(FIELD_SQL, (Object)"sql"));
        typeOptions.add(new SelectItemOption(FIELD_XPATH, (Object)"xpath"));
        this.addChild((UIComponent)new UIFormSelectBox(FIELD_SEARCH_TYPE, FIELD_SEARCH_TYPE, typeOptions));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_ADVANCE_SEARCH, FIELD_ADVANCE_SEARCH, null));
    }

    public void setTabOptions(String viewName) throws Exception {
        this.tabOptions.clear();
        this.tabs_.clear();
        this.tabs_ = new ArrayList();
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        this.view_ = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getViewByName(viewName, repository, SessionsUtils.getSystemProvider());
        NodeIterator tabs = this.view_.getNodes();
        int i = 0;
        while (tabs.hasNext()) {
            Node tab = tabs.nextNode();
            this.tabOptions.add(new SelectItemOption(tab.getName(), (Object)String.valueOf(i++)));
            this.setListButton(tab.getName());
        }
        this.tabOptions.add(new SelectItemOption(OPT_SEARCH, (Object)String.valueOf(i++)));
        this.getUIFormSelectBox(FIELD_SELECT_TAB).setOptions(this.tabOptions).setValue((String)((SelectItemOption)this.tabOptions.get(0)).getValue());
        String template = this.view_.getProperty("exo:template").getString();
        this.templateName_ = template.substring(template.lastIndexOf("/") + 1);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        uiExplorer.setRenderTemplate(template);
    }

    public String getTemplateName() {
        return this.templateName_;
    }

    private void setListButton(String tabName) throws PathNotFoundException, RepositoryException {
        Node tabNode = this.view_.getNode(tabName);
        if (tabNode.hasProperty("exo:buttons")) {
            String buttons = tabNode.getProperty("exo:buttons").getString();
            String[] buttonsInTab = StringUtils.split((String)buttons, (String)";");
            for (int j = 0; j < buttonsInTab.length; ++j) {
                String buttonName = buttonsInTab[j].trim();
                buttonsInTab[j] = buttonName = buttonName.substring(0, 1).toUpperCase() + buttonName.substring(1);
            }
            this.tabs_.add(buttonsInTab);
        }
    }

    public List<String[]> getTabs() throws Exception {
        return this.tabs_;
    }

    public int getSelectedTab() {
        return Integer.parseInt((String)this.getUIFormSelectBox(FIELD_SELECT_TAB).getValue());
    }

    public List<Query> getSavedQueries() throws Exception {
        String userName = Util.getPortalRequestContext().getRemoteUser();
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        return ((QueryService)this.getApplicationComponent(QueryService.class)).getQueries(userName, repository, SessionsUtils.getSystemProvider());
    }

    public List<String> getMetadataTemplates() throws Exception {
        NodeType[] nodeTypes;
        MetadataService metadataService = (MetadataService)this.getApplicationComponent(MetadataService.class);
        Node node = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        ArrayList<String> templates = new ArrayList<String>();
        for (NodeType nt : nodeTypes = node.getMixinNodeTypes()) {
            if (!metadataService.getMetadataList(repository).contains(nt.getName())) continue;
            templates.add(metadataService.getMetadataPath(nt.getName(), false, repository));
        }
        Item primaryItem = null;
        try {
            primaryItem = node.getPrimaryItem();
        }
        catch (ItemNotFoundException e) {
            // empty catch block
        }
        if (primaryItem != null && primaryItem.isNode()) {
            NodeType[] primaryTypes;
            Node primaryNode = (Node)node.getPrimaryItem();
            for (NodeType nt : primaryTypes = primaryNode.getMixinNodeTypes()) {
                if (!metadataService.getMetadataList(repository).contains(nt.getName())) continue;
                templates.add(metadataService.getMetadataPath(nt.getName(), false, repository));
            }
        }
        return templates;
    }

    private boolean isRootNode(Node node) throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRootNode().equals(node);
    }

    static /* synthetic */ boolean access$000(UIActionBar x0, Node x1) throws Exception {
        return x0.isRootNode(x1);
    }
}

