/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeForm;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeOptionList;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormTableInputSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/webui/form/UIFormInputSetWithAction.gtmpl", events={@EventConfig(listeners={AddTypeActionListener.class})})
public class UINodeTypeOptionList
extends UIFormInputSetWithAction {
    static final String TABLE_NAME = "UINodeTypeOptionList";
    static final String[] TABLE_COLUMNS = new String[]{"label", "input"};

    public UINodeTypeOptionList(String name) throws Exception {
        super(name);
        this.setComponentConfig(this.getClass(), null);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
    }

    private boolean getCheckedValue(String values, String name) {
        String[] selectNodes = values.split(",");
        for (int i = 0; i < selectNodes.length; ++i) {
            if (!selectNodes[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public void update(String values) throws Exception {
        UIFormTableInputSet uiTableInputSet = (UIFormTableInputSet)this.createUIComponent(UIFormTableInputSet.class, null, null);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        ExtendedNodeTypeManager ntManager = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getNodeTypeManager();
        NodeTypeIterator nodeTypeIter = ntManager.getAllNodeTypes();
        ArrayList<NodeType> nodeTypeList = new ArrayList<NodeType>();
        while (nodeTypeIter.hasNext()) {
            NodeType nt = nodeTypeIter.nextNodeType();
            nodeTypeList.add(nt);
        }
        Collections.sort(nodeTypeList, new Utils.NodeTypeNameComparator());
        uiTableInputSet.setName(TABLE_NAME);
        uiTableInputSet.setColumns(TABLE_COLUMNS);
        for (NodeType nt : nodeTypeList) {
            String ntName = nt.getName();
            UIFormInputSet uiInputSet = new UIFormInputSet(ntName);
            UIFormInputInfo uiInfo = new UIFormInputInfo("label", null, ntName);
            uiInputSet.addChild((UIComponent)uiInfo);
            UIFormCheckBoxInput uiCheckbox = new UIFormCheckBoxInput(ntName, ntName, null);
            if (values != null) {
                if (this.getCheckedValue(values, ntName)) {
                    uiCheckbox.setChecked(true);
                }
            } else {
                uiCheckbox.setChecked(false);
            }
            uiCheckbox.setValue((Object)ntName);
            uiInputSet.addChild((UIComponent)uiCheckbox);
            uiTableInputSet.addChild((UIComponent)uiInputSet);
        }
        this.addUIFormInput((UIFormInputSet)uiTableInputSet);
    }

    private void setFieldValues(String fieldName, List<String> selectedNodes) throws Exception {
        String strNodeList = null;
        UINodeTypeForm uiNodeTypeForm = (UINodeTypeForm)this.getParent();
        for (int i = 0; i < selectedNodes.size(); ++i) {
            strNodeList = strNodeList == null ? selectedNodes.get(i) : strNodeList + "," + selectedNodes.get(i);
        }
        uiNodeTypeForm.getUIStringInput(fieldName).setValue(strNodeList);
        if (fieldName.equals("superTypes")) {
            for (UIComponent uiComp : uiNodeTypeForm.getChildren()) {
                UIFormInputSetWithAction tab = (UIFormInputSetWithAction)uiNodeTypeForm.getChildById(uiComp.getId());
                if (!tab.getId().equals("nodeTypeDefinition")) continue;
                uiNodeTypeForm.setSelectedTab(tab.getId());
            }
            uiNodeTypeForm.removeChildById("SuperTypeTab");
        } else if (fieldName.equals("requiredPrimaryType")) {
            for (UIComponent uiComp : uiNodeTypeForm.getChildren()) {
                UIFormInputSetWithAction tab = (UIFormInputSetWithAction)uiNodeTypeForm.getChildById(uiComp.getId());
                if (!tab.getId().equals("childNodeDefinition")) continue;
                uiNodeTypeForm.setSelectedTab(tab.getId());
            }
            uiNodeTypeForm.removeChildById("RequiredTypeTab");
        } else if (fieldName.equals("defaultPrimaryType")) {
            for (UIComponent uiComp : uiNodeTypeForm.getChildren()) {
                UIFormInputSetWithAction tab = (UIFormInputSetWithAction)uiNodeTypeForm.getChildById(uiComp.getId());
                if (!tab.getId().equals("childNodeDefinition")) continue;
                uiNodeTypeForm.setSelectedTab(tab.getId());
            }
            uiNodeTypeForm.removeChildById("DefaultTypeTab");
        }
    }

    static /* synthetic */ void access$000(UINodeTypeOptionList x0, String x1, List x2) throws Exception {
        x0.setFieldValues(x1, x2);
    }
}

