/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.jcr.model.VersionNode;
import org.exoplatform.ecm.webui.component.admin.views.UITemplateForm;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RestoreActionListener.class})})
public class UITemplateForm
extends UIForm {
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_CONTENT = "content";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_HOMETEMPLATE = "homeTemplate";
    private static final String FIELD_ENABLEVERSION = "enableVersion";
    private Node template_ = null;
    private List<String> listVersion = new ArrayList();
    private Version baseVersion_;
    private VersionNode selectedVersion_;
    public boolean isAddNew_ = false;
    private String templatePath_;
    private VersionNode rootVersionNode;

    public UITemplateForm() throws Exception {
        ArrayList options = new ArrayList();
        UIFormSelectBox versions = new UIFormSelectBox(FIELD_VERSION, FIELD_VERSION, options);
        versions.setOnChange("Change");
        versions.setRendered(false);
        this.addUIFormInput((UIFormInput)versions);
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_CONTENT, FIELD_CONTENT, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(ECMNameValidator.class, new Object[0]));
        ArrayList typeList = new ArrayList();
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_HOMETEMPLATE, FIELD_HOMETEMPLATE, typeList));
        UIFormCheckBoxInput enableVersion = new UIFormCheckBoxInput(FIELD_ENABLEVERSION, FIELD_ENABLEVERSION, null);
        enableVersion.setRendered(false);
        this.addUIFormInput((UIFormInput)enableVersion);
    }

    public String getRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        return portletPref.getValue(Utils.REPOSITORY, "");
    }

    public void updateOptionList() throws Exception {
        this.getUIFormSelectBox(FIELD_HOMETEMPLATE).setOptions(this.getOptionList());
    }

    public List<SelectItemOption<String>> getOptionList() throws Exception {
        ArrayList<SelectItemOption<String>> typeList = new ArrayList<SelectItemOption<String>>();
        String repository = this.getRepository();
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        if (this.getId().equalsIgnoreCase("ECMTempForm")) {
            Node ecmTemplateHome = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getTemplateHome("ecmExplorerTemplates", repository, provider);
            if (ecmTemplateHome != null) {
                typeList.add((SelectItemOption<String>)new SelectItemOption(ecmTemplateHome.getName(), (Object)ecmTemplateHome.getPath()));
            }
        } else {
            Node cbTemplateHome = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getTemplateHome("contentBrowserTemplates", repository, provider);
            if (cbTemplateHome != null) {
                NodeIterator iter = cbTemplateHome.getNodes();
                while (iter.hasNext()) {
                    Node template = iter.nextNode();
                    typeList.add((SelectItemOption<String>)new SelectItemOption(template.getName(), (Object)template.getPath()));
                }
            }
        }
        return typeList;
    }

    public boolean canEnableVersionning(Node node) throws Exception {
        return node.canAddMixin("mix:versionable");
    }

    private boolean isVersioned(Node node) throws RepositoryException {
        return node.isNodeType("mix:versionable");
    }

    private VersionNode getRootVersion(Node node) throws Exception {
        VersionHistory vH = node.getVersionHistory();
        return vH != null ? new VersionNode(vH.getRootVersion(), node.getSession()) : null;
    }

    private List<String> getNodeVersions(List<VersionNode> children) throws Exception {
        List child = new ArrayList();
        for (VersionNode vNode : children) {
            this.listVersion.add(vNode.getName());
            child = vNode.getChildren();
            if (child.isEmpty()) continue;
            this.getNodeVersions(child);
        }
        return this.listVersion;
    }

    private List<SelectItemOption<String>> getVersionValues(Node node) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        List children = this.getRootVersion(node).getChildren();
        this.listVersion.clear();
        List versionList = this.getNodeVersions(children);
        for (int i = 0; i < versionList.size(); ++i) {
            for (int j = i + 1; j < versionList.size(); ++j) {
                if (Integer.parseInt((String)versionList.get(j)) >= Integer.parseInt((String)versionList.get(i))) continue;
                String temp = (String)versionList.get(i);
                versionList.set(i, versionList.get(j));
                versionList.set(j, temp);
            }
            options.add((SelectItemOption<String>)new SelectItemOption((String)versionList.get(i), versionList.get(i)));
        }
        return options;
    }

    public void refresh() throws Exception {
        UIFormSelectBox versionField = this.getUIFormSelectBox(FIELD_VERSION);
        if (this.isAddNew_) {
            versionField.setRendered(false);
            this.getUIFormTextAreaInput(FIELD_CONTENT).setValue(null);
            this.getUIStringInput(FIELD_NAME).setEditable(true).setValue(null);
            this.getUIFormSelectBox(FIELD_HOMETEMPLATE).setValue(null);
            this.getUIFormSelectBox(FIELD_HOMETEMPLATE).setDisabled(false);
            this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setRendered(false);
            this.template_ = null;
            this.selectedVersion_ = null;
            this.baseVersion_ = null;
            return;
        }
        this.update(this.template_.getPath(), null);
    }

    public void update(String templatePath, VersionNode selectedVersion) throws Exception {
        if (templatePath != null) {
            String repository = this.getRepository();
            this.templatePath_ = templatePath;
            this.template_ = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getTemplate(templatePath, repository, SessionProviderFactory.createSessionProvider());
            this.getUIStringInput(FIELD_NAME).setValue((Object)this.template_.getName());
            this.getUIStringInput(FIELD_NAME).setEditable(false);
            String value = templatePath.substring(0, templatePath.lastIndexOf("/"));
            this.getUIFormSelectBox(FIELD_HOMETEMPLATE).setValue(value);
            this.getUIFormSelectBox(FIELD_HOMETEMPLATE).setDisabled(false);
            this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setRendered(true);
            if (this.isVersioned(this.template_)) {
                this.rootVersionNode = this.getRootVersion(this.template_);
                this.baseVersion_ = this.template_.getBaseVersion();
                List options = this.getVersionValues(this.template_);
                this.getUIFormSelectBox(FIELD_VERSION).setOptions(options).setRendered(true);
                this.getUIFormSelectBox(FIELD_VERSION).setValue(this.baseVersion_.getName());
                this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setChecked(true).setEnable(false);
                if (options.size() > 1) {
                    this.setActions(new String[]{"Save", "Reset", "Restore", "Cancel"});
                } else {
                    this.setActions(new String[]{"Save", "Reset", "Cancel"});
                }
            } else if (this.canEnableVersionning(this.template_)) {
                this.getUIFormSelectBox(FIELD_VERSION).setRendered(false);
                this.getUIFormCheckBoxInput(FIELD_ENABLEVERSION).setChecked(false).setEditable(true);
            }
        }
        if (selectedVersion != null) {
            this.template_.restore(selectedVersion.getVersion(), false);
            this.selectedVersion_ = selectedVersion;
            Object[] args = new Object[]{this.getUIStringInput(FIELD_VERSION).getValue()};
            UIApplication app = (UIApplication)this.getAncestorOfType(UIApplication.class);
            app.addMessage(new ApplicationMessage("UITemplateForm.msg.version-restored", args));
        }
        String content = this.template_.getProperty("exo:templateFile").getString();
        this.getUIFormTextAreaInput(FIELD_CONTENT).setValue((Object)content);
    }

    static /* synthetic */ Node access$000(UITemplateForm x0) {
        return x0.template_;
    }

    static /* synthetic */ String access$100(UITemplateForm x0) {
        return x0.templatePath_;
    }

    static /* synthetic */ Node access$002(UITemplateForm x0, Node x1) {
        x0.template_ = x1;
        return x0.template_;
    }

    static /* synthetic */ VersionNode access$200(UITemplateForm x0) {
        return x0.selectedVersion_;
    }

    static /* synthetic */ Version access$300(UITemplateForm x0) {
        return x0.baseVersion_;
    }

    static /* synthetic */ VersionNode access$400(UITemplateForm x0) {
        return x0.rootVersionNode;
    }
}

