/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIWatchDocumentForm;
import org.exoplatform.ecm.webui.popup.UIPopupComponent;
import org.exoplatform.services.cms.watch.WatchDocumentService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={WatchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UnwatchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIWatchDocumentForm
extends UIForm
implements UIPopupComponent {
    public static final String NOTIFICATION_TYPE = "notificationType";
    public static final String NOTIFICATION_BY_EMAIL = "Email";
    public static final String NOTIFICATION_BY_RSS = "RSS";

    public UIWatchDocumentForm() throws Exception {
        ArrayList options = new ArrayList();
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(NOTIFICATION_TYPE, NOTIFICATION_TYPE, options);
        this.addUIFormInput((UIFormInput)uiSelectBox);
    }

    public Node getWatchNode() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
    }

    public String getUserName() {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    public boolean isWatching() throws Exception {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        WatchDocumentService watchService = (WatchDocumentService)this.getApplicationComponent(WatchDocumentService.class);
        int notifyType = watchService.getNotificationType(this.getWatchNode(), this.getUserName());
        if (notifyType == 0) {
            options.add(new SelectItemOption(NOTIFICATION_BY_EMAIL, (Object)NOTIFICATION_BY_EMAIL));
            this.getUIFormSelectBox(NOTIFICATION_TYPE).setOptions(options);
            return true;
        }
        if (notifyType == 1) {
            options.add(new SelectItemOption(NOTIFICATION_BY_EMAIL, (Object)NOTIFICATION_BY_EMAIL));
            this.getUIFormSelectBox(NOTIFICATION_TYPE).setOptions(options);
            return true;
        }
        options.add(new SelectItemOption(NOTIFICATION_BY_EMAIL, (Object)NOTIFICATION_BY_EMAIL));
        this.getUIFormSelectBox(NOTIFICATION_TYPE).setOptions(options);
        return false;
    }

    public int getNotifyType() throws Exception {
        WatchDocumentService watchService = (WatchDocumentService)this.getApplicationComponent(WatchDocumentService.class);
        return watchService.getNotificationType(this.getWatchNode(), this.getUserName());
    }

    public void activate() throws Exception {
        if (!this.isWatching()) {
            this.setActions(new String[]{"Watch", "Cancel"});
        } else {
            this.setActions(new String[]{"Unwatch", "Cancel"});
        }
    }

    public void deActivate() throws Exception {
    }
}

