/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UIConstraintsForm;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchContainer;
import org.exoplatform.ecm.webui.component.explorer.search.UISimpleSearch;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/search/UIConstraintsForm.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={CompareExactlyActionListener.class}), @EventConfig(listeners={AddMetadataTypeActionListener.class}), @EventConfig(listeners={AddNodeTypeActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class})})
public class UIConstraintsForm
extends UIForm
implements UISelectable {
    public static final String OPERATOR = "operator";
    public static final String TIME_OPTION = "timeOpt";
    public static final String PROPERTY1 = "property1";
    public static final String PROPERTY2 = "property2";
    public static final String PROPERTY3 = "property3";
    public static final String CONTAIN_EXACTLY = "containExactly";
    public static final String CONTAIN = "contain";
    public static final String NOT_CONTAIN = "notContain";
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String DOC_TYPE = "docType";
    public static final String CATEGORY_TYPE = "categoryType";
    public static final String AND_OPERATION = "and";
    public static final String OR_OPERATION = "or";
    public static final String CREATED_DATE = "CREATED";
    public static final String MODIFIED_DATE = "MODIFIED";
    public static final String EXACTLY_PROPERTY = "exactlyPro";
    public static final String CONTAIN_PROPERTY = "containPro";
    public static final String NOT_CONTAIN_PROPERTY = "notContainPro";
    public static final String DATE_PROPERTY = "datePro";
    public static final String NODETYPE_PROPERTY = "nodetypePro";
    public static final String CATEGORY_PROPERTY = "categoryPro";
    private static final String SPLIT_REGEX = "/|\\s+|:";
    private static final String DATETIME_REGEX = "^(\\d{1,2}\\/\\d{1,2}\\/\\d{1,4})\\s*(\\s+\\d{1,2}:\\d{1,2}:\\d{1,2})?$";
    private String virtualDateQuery_;

    public UIConstraintsForm() throws Exception {
        this.setActions(new String[]{"Add", "Cancel"});
        ArrayList<SelectItemOption> typeOperation = new ArrayList<SelectItemOption>();
        typeOperation.add(new SelectItemOption(AND_OPERATION, (Object)AND_OPERATION));
        typeOperation.add(new SelectItemOption(OR_OPERATION, (Object)OR_OPERATION));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(OPERATOR, OPERATOR, typeOperation));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(EXACTLY_PROPERTY, EXACTLY_PROPERTY, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PROPERTY1, PROPERTY1, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CONTAIN_EXACTLY, CONTAIN_EXACTLY, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(CONTAIN_PROPERTY, CONTAIN_PROPERTY, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PROPERTY2, PROPERTY2, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CONTAIN, CONTAIN, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(NOT_CONTAIN_PROPERTY, NOT_CONTAIN_PROPERTY, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(PROPERTY3, PROPERTY3, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(NOT_CONTAIN, NOT_CONTAIN, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(DATE_PROPERTY, DATE_PROPERTY, null));
        ArrayList<SelectItemOption> dateOperation = new ArrayList<SelectItemOption>();
        dateOperation.add(new SelectItemOption(CREATED_DATE, (Object)CREATED_DATE));
        dateOperation.add(new SelectItemOption(MODIFIED_DATE, (Object)MODIFIED_DATE));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TIME_OPTION, TIME_OPTION, dateOperation));
        UIFormDateTimeInput uiFromDate = new UIFormDateTimeInput(START_TIME, START_TIME, null);
        uiFromDate.setDisplayTime(false);
        this.addUIFormInput((UIFormInput)uiFromDate);
        UIFormDateTimeInput uiToDate = new UIFormDateTimeInput(END_TIME, END_TIME, null);
        uiToDate.setDisplayTime(false);
        this.addUIFormInput((UIFormInput)uiToDate);
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(NODETYPE_PROPERTY, NODETYPE_PROPERTY, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DOC_TYPE, DOC_TYPE, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(CATEGORY_PROPERTY, CATEGORY_PROPERTY, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(CATEGORY_TYPE, CATEGORY_TYPE, null));
    }

    private String getContainQueryString(String property, String type, boolean isContain) {
        String value = (String)this.getUIStringInput(type).getValue();
        if (value == null) {
            return "";
        }
        if (value.trim().length() > 0) {
            if (isContain) {
                return " jcr:contains(@" + property.trim() + ", '" + value.trim() + "')";
            }
            return " fn:not(jcr:contains(@" + property.trim() + ", '" + value.trim() + "'))";
        }
        return "";
    }

    private String getDateTimeQueryString(String beforeDate, String afterDate, String type) {
        Calendar bfDate = this.getUIFormDateTimeInput(START_TIME).getCalendar();
        if (afterDate != null && afterDate.trim().length() > 0) {
            Calendar afDate = this.getUIFormDateTimeInput(END_TIME).getCalendar();
            if (type.equals(CREATED_DATE)) {
                this.virtualDateQuery_ = "(documents created from '" + beforeDate + "') and (documents created to '" + afterDate + "')";
                return "@exo:dateCreated >= xs:dateTime('" + ISO8601.format((Calendar)bfDate) + "') and @exo:dateCreated < xs:dateTime('" + ISO8601.format((Calendar)afDate) + "')";
            }
            if (type.equals(MODIFIED_DATE)) {
                this.virtualDateQuery_ = "(documents modified from '" + beforeDate + "') and (documents modified to '" + afterDate + "')";
                return "@exo:dateModified >= xs:dateTime('" + ISO8601.format((Calendar)bfDate) + "') and @exo:dateModified < xs:dateTime('" + ISO8601.format((Calendar)afDate) + "')";
            }
        } else {
            if (type.equals(CREATED_DATE)) {
                this.virtualDateQuery_ = "(documents created from '" + beforeDate + "')";
                return "@exo:dateCreated >= xs:dateTime('" + ISO8601.format((Calendar)bfDate) + "')";
            }
            if (type.equals(MODIFIED_DATE)) {
                this.virtualDateQuery_ = "(documents modified from '" + beforeDate + "')";
                return "@exo:dateModified >= xs:dateTime('" + ISO8601.format((Calendar)bfDate) + "')";
            }
        }
        return "";
    }

    private String getNodeTypeQueryString(String nodeTypes) {
        String advanceQuery = "";
        String[] arrNodeTypes = new String[]{};
        if (nodeTypes.indexOf(",") > -1) {
            arrNodeTypes = nodeTypes.split(",");
        }
        if (arrNodeTypes.length > 0) {
            for (String nodeType : arrNodeTypes) {
                advanceQuery = advanceQuery.length() == 0 ? "@jcr:primaryType = '" + nodeType + "'" : advanceQuery + " " + OR_OPERATION + " " + "@jcr:primaryType = '" + nodeType + "'";
            }
        } else {
            advanceQuery = "@jcr:primaryType = '" + nodeTypes + "'";
        }
        return advanceQuery;
    }

    private String getCategoryQueryString(String categoryPath) {
        if (categoryPath == null || categoryPath.length() == 0) {
            return "";
        }
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        String uuid = null;
        try {
            uuid = ((Node)uiExplorer.getSession().getItem(categoryPath)).getUUID();
        }
        catch (Exception e) {
            return "";
        }
        if (uuid == null || uuid.length() == 0) {
            return "";
        }
        return "@exo:category = '" + uuid + "'";
    }

    private void addConstraint(int opt) throws Exception {
        String advanceQuery = "";
        this.virtualDateQuery_ = null;
        UISimpleSearch uiSimpleSearch = (UISimpleSearch)((UISearchContainer)this.getParent()).getChild(UISimpleSearch.class);
        switch (opt) {
            case 0: {
                String property = (String)this.getUIStringInput(PROPERTY1).getValue();
                String value = (String)this.getUIStringInput(CONTAIN_EXACTLY).getValue();
                advanceQuery = "@" + property + " = '" + value.trim() + "'";
                break;
            }
            case 1: {
                String property = (String)this.getUIStringInput(PROPERTY2).getValue();
                advanceQuery = this.getContainQueryString(property, CONTAIN, true);
                break;
            }
            case 2: {
                String property = (String)this.getUIStringInput(PROPERTY3).getValue();
                advanceQuery = this.getContainQueryString(property, NOT_CONTAIN, false);
                break;
            }
            case 3: {
                String fromDate = (String)this.getUIFormDateTimeInput(START_TIME).getValue();
                String toDate = (String)this.getUIFormDateTimeInput(END_TIME).getValue();
                String type = (String)this.getUIFormSelectBox(TIME_OPTION).getValue();
                advanceQuery = this.getDateTimeQueryString(fromDate, toDate, type);
                break;
            }
            case 4: {
                String property = (String)this.getUIStringInput(DOC_TYPE).getValue();
                advanceQuery = this.getNodeTypeQueryString(property);
                break;
            }
            case 5: {
                String property = (String)this.getUIStringInput(CATEGORY_TYPE).getValue();
                advanceQuery = this.getCategoryQueryString(property);
                break;
            }
        }
        uiSimpleSearch.updateAdvanceConstraint(advanceQuery, (String)this.getUIFormSelectBox(OPERATOR).getValue(), this.virtualDateQuery_);
    }

    private void resetConstraintForm() {
        this.reset();
        this.getUIFormCheckBoxInput(EXACTLY_PROPERTY).setChecked(false);
        this.getUIFormCheckBoxInput(CONTAIN_PROPERTY).setChecked(false);
        this.getUIFormCheckBoxInput(NOT_CONTAIN_PROPERTY).setChecked(false);
        this.getUIFormCheckBoxInput(DATE_PROPERTY).setChecked(false);
        this.getUIFormCheckBoxInput(NODETYPE_PROPERTY).setChecked(false);
        this.getUIFormCheckBoxInput(CATEGORY_PROPERTY).setChecked(false);
    }

    private boolean isValidDateTime(String dateTime) {
        String[] arr = dateTime.split(SPLIT_REGEX, 7);
        int valid = Integer.parseInt(arr[0]);
        if (valid < 1 || valid > 12) {
            return false;
        }
        GregorianCalendar date = new GregorianCalendar(Integer.parseInt(arr[2]), valid - 1, 1);
        if (Integer.parseInt(arr[1]) > ((Calendar)date).getActualMaximum(5)) {
            return false;
        }
        return arr.length <= 3 || Integer.parseInt(arr[3]) <= 23 && Integer.parseInt(arr[4]) <= 59 && Integer.parseInt(arr[5]) <= 59;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.getUIStringInput(selectField).setValue((Object)value.toString());
        this.getUIFormCheckBoxInput(CATEGORY_PROPERTY).setChecked(true);
        UISearchContainer uiSearchContainer = (UISearchContainer)this.getAncestorOfType(UISearchContainer.class);
        for (UIComponent uiComponent : ((UIECMSearch)this.getAncestorOfType(UIECMSearch.class)).getChildren()) {
            uiComponent.setRendered(false);
        }
        uiSearchContainer.setRendered(true);
        UIPopupWindow uiPopup = (UIPopupWindow)uiSearchContainer.findComponentById("CategoryPopup");
        uiPopup.setRendered(false);
        uiPopup.setShow(false);
    }

    static /* synthetic */ void access$000(UIConstraintsForm x0, int x1) throws Exception {
        x0.addConstraint(x1);
    }

    static /* synthetic */ boolean access$100(UIConstraintsForm x0, String x1) {
        return x0.isValidDateTime(x1);
    }

    static /* synthetic */ void access$200(UIConstraintsForm x0) {
        x0.resetConstraintForm();
    }
}

