/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;

public class RssServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block14: {
            response.setHeader("Cache-Control", "private max-age=600, s-maxage=120");
            String wsName = null;
            String path = null;
            String portalName = null;
            String pathInfo = request.getPathInfo();
            portalName = pathInfo.substring(1, pathInfo.indexOf("/", 1));
            wsName = pathInfo.substring(portalName.length() + 2, pathInfo.indexOf("/", portalName.length() + 2));
            path = pathInfo.substring(pathInfo.indexOf(wsName) + wsName.length() + 1);
            ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
            RepositoryService repositoryService = (RepositoryService)exoContainer.getComponentInstanceOfType(RepositoryService.class);
            TemplateService tservice = (TemplateService)exoContainer.getComponentInstanceOfType(TemplateService.class);
            Session session = null;
            try {
                session = repositoryService.getDefaultRepository().getSystemSession(wsName);
                Node rootNode = session.getRootNode();
                Node file = null;
                if (rootNode.hasNode(path)) {
                    file = rootNode.getNode(path);
                } else if (rootNode.hasNode(path.substring(0, path.lastIndexOf("/")))) {
                    Node parentNode = rootNode.getNode(path.substring(0, path.lastIndexOf("/")));
                    String name = path.substring(path.lastIndexOf("/") + 1);
                    if (name.indexOf(".") > -1 && parentNode.hasNode(name.substring(0, name.indexOf(".")))) {
                        file = parentNode.getNode(name.substring(0, name.indexOf(".")));
                    }
                }
                if (file == null) {
                    throw new Exception("Node " + path + " not found. ");
                }
                if (file.isNodeType("nt:file")) {
                    Node content = file.getNode("jcr:content");
                    Property data = content.getProperty("jcr:data");
                    String mimeType = content.getProperty("jcr:mimeType").getString();
                    response.setContentType(mimeType);
                    InputStream is = data.getStream();
                    byte[] buf = new byte[is.available()];
                    is.read(buf);
                    ServletOutputStream os = response.getOutputStream();
                    os.write(buf);
                    break block14;
                }
                if (file.isNodeType("exo:rss-enable")) {
                    String nodeType;
                    List documentNodeType = tservice.getDocumentTemplates("repository");
                    if (documentNodeType.contains(nodeType = file.getPrimaryNodeType().getName())) {
                        String templateName = tservice.getTemplatePath(false, nodeType, "view1", "repository");
                        request.setAttribute("portalName", (Object)portalName);
                        request.setAttribute("wsName", (Object)wsName);
                        request.setAttribute("templateName", (Object)("jcr:" + templateName));
                        request.setAttribute("curNode", (Object)file);
                        RequestDispatcher rd = request.getRequestDispatcher("/viewcontent");
                        rd.forward((ServletRequest)request, (ServletResponse)response);
                        break block14;
                    }
                    throw new Exception("This node type is not document node");
                }
                throw new Exception("Invalid node type, expected nt:file or exo:rss-enable type");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ServletException((Throwable)e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }
}

