/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryForm;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.popup.UIPopupComponent;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.categories.CategoriesService;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.folksonomy.FolksonomyService;
import org.exoplatform.services.cms.metadata.MetadataService;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ResetActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CloseActionListener.class}), @EventConfig(listeners={AddWorkspaceActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ShowHiddenActionListener.class}), @EventConfig(listeners={RemoveWorkspaceActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={EditWorkspaceActionListener.class})})
public class UIRepositoryForm
extends UIForm
implements UIPopupComponent {
    public static final String ST_ADD = "AddRepoPopup";
    public static final String ST_EDIT = "EditRepoPopup";
    public static final String POPUP_WORKSPACE = "PopupWorkspace";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_WSINPUTSET = "wsInputSet";
    public static final String FIELD_WORKSPACE = "workspace";
    public static final String FIELD_ISDEFAULT = "isDefault";
    public static final String FIELD_ACCESSCONTROL = "accessControl";
    public static final String FIELD_AUTHINPUTSET = "authInputSet";
    public static final String FIELD_AUTHENTICATION = "authenticationPolicy";
    public static final String FIELD_SCURITY = "securityDomain";
    public static final String FIELD_SESSIONTIME = "sessionTime";
    public static final String FIELD_REPCHANNEL = "channelConfig";
    public static final String FIELD_REPENABLE = "enableReplication";
    public static final String FIELD_REPMODE = "repMode";
    public static final String FIELD_REPTESTMODE = "repTestMode";
    public static final String FIELD_BSEPATH = "directoryPath";
    public static final String FIELD_BSEMAXBUFFER = "maxBufferSize";
    public static final String KEY_AUTHENTICATIONPOLICY = "org.exoplatform.services.jcr.impl.core.access.JAASAuthenticator";
    protected boolean isAddnew_ = true;
    protected String defaulWorkspace_ = null;
    protected String repoName_ = null;
    protected Map<String, WorkspaceEntry> workspaceMap_ = new HashMap();

    public UIRepositoryForm() throws Exception {
        this.addChild((UIComponent)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormInputSetWithAction workspaceField = new UIFormInputSetWithAction(FIELD_WSINPUTSET);
        workspaceField.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_WORKSPACE, FIELD_WORKSPACE, null));
        workspaceField.setActionInfo(FIELD_WORKSPACE, new String[]{"EditWorkspace", "RemoveWorkspace"});
        this.addUIComponentInput((UIComponent)workspaceField);
        this.addChild((UIComponent)new UIFormCheckBoxInput(FIELD_ISDEFAULT, FIELD_ISDEFAULT, null).setEditable(false));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_ACCESSCONTROL, FIELD_ACCESSCONTROL, null).addValidator(MandatoryValidator.class, new Object[0]));
        UIFormInputSetWithAction autField = new UIFormInputSetWithAction(FIELD_AUTHINPUTSET);
        autField.addChild((UIComponent)new UIFormStringInput(FIELD_AUTHENTICATION, FIELD_AUTHENTICATION, null).addValidator(MandatoryValidator.class, new Object[0]));
        autField.setActionInfo(FIELD_AUTHENTICATION, new String[]{"Select"});
        this.addChild((UIComponent)autField);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SCURITY, FIELD_SCURITY, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SESSIONTIME, FIELD_SESSIONTIME, null));
    }

    public void refresh(RepositoryEntry repo) throws Exception {
        this.reset();
        this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setChecked(false);
        UIFormInputSetWithAction autField = (UIFormInputSetWithAction)this.getChildById(FIELD_AUTHINPUTSET);
        this.workspaceMap_.clear();
        if (repo != null) {
            if (this.isAddnew_) {
                this.repoName_ = null;
                this.defaulWorkspace_ = null;
                this.refreshWorkspaceList();
                this.getUIStringInput(FIELD_NAME).setEditable(true);
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setChecked(false);
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setEnable(false);
                this.setActions(new String[]{"Save", "AddWorkspace", "Reset", "Close"});
            } else {
                this.repoName_ = repo.getName();
                this.defaulWorkspace_ = repo.getDefaultWorkspaceName();
                for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
                    this.workspaceMap_.put(ws.getName(), ws);
                }
                this.getUIStringInput(FIELD_NAME).setEditable(false);
                this.getUIStringInput(FIELD_NAME).setValue((Object)repo.getName());
                this.refreshWorkspaceList();
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setChecked(this.isDefaultRepo(repo.getName()));
                this.getUIFormCheckBoxInput(FIELD_ISDEFAULT).setEnable(false);
                autField.setActionInfo(FIELD_AUTHENTICATION, null);
                this.setActions(new String[]{"AddWorkspace", "Close"});
            }
            this.getUIStringInput(FIELD_ACCESSCONTROL).setValue((Object)repo.getAccessControl());
            autField.getUIStringInput(FIELD_AUTHENTICATION).setValue((Object)repo.getAuthenticationPolicy());
            this.getUIStringInput(FIELD_SCURITY).setValue((Object)repo.getSecurityDomain());
            this.getUIStringInput(FIELD_SESSIONTIME).setValue((Object)String.valueOf(repo.getSessionTimeOut()));
        }
    }

    protected void lockForm(boolean isLock) throws Exception {
        boolean editable = !isLock;
        UIFormInputSetWithAction autField = (UIFormInputSetWithAction)this.getChildById(FIELD_AUTHINPUTSET);
        if (isLock) {
            autField.setActionInfo(FIELD_AUTHENTICATION, null);
        } else {
            autField.setActionInfo(FIELD_AUTHENTICATION, new String[]{"Select"});
        }
        this.getUIStringInput(FIELD_ACCESSCONTROL).setEditable(editable);
        autField.getUIStringInput(FIELD_AUTHENTICATION).setEditable(editable);
        this.getUIStringInput(FIELD_SCURITY).setEditable(editable);
        this.getUIStringInput(FIELD_SESSIONTIME).setEditable(editable);
    }

    protected boolean isDefaultWorkspace(String workspaceName) {
        return workspaceName.equals(this.defaulWorkspace_);
    }

    protected boolean isExistWorkspace(String workspaceName) {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        for (RepositoryEntry repo : rservice.getConfig().getRepositoryConfigurations()) {
            for (WorkspaceEntry ws : repo.getWorkspaceEntries()) {
                if (!ws.getName().equals(workspaceName)) continue;
                return true;
            }
        }
        return false;
    }

    protected WorkspaceEntry getWorkspace(String workspaceName) {
        return (WorkspaceEntry)this.workspaceMap_.get(workspaceName);
    }

    protected Map<String, WorkspaceEntry> getWorkspaceMap() {
        return this.workspaceMap_;
    }

    protected void refreshWorkspaceList() {
        StringBuilder labels = new StringBuilder();
        for (String wsName : this.workspaceMap_.keySet()) {
            if (labels.length() > 0) {
                labels.append(",");
            }
            labels.append(wsName);
        }
        UIFormInputSetWithAction workspaceField = (UIFormInputSetWithAction)this.getChildById(FIELD_WSINPUTSET);
        workspaceField.setInfoField(FIELD_WORKSPACE, labels.toString());
    }

    protected boolean isDefaultRepo(String repoName) {
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rservice.getConfig().getDefaultRepositoryName().equals(repoName);
    }

    protected void saveRepo(RepositoryEntry repositoryEntry) throws Exception {
        InitialContextInitializer ic = (InitialContextInitializer)((ExoContainer)this.getApplicationComponent(ExoContainer.class)).getComponentInstanceOfType(InitialContextInitializer.class);
        RegistryService registryService = (RegistryService)this.getApplicationComponent(RegistryService.class);
        if (ic != null) {
            ic.recall();
        }
        RepositoryService rService = (RepositoryService)((ExoContainer)this.getApplicationComponent(ExoContainer.class)).getComponentInstanceOfType(RepositoryService.class);
        if (this.isAddnew_) {
            try {
                rService.createRepository(repositoryEntry);
                for (WorkspaceEntry ws : this.getWorkspaceMap().values()) {
                    if (!ws.getName().equals(repositoryEntry.getSystemWorkspaceName())) continue;
                    registryService.addRegistryLocation(repositoryEntry.getName(), ws.getName());
                }
                for (WorkspaceEntry ws : this.getWorkspaceMap().values()) {
                    if (rService.getRepository(repositoryEntry.getName()).isWorkspaceInitialized(ws.getName())) continue;
                    rService.getRepository(repositoryEntry.getName()).configWorkspace(ws);
                    rService.getRepository(repositoryEntry.getName()).createWorkspace(ws.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.initServices(repositoryEntry.getName());
            if (rService.getConfig().isRetainable()) {
                rService.getConfig().retain();
            }
        }
    }

    private void initServices(String repository) throws Exception {
        try {
            ((RegistryService)this.getApplicationComponent(RegistryService.class)).start();
            ((NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class)).init(repository);
            ((CategoriesService)this.getApplicationComponent(CategoriesService.class)).init(repository);
            ((ManageDriveService)this.getApplicationComponent(ManageDriveService.class)).init(repository);
            ((FolksonomyService)this.getApplicationComponent(FolksonomyService.class)).init(repository);
            ((MetadataService)this.getApplicationComponent(MetadataService.class)).init(repository);
            ((QueryService)this.getApplicationComponent(QueryService.class)).init(repository);
            ((RelationsService)this.getApplicationComponent(RelationsService.class)).init(repository);
            ((ScriptService)this.getApplicationComponent(ScriptService.class)).initRepo(repository);
            ((TemplateService)this.getApplicationComponent(TemplateService.class)).init(repository);
            ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).init(repository);
            ((ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class)).init(repository);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void ShowHidden() {
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
        this.repoName_ = null;
    }

    public void setAuthentication(String value) {
        UIFormInputSetWithAction autField = (UIFormInputSetWithAction)this.getChildById(FIELD_AUTHINPUTSET);
        autField.getUIStringInput(FIELD_AUTHENTICATION).setValue((Object)value);
    }
}

