/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control;

import java.util.ArrayList;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.control.UIPreferencesForm;
import org.exoplatform.ecm.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={BackActionListener.class})})
public class UIPreferencesForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_ENABLESTRUCTURE = "enableStructure".intern();
    public static final String FIELD_SHOWSIDEBAR = "showSideBar".intern();
    public static final String FIELD_SHOWNONDOCUMENT = "showNonDocument".intern();
    public static final String FIELD_SHOWREFDOCUMENTS = "showRefDocuments".intern();
    public static final String FIELD_SHOW_HIDDEN_NODE = "showHiddenNode".intern();
    public static final String FIELD_SHORTBY = "sortBy".intern();
    public static final String FIELD_ORDERBY = "order".intern();
    public static final String FIELD_PROPERTY = "property".intern();
    public static final String NODES_PER_PAGE = "nodesPerPage".intern();

    public UIPreferencesForm() throws Exception {
        ArrayList<SelectItemOption> sortOptions = new ArrayList<SelectItemOption>();
        sortOptions.add(new SelectItemOption("Alphabetic", (Object)"Alphabetic"));
        sortOptions.add(new SelectItemOption("Type", (Object)"Type"));
        sortOptions.add(new SelectItemOption("CreatedDate", (Object)"CreatedDate"));
        sortOptions.add(new SelectItemOption("ModifiedDate", (Object)"ModifiedDate"));
        ArrayList<SelectItemOption> orderOption = new ArrayList<SelectItemOption>();
        orderOption.add(new SelectItemOption("Ascending", (Object)"Ascending"));
        orderOption.add(new SelectItemOption("Descending", (Object)"Descending"));
        ArrayList<SelectItemOption> nodesPerPagesOptions = new ArrayList<SelectItemOption>();
        nodesPerPagesOptions.add(new SelectItemOption("5", (Object)"5"));
        nodesPerPagesOptions.add(new SelectItemOption("10", (Object)"10"));
        nodesPerPagesOptions.add(new SelectItemOption("15", (Object)"15"));
        nodesPerPagesOptions.add(new SelectItemOption("20", (Object)"20"));
        nodesPerPagesOptions.add(new SelectItemOption("30", (Object)"30"));
        nodesPerPagesOptions.add(new SelectItemOption("40", (Object)"40"));
        nodesPerPagesOptions.add(new SelectItemOption("50", (Object)"50"));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_ENABLESTRUCTURE, FIELD_ENABLESTRUCTURE, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_SHOWSIDEBAR, FIELD_SHOWSIDEBAR, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_SHOWNONDOCUMENT, FIELD_SHOWNONDOCUMENT, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_SHOWREFDOCUMENTS, FIELD_SHOWREFDOCUMENTS, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_SHOW_HIDDEN_NODE, FIELD_SHOW_HIDDEN_NODE, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_SHORTBY, FIELD_SHORTBY, sortOptions));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_ORDERBY, FIELD_ORDERBY, orderOption));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(NODES_PER_PAGE, NODES_PER_PAGE, nodesPerPagesOptions));
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void update(Preference pref) {
        this.getUIFormCheckBoxInput(FIELD_ENABLESTRUCTURE).setChecked(pref.isJcrEnable());
        this.getUIFormCheckBoxInput(FIELD_SHOWSIDEBAR).setChecked(pref.isShowSideBar());
        this.getUIFormCheckBoxInput(FIELD_SHOWNONDOCUMENT).setChecked(pref.isShowNonDocumentType());
        this.getUIFormCheckBoxInput(FIELD_SHOWREFDOCUMENTS).setChecked(pref.isShowPreferenceDocuments());
        this.getUIFormCheckBoxInput(FIELD_SHOW_HIDDEN_NODE).setChecked(pref.isShowHiddenNode());
        this.getUIFormSelectBox(FIELD_SHORTBY).setValue(pref.getSortType());
        this.getUIFormSelectBox(FIELD_ORDERBY).setValue(pref.getOrder());
        this.getUIFormSelectBox(NODES_PER_PAGE).setValue(Integer.toString(pref.getNodesPerPage()));
    }
}

