/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.info;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.OnParentVersionAction;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.info.UINodeTypeInfo;
import org.exoplatform.ecm.webui.popup.UIPopupComponent;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.jcr.core.ExtendedPropertyType;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;

@ComponentConfig(template="app:/groovy/webui/component/explorer/popup/info/UINodeTypeInfo.gtmpl", events={@EventConfig(listeners={CloseActionListener.class})})
public class UINodeTypeInfo
extends UIContainer
implements UIPopupComponent {
    private Collection nodeTypes;

    public void activate() throws Exception {
        UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Node node = uiJCRExplorer.getCurrentNode();
        try {
            NodeType nodetype = node.getPrimaryNodeType();
            ArrayList<NodeType> types = new ArrayList<NodeType>();
            types.add(nodetype);
            NodeType[] mixins = node.getMixinNodeTypes();
            if (mixins != null) {
                List<NodeType> list = Arrays.asList(mixins);
                types.addAll(list);
            }
            this.nodeTypes = types;
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)uiJCRExplorer.getAncestorOfType(UIApplication.class);
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
        }
    }

    public String getPropertyValue(Value value) throws Exception {
        switch (value.getType()) {
            case 2: {
                return Integer.toString(2);
            }
            case 6: {
                return Boolean.toString(value.getBoolean());
            }
            case 5: {
                return value.getDate().getTime().toString();
            }
            case 4: {
                return Double.toString(value.getDouble());
            }
            case 3: {
                return Long.toString(value.getLong());
            }
            case 7: {
                return value.getString();
            }
            case 1: {
                return value.getString();
            }
        }
        return null;
    }

    public void deActivate() throws Exception {
    }

    public String[] getActions() {
        return new String[]{"Close"};
    }

    public String resolveType(int type) {
        return ExtendedPropertyType.nameFromValue((int)type);
    }

    public String resolveOnParentVersion(int opv) {
        return OnParentVersionAction.nameFromValue((int)opv);
    }

    public String getDefaultValue(PropertyDefinition proDef) throws Exception {
        StringBuilder defaultValue = new StringBuilder();
        Value[] values = proDef.getDefaultValues();
        if (values == null || values.length < 0) {
            return "";
        }
        for (Value value : values) {
            if (value == null) continue;
            if (defaultValue.length() > 0) {
                defaultValue.append(",");
            }
            defaultValue.append(this.getPropertyValue(value));
        }
        return defaultValue.toString();
    }

    public Collection getNodeTypes() {
        return this.nodeTypes;
    }
}

