/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.jcr.TypeNodeComparator;
import org.exoplatform.ecm.jcr.model.ClipboardCommand;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.comparator.DateTimeComparator;
import org.exoplatform.ecm.webui.comparator.NodeNameComparator;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.popup.UIPopupContainer;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.folksonomy.FolksonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIJCRExplorer
extends UIContainer {
    private LinkedList<ClipboardCommand> clipboards_ = new LinkedList();
    private LinkedList<String> nodesHistory_ = new LinkedList();
    private LinkedList<String> wsHistory_ = new LinkedList();
    private PortletPreferences pref_;
    private Preference preferences_;
    private Set<String> addressPath_ = new HashSet();
    private JCRResourceResolver jcrTemplateResourceResolver_;
    private String rootPath_;
    private String currentPath_;
    private String currentStatePath_;
    private String currentWorkspaceName_;
    private String currentRepositoryName_;
    private String documentInfoTemplate_;
    private String language_;
    private String tagPath_;
    private String referenceWorkspace_;
    private boolean isViewTag_ = false;
    private boolean isHidePopup_ = false;
    private boolean isReferenceNode_ = false;
    private DriveData driveData_;

    public UIJCRExplorer() throws Exception {
        this.addChild(UIControl.class, null, null);
        this.addChild(UIWorkingArea.class, null, null);
        this.addChild(UIPopupContainer.class, null, null);
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        this.pref_ = pcontext.getRequest().getPreferences();
    }

    private String filterPath(String currentPath) throws Exception {
        if (this.getRootNode().getDepth() == 0) {
            return currentPath;
        }
        if (this.rootPath_.equals(this.currentPath_)) {
            return "/";
        }
        return currentPath.replaceFirst(this.rootPath_, "");
    }

    public void setRootPath(String rootPath) {
        this.rootPath_ = rootPath;
        this.currentPath_ = rootPath;
    }

    public Node getRootNode() throws Exception {
        return this.getNodeByPath(this.rootPath_, this.getSession());
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    public Node getCurrentNode() throws Exception {
        return this.getNodeByPath(this.currentPath_, this.getSession());
    }

    public String getCurrentPath() {
        return this.currentPath_;
    }

    public void setCurrentPath(String currentPath) {
        this.currentPath_ = currentPath;
    }

    public boolean isReferenceNode() {
        return this.isReferenceNode_;
    }

    public void setIsReferenceNode(boolean isReferenceNode) {
        this.isReferenceNode_ = isReferenceNode;
    }

    public void setReferenceWorkspace(String referenceWorkspace) {
        this.referenceWorkspace_ = referenceWorkspace;
    }

    public String getReferenceWorkspace() {
        return this.referenceWorkspace_;
    }

    public void setBackNodePath(String historyPath) throws Exception {
        this.currentPath_ = historyPath;
        this.refreshExplorer();
    }

    public void setDriveData(DriveData driveData) {
        this.driveData_ = driveData;
    }

    public DriveData getDriveData() {
        return this.driveData_;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public String getLanguage() {
        return this.language_;
    }

    public LinkedList<String> getNodesHistory() {
        return this.nodesHistory_;
    }

    public void setNodesHistory(LinkedList<String> h) {
        this.nodesHistory_ = h;
    }

    public LinkedList<String> getWorkspacesHistory() {
        return this.wsHistory_;
    }

    public void setWorkspaceHistory(LinkedList<String> wsHistory) {
        this.wsHistory_ = wsHistory;
    }

    public Set<String> getAddressPath() {
        return this.addressPath_;
    }

    public void setAddressPath(Set<String> s) {
        this.addressPath_ = s;
    }

    public SessionProvider getSessionProvider() {
        return SessionProviderFactory.createSessionProvider();
    }

    public SessionProvider getSystemProvider() {
        return SessionProviderFactory.createSystemProvider();
    }

    public Session getSession() throws Exception {
        if (this.isReferenceNode_) {
            return this.getSessionProvider().getSession(this.referenceWorkspace_, this.getRepository());
        }
        return this.getSessionProvider().getSession(this.currentWorkspaceName_, this.getRepository());
    }

    public Session getSystemSession() throws Exception {
        if (this.isReferenceNode_) {
            return this.getSystemProvider().getSession(this.referenceWorkspace_, this.getRepository());
        }
        return this.getSystemProvider().getSession(this.currentWorkspaceName_, this.getRepository());
    }

    public String getDocumentInfoTemplate() {
        return this.documentInfoTemplate_;
    }

    public void setRenderTemplate(String template) {
        this.newJCRTemplateResourceResolver();
        this.documentInfoTemplate_ = template;
    }

    public void setCurrentStatePath(String currentStatePath) {
        this.currentStatePath_ = currentStatePath;
    }

    public Node getCurrentStateNode() throws Exception {
        return this.getNodeByPath(this.currentStatePath_, this.getSession());
    }

    public JCRResourceResolver getJCRTemplateResourceResolver() {
        return this.jcrTemplateResourceResolver_;
    }

    public void newJCRTemplateResourceResolver() {
        try {
            String workspace = this.driveData_.getWorkspace();
            this.jcrTemplateResourceResolver_ = new JCRResourceResolver(this.currentRepositoryName_, workspace, "exo:templateFile");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setRepositoryName(String repositoryName) {
        this.currentRepositoryName_ = repositoryName;
    }

    public String getRepositoryName() {
        return this.currentRepositoryName_;
    }

    public void setWorkspaceName(String workspaceName) {
        this.currentWorkspaceName_ = workspaceName;
    }

    public String getCurrentWorkspace() {
        return this.currentWorkspaceName_;
    }

    public ManageableRepository getRepository() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getRepository(this.currentRepositoryName_);
    }

    public Session getSessionByWorkspace(String wsName) throws Exception {
        if (wsName == null) {
            return this.getSession();
        }
        return this.getSessionProvider().getSession(wsName, this.getRepository());
    }

    public boolean isSystemWorkspace() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String systemWS = repositoryService.getRepository(this.getRepositoryName()).getConfiguration().getSystemWorkspaceName();
        return this.getCurrentWorkspace().equals(systemWS);
    }

    public void refreshExplorer() throws Exception {
        try {
            Node nodeGet = (Node)this.getSession().getItem(this.currentPath_);
            if (nodeGet.hasProperty("exo:language")) {
                this.setLanguage(nodeGet.getProperty("exo:language").getValue().getString());
            }
        }
        catch (PathNotFoundException path) {
            this.currentPath_ = this.getRootNode().getPath();
        }
        ((UIAddressBar)this.findFirstComponentOfType(UIAddressBar.class)).getUIStringInput("address").setValue((Object)this.filterPath(this.currentPath_));
        UIDocumentContainer uiDocumentContainer = (UIDocumentContainer)this.findFirstComponentOfType(UIDocumentContainer.class);
        UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)uiDocumentContainer.getChild(UIDocumentInfo.class);
        uiDocumentInfo.updatePageListData();
        if (this.isShowViewFile()) {
            uiDocumentInfo.setRendered(false);
        } else {
            uiDocumentInfo.setRendered(true);
        }
        if (this.preferences_.isShowSideBar()) {
            UITreeExplorer treeExplorer = (UITreeExplorer)this.findFirstComponentOfType(UITreeExplorer.class);
            treeExplorer.buildTree();
        }
        UIPopupContainer popupAction = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        popupAction.deActivate();
    }

    public boolean nodeIsLocked(String path, Session session) throws Exception {
        Node node = this.getNodeByPath(path, session);
        return this.nodeIsLocked(node);
    }

    public boolean nodeIsLocked(Node node) throws Exception {
        if (!node.isLocked()) {
            return false;
        }
        String lockToken = LockUtil.getLockToken((Node)node);
        if (lockToken != null) {
            node.getSession().addLockToken(lockToken);
            return false;
        }
        return true;
    }

    public boolean hasAddPermission() {
        try {
            ((ExtendedNode)this.getCurrentNode()).checkPermission("add_node");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean hasEditPermission() {
        try {
            ((ExtendedNode)this.getCurrentNode()).checkPermission("set_property");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean hasRemovePermission() {
        try {
            ((ExtendedNode)this.getCurrentNode()).checkPermission("remove");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean hasReadPermission() {
        try {
            ((ExtendedNode)this.getCurrentNode()).checkPermission("read");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Node getViewNode(String nodeType) throws Exception {
        try {
            Node primaryNode;
            Item primaryItem = this.getCurrentNode().getPrimaryItem();
            if (primaryItem == null || !primaryItem.isNode()) {
                return this.getCurrentNode();
            }
            if (primaryItem != null && primaryItem.isNode() && (primaryNode = (Node)primaryItem).isNodeType(nodeType)) {
                return primaryNode;
            }
        }
        catch (Exception e) {
            return this.getCurrentNode();
        }
        return this.getCurrentNode();
    }

    public List<String> getMultiValues(Node node, String name) throws Exception {
        Value[] values;
        ArrayList<String> list = new ArrayList<String>();
        if (!node.hasProperty(name)) {
            return list;
        }
        if (!node.getProperty(name).getDefinition().isMultiple()) {
            try {
                list.add(node.getProperty(name).getString());
            }
            catch (Exception e) {
                list.add("");
            }
            return list;
        }
        for (Value value : values = node.getProperty(name).getValues()) {
            list.add(value.getString());
        }
        return list;
    }

    public void setIsHidePopup(boolean isHidePopup) {
        this.isHidePopup_ = isHidePopup;
    }

    public void updateAjax(Event event) throws Exception {
        UIPopupContainer popupAction;
        UIAddressBar uiAddressBar = (UIAddressBar)this.findFirstComponentOfType(UIAddressBar.class);
        uiAddressBar.getUIStringInput("address").setValue((Object)this.filterPath(this.currentPath_));
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiAddressBar);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.getChild(UIWorkingArea.class);
        UIDocumentWorkspace uiDocWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
        UIDocumentContainer uiDocumentContainer = (UIDocumentContainer)this.findFirstComponentOfType(UIDocumentContainer.class);
        UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)uiDocumentContainer.getChild(UIDocumentInfo.class);
        if (this.isShowViewFile()) {
            uiDocumentInfo.updatePageListData();
            uiDocumentInfo.setRendered(false);
        } else {
            uiDocumentInfo.setRendered(true);
        }
        if (this.preferences_.isShowSideBar()) {
            ((UITreeExplorer)this.findFirstComponentOfType(UITreeExplorer.class)).buildTree();
        }
        uiDocWorkspace.setRenderedChild(UIDocumentContainer.class);
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingArea);
        if (!this.isHidePopup_ && (popupAction = (UIPopupContainer)this.getChild(UIPopupContainer.class)).isRendered()) {
            popupAction.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
        this.isHidePopup_ = false;
    }

    public boolean isShowViewFile() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        NodeType nodeType = this.getCurrentNode().getPrimaryNodeType();
        NodeType[] superTypes = nodeType.getSupertypes();
        boolean isFolder = false;
        for (NodeType superType : superTypes) {
            if (!superType.getName().equals("nt:folder") && !superType.getName().equals("nt:unstructured")) continue;
            isFolder = true;
        }
        return isFolder && templateService.getDocumentTemplates(this.getRepositoryName()).contains(nodeType.getName());
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupContainer popupAction = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public void record(String str, String ws) {
        this.nodesHistory_.add(str);
        this.wsHistory_.add(ws);
        this.addressPath_.add(str);
    }

    public String rewind() {
        return (String)this.nodesHistory_.removeLast();
    }

    public String previousWsName() {
        return (String)this.wsHistory_.removeLast();
    }

    public void setSelectNode(Node node) throws Exception {
        this.currentPath_ = node.getPath();
        Node currentNode = this.getCurrentNode();
        if (currentNode != null && !node.getPath().equals(this.currentPath_)) {
            if (this.isReferenceNode_) {
                this.record(this.currentPath_, this.referenceWorkspace_);
            } else {
                this.record(this.currentPath_, this.currentWorkspaceName_);
            }
        }
        if (currentNode.hasProperty("exo:language")) {
            this.setLanguage(currentNode.getProperty("exo:language").getValue().getString());
        }
    }

    public void setSelectNode(String uri, Session session) throws Exception {
        Node previousNode = null;
        Node currentNode = this.getCurrentNode();
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        previousNode = currentNode;
        try {
            this.currentPath_ = uri;
            currentNode = (Node)session.getItem(uri);
        }
        catch (Exception e) {
            this.currentPath_ = currentNode.getParent().getPath();
            currentNode = currentNode.getParent();
        }
        if (currentNode.hasProperty("exo:language")) {
            this.setLanguage(currentNode.getProperty("exo:language").getValue().getString());
        }
        if (previousNode != null && !currentNode.equals(previousNode)) {
            if (this.isReferenceNode_) {
                this.record(previousNode.getPath(), this.referenceWorkspace_);
            } else {
                this.record(previousNode.getPath(), this.currentWorkspaceName_);
            }
        }
    }

    public List<Node> getChildrenList(Node node, boolean isReferences) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        NodeIterator childrenIterator = node.getNodes();
        ArrayList<Node> childrenList = new ArrayList<Node>();
        NodeType nodeType = node.getPrimaryNodeType();
        NodeType[] superTypes = nodeType.getSupertypes();
        boolean isFolder = false;
        for (NodeType superType : superTypes) {
            if (!superType.getName().equals("nt:folder") && !superType.getName().equals("nt:unstructured")) continue;
            isFolder = true;
        }
        if (!this.preferences_.isJcrEnable() && templateService.isManagedNodeType(nodeType.getName(), this.currentRepositoryName_) && !isFolder) {
            return childrenList;
        }
        if (this.isReferenceableNode(this.getCurrentNode()) && isReferences) {
            ManageableRepository manageableRepository = repositoryService.getRepository(this.currentRepositoryName_);
            SessionProvider sessionProvider = SessionProviderFactory.createSystemProvider();
            for (String workspace : manageableRepository.getWorkspaceNames()) {
                Session session = sessionProvider.getSession(workspace, manageableRepository);
                try {
                    Node taxonomyNode = session.getNodeByUUID(this.getCurrentNode().getUUID());
                    PropertyIterator categoriesIter = taxonomyNode.getReferences();
                    while (categoriesIter.hasNext()) {
                        Property exoCategoryProp = categoriesIter.nextProperty();
                        Node refNode = exoCategoryProp.getParent();
                        childrenList.add(refNode);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (!this.preferences_.isShowNonDocumentType()) {
            List documentTypes = templateService.getDocumentTemplates(this.currentRepositoryName_);
            while (childrenIterator.hasNext()) {
                Node child = (Node)childrenIterator.next();
                if (!PermissionUtil.canRead((Node)child)) continue;
                NodeType type = child.getPrimaryNodeType();
                if ("nt:unstructured".equals(type.getName()) || "nt:folder".equals(type.getName())) {
                    childrenList.add(child);
                    continue;
                }
                if (!documentTypes.contains(type.getName())) continue;
                childrenList.add(child);
            }
        } else {
            while (childrenIterator.hasNext()) {
                Node child = (Node)childrenIterator.next();
                if (!PermissionUtil.canRead((Node)child)) continue;
                childrenList.add(child);
            }
        }
        ArrayList<Node> childList = new ArrayList();
        if (!this.preferences_.isShowHiddenNode()) {
            for (Node child : childrenList) {
                if (!PermissionUtil.canRead((Node)child) || child.isNodeType("exo:hiddenable")) continue;
                childList.add(child);
            }
        } else {
            childList = childrenList;
        }
        this.sort(childList);
        return childList;
    }

    private void sort(List<Node> childrenList) {
        if ("Alphabetic".equals(this.preferences_.getSortType())) {
            Collections.sort(childrenList, new NodeNameComparator(this.preferences_.getOrder()));
        } else if ("Type".equals(this.preferences_.getSortType())) {
            Collections.sort(childrenList, new TypeNodeComparator(this.preferences_.getOrder()));
        } else if ("CreatedDate".equals(this.preferences_.getSortType())) {
            Collections.sort(childrenList, new DateTimeComparator("exo:dateCreated", this.preferences_.getOrder()));
        } else if ("ModifiedDate".equals(this.preferences_.getSortType())) {
            Collections.sort(childrenList, new DateTimeComparator("exo:dateModified", this.preferences_.getOrder()));
        }
    }

    public boolean isReferenceableNode(Node node) throws Exception {
        return node.isNodeType("mix:referenceable");
    }

    public boolean isPreferenceNode(Node node) {
        try {
            return !this.getCurrentNode().hasNode(node.getName());
        }
        catch (Exception e) {
            return false;
        }
    }

    public Node getNodeByPath(String nodePath, Session session) throws Exception {
        try {
            return (Node)session.getItem(nodePath);
        }
        catch (PathNotFoundException e) {
            this.refreshExplorer();
            return (Node)session.getItem(this.rootPath_);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.refreshExplorer();
            return (Node)session.getItem(this.rootPath_);
        }
    }

    public void setTagPath(String tagPath) {
        this.tagPath_ = tagPath;
    }

    public String getTagPath() {
        return this.tagPath_;
    }

    public List<Node> getDocumentByTag() throws Exception {
        FolksonomyService folksonomyService = (FolksonomyService)this.getApplicationComponent(FolksonomyService.class);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documentsType = templateService.getDocumentTemplates(this.getRepositoryName());
        ArrayList<Node> documentsOnTag = new ArrayList<Node>();
        for (Node node : folksonomyService.getDocumentsOnTag(this.tagPath_, this.getRepositoryName())) {
            if (!documentsType.contains(node.getPrimaryNodeType().getName())) continue;
            documentsOnTag.add(node);
        }
        return documentsOnTag;
    }

    public void setIsViewTag(boolean isViewTag) {
        this.isViewTag_ = isViewTag;
    }

    public boolean isViewTag() {
        return this.isViewTag_;
    }

    public LinkedList<ClipboardCommand> getAllClipBoard() {
        return this.clipboards_;
    }

    public PortletPreferences getPortletPreferences() {
        return this.pref_;
    }

    public boolean isReadAuthorized(ExtendedNode node) throws RepositoryException {
        try {
            node.checkPermission("read");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public Preference getPreference() {
        return this.preferences_;
    }

    public void setPreferences(Preference preference) {
        this.preferences_ = preference;
    }

    public String getPreferencesPath() {
        String prefPath = this.driveData_.getHomePath();
        if (prefPath == null || prefPath.length() == 0 || prefPath == "/") {
            return "";
        }
        return prefPath;
    }

    public String getPreferencesWorkspace() {
        String workspaceName = this.driveData_.getWorkspace();
        if (workspaceName == null || workspaceName.length() == 0) {
            return "";
        }
        return workspaceName;
    }
}

