/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.sidebar.TreeNode;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeNodePageIterator;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIRightClickPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/sidebar/UITreeExplorer.gtmpl", events={@EventConfig(listeners={ExpandActionListener.class}), @EventConfig(listeners={CollapseActionListener.class}), @EventConfig(listeners={ExpandTreeActionListener.class})})
public class UITreeExplorer
extends UIContainer {
    private TreeNode treeRoot_;

    public UIRightClickPopupMenu getContextMenu() {
        return (UIRightClickPopupMenu)((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getChild(UIRightClickPopupMenu.class);
    }

    public TreeNode getRootTreeNode() {
        return this.treeRoot_;
    }

    public String getRootActionList() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (uiExplorer.getAllClipBoard().size() > 0) {
            return ((Object)this.getContextMenu().getJSOnclickShowPopup(uiExplorer.getRootNode().getPath(), "Paste")).toString();
        }
        return "";
    }

    public String getActionsList(Node node) throws Exception {
        if (node == null) {
            return "";
        }
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getActionsList(node);
    }

    public List<Node> getCustomActions(Node node) throws Exception {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).getCustomActions(node);
    }

    public boolean isPreferenceNode(Node node) throws RepositoryException {
        return ((UIWorkingArea)this.getAncestorOfType(UIWorkingArea.class)).isPreferenceNode(node);
    }

    public List<TreeNode> getRenderedChildren(TreeNode treeNode) throws Exception {
        if (this.isPaginated(treeNode)) {
            UITreeNodePageIterator pageIterator = (UITreeNodePageIterator)this.findComponentById(treeNode.getPath());
            return pageIterator.getCurrentPageData();
        }
        return treeNode.getChildren();
    }

    public boolean isSystemWorkspace() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isSystemWorkspace();
    }

    public UITreeNodePageIterator getUIPageIterator(String id) throws Exception {
        return (UITreeNodePageIterator)this.findComponentById(id);
    }

    public boolean isPaginated(TreeNode treeNode) {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        int nodePerPages = jcrExplorer.getPreference().getNodesPerPage();
        return treeNode.getChildrenSize() > nodePerPages;
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getServerPath() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        String prefixWebDAV = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort());
        return prefixWebDAV;
    }

    public String getRepository() {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
    }

    private void addTreeNodePageIteratorAsChild(String id, ObjectPageList pageList, String selectedPath, String currentPath) throws Exception {
        if (this.findComponentById(id) == null) {
            UITreeNodePageIterator nodePageIterator = (UITreeNodePageIterator)this.addChild(UITreeNodePageIterator.class, null, id);
            nodePageIterator.setPageList((PageList)pageList);
            nodePageIterator.setSelectedPath(selectedPath);
        } else {
            UITreeNodePageIterator existedComponent = (UITreeNodePageIterator)this.findComponentById(id);
            int currentPage = existedComponent.getCurrentPage();
            existedComponent.setPageList((PageList)pageList);
            if (!selectedPath.equalsIgnoreCase(currentPath) && currentPage <= existedComponent.getAvailablePage()) {
                existedComponent.setCurrentPage(currentPage);
            }
        }
    }

    private Node getRootNode() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Session session = uiExplorer.getSessionProvider().getSession(uiExplorer.getCurrentWorkspace(), uiExplorer.getRepository());
        return uiExplorer.getNodeByPath(uiExplorer.getRootPath(), session);
    }

    private void buildTree(String path) throws Exception {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        int nodePerPages = jcrExplorer.getPreference().getNodesPerPage();
        TreeNode treeRoot = new TreeNode(this.getRootNode());
        if (path == null) {
            path = jcrExplorer.getCurrentNode().getPath();
        }
        String[] arr = path.replaceFirst(treeRoot.getPath(), "").split("/");
        TreeNode temp = treeRoot;
        String subPath = null;
        String prefix = "/";
        if (!treeRoot.getNode().getPath().equals("/")) {
            prefix = treeRoot.getNode().getPath() + prefix;
        }
        for (String nodeName : arr) {
            if (nodeName.length() == 0) continue;
            subPath = subPath == null ? prefix + nodeName : subPath + "/" + nodeName;
            temp.setChildren(jcrExplorer.getChildrenList(temp.getNode(), false));
            if (temp.getChildrenSize() > nodePerPages) {
                ObjectPageList list = new ObjectPageList(temp.getChildren(), nodePerPages);
                this.addTreeNodePageIteratorAsChild(temp.getPath(), list, temp.getPath(), path);
            }
            if ((temp = temp.getChild(subPath)) != null) continue;
            this.treeRoot_ = treeRoot;
            return;
        }
        temp.setChildren(jcrExplorer.getChildrenList(temp.getNode(), false));
        if (temp.getChildrenSize() > nodePerPages) {
            ObjectPageList list = new ObjectPageList(temp.getChildren(), nodePerPages);
            this.addTreeNodePageIteratorAsChild(temp.getPath(), list, temp.getPath(), path);
        }
        this.treeRoot_ = treeRoot;
    }

    public void buildTree() throws Exception {
        this.buildTree(null);
    }

    static /* synthetic */ void access$000(UITreeExplorer x0, String x1) throws Exception {
        x0.buildTree(x1);
    }
}

