/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.views.TemplateBean;
import org.exoplatform.ecm.webui.component.admin.views.UIECMTemplateList;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;

@ComponentConfig(template="app:/groovy/webui/component/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIECMTemplateList.msg.confirm-delete"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={AddActionListener.class})})
public class UIECMTemplateList
extends UIGrid {
    private static String[] VIEW_BEAN_FIELD = new String[]{"name", "path", "baseVersion"};
    private static String[] VIEW_ACTION = new String[]{"EditInfo", "Delete"};
    public static String ST_ECMTempForm = "ECMTempForm";
    public static String ST_ECMTemp = "ECMTemplate";

    public UIECMTemplateList() throws Exception {
        this.getUIPageIterator().setId("UIECMTemplateGrid");
        this.configure("path", VIEW_BEAN_FIELD, VIEW_ACTION);
    }

    public String[] getActions() {
        return new String[]{"Add"};
    }

    public String getBaseVersion(Node node) throws Exception {
        if (!node.isNodeType("mix:versionable") || node.isNodeType(Utils.NT_FROZEN)) {
            return "";
        }
        return node.getBaseVersion().getName();
    }

    public void updateTempListGrid() throws Exception {
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        List nodes = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getAllTemplates("ecmExplorerTemplates", repository, SessionsUtils.getSessionProvider());
        ArrayList<TemplateBean> tempBeans = new ArrayList<TemplateBean>();
        for (Node node : nodes) {
            tempBeans.add(new TemplateBean(node.getName(), node.getPath(), this.getBaseVersion(node)));
        }
        Collections.sort(tempBeans, new ECMViewComparator());
        this.getUIPageIterator().setPageList((PageList)new ObjectPageList(tempBeans, 10));
    }

    public String getRepository() {
        return ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
    }
}

