/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.jcr.UISelector;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContentPortlet;
import org.exoplatform.ecm.webui.component.browsecontent.UIConfigTabPane;
import org.exoplatform.ecm.webui.component.browsecontent.UINewConfigForm;
import org.exoplatform.ecm.webui.component.browsecontent.UIPathConfig;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={EditActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddPathActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={BackActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeRepoActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeWorkspaceActionListener.class})})
public class UIPathConfig
extends UIForm
implements UISelector {
    public static final String FIELD_PATHSELECT = "path";
    protected boolean isEdit_ = false;
    private List<String> repoNames_ = new ArrayList();
    private List<String> wsNames_ = new ArrayList();

    public UIPathConfig() throws Exception {
        ArrayList Options = new ArrayList();
        ArrayList repositories = new ArrayList();
        ArrayList workspaces = new ArrayList();
        UIFormSelectBox repository = new UIFormSelectBox("repository", "repository", repositories);
        repository.setOnChange("ChangeRepo");
        this.addChild((UIComponent)repository);
        UIFormSelectBox workspace = new UIFormSelectBox("workspace", "workspace", workspaces);
        workspace.setOnChange("ChangeWorkspace");
        this.addChild((UIComponent)workspace);
        UIFormInputSetWithAction categoryPathSelect = new UIFormInputSetWithAction(FIELD_PATHSELECT);
        categoryPathSelect.addUIFormInput((UIFormInput)new UIFormStringInput("categoryPath", null, null));
        this.addUIComponentInput((UIComponent)categoryPathSelect);
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableRefDoc", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableChildDoc", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableTagMap", null, null));
        this.addChild((UIComponent)new UIFormSelectBox("template", null, Options));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableToolBar", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableComment", null, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput("enableVote", null, null));
        this.addChild((UIComponent)new UIFormSelectBox("itemPerPage", null, this.itemPerPages()));
        this.addChild((UIComponent)new UIFormSelectBox("detailBoxTemp", null, Options));
        this.setActions(UINewConfigForm.DEFAULT_ACTION);
    }

    public List<SelectItemOption<String>> getWorkSpaceOption() throws Exception {
        UIConfigTabPane uiTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
        return uiTabPane.getWorkSpaceOption();
    }

    private List<SelectItemOption<String>> itemPerPages() {
        ArrayList<SelectItemOption<String>> itemPerPages = new ArrayList<SelectItemOption<String>>();
        itemPerPages.add(new SelectItemOption("5", (Object)"5"));
        itemPerPages.add(new SelectItemOption("10", (Object)"10"));
        itemPerPages.add(new SelectItemOption("15", (Object)"15"));
        itemPerPages.add(new SelectItemOption("20", (Object)"20"));
        itemPerPages.add(new SelectItemOption("30", (Object)"30"));
        itemPerPages.add(new SelectItemOption("40", (Object)"40"));
        itemPerPages.add(new SelectItemOption("50", (Object)"50"));
        return itemPerPages;
    }

    public PortletPreferences getPortletPreferences() {
        return ((UIBrowseContentPortlet)this.getAncestorOfType(UIBrowseContentPortlet.class)).getPortletPreferences();
    }

    private List<SelectItemOption<String>> getRepoOption() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        this.repoNames_.clear();
        for (RepositoryEntry repo : repositoryService.getConfig().getRepositoryConfigurations()) {
            this.repoNames_.add(repo.getName());
            options.add((SelectItemOption<String>)new SelectItemOption(repo.getName(), (Object)repo.getName()));
        }
        return options;
    }

    private ManageableRepository getRepository(String repositoryName) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getRepository(repositoryName);
    }

    private List<SelectItemOption<String>> getWorkSpaceOption(String repository) throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        String[] workspaceNames = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getWorkspaceNames();
        this.wsNames_.clear();
        for (String workspace : workspaceNames) {
            Session session = SessionsUtils.getSessionProvider().getSession(workspace, this.getRepository(repository));
            try {
                session.getRootNode();
                this.wsNames_.add(workspace);
                options.add((SelectItemOption<String>)new SelectItemOption(workspace, (Object)workspace));
            }
            catch (AccessDeniedException ace) {
                // empty catch block
            }
        }
        return options;
    }

    public void initForm(PortletPreferences preference, String repository, String workSpace, boolean isAddNew) throws Exception {
        String path = preference.getValue(Utils.JCR_PATH, "");
        String hasToolBar = "true";
        String hasRefDoc = "true";
        String hasChildDoc = "true";
        String hasTagMap = "true";
        String hasComment = "true";
        String hasVote = "true";
        String itemPerPage = "20";
        String template = "";
        String detailTemp = "";
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String currentRepositoryName = repositoryService.getCurrentRepository().getConfiguration().getName();
        UIFormSelectBox repositoryField = (UIFormSelectBox)this.getChildById("repository");
        repositoryField.setOptions(this.getRepoOption());
        if (!this.repoNames_.contains(repository)) {
            repository = (String)((SelectItemOption)this.getRepoOption().get(0)).getValue();
        }
        repositoryField.setValue(repository);
        UIFormSelectBox workSpaceField = (UIFormSelectBox)this.getChildById("workspace");
        workSpaceField.setOptions(this.getWorkSpaceOption(repository));
        if (!this.wsNames_.contains(workSpace)) {
            workSpace = repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        }
        workSpaceField.setValue(workSpace);
        UIFormInputSetWithAction categoryPathSelect = (UIFormInputSetWithAction)this.getChildById(FIELD_PATHSELECT);
        UIFormStringInput categoryPathField = (UIFormStringInput)categoryPathSelect.getChildById("categoryPath");
        categoryPathField.setEditable(false);
        UIFormSelectBox templateField = (UIFormSelectBox)this.getChildById("template");
        UIFormSelectBox numbPerPageField = (UIFormSelectBox)this.getChildById("itemPerPage");
        UIFormSelectBox detailtemField = (UIFormSelectBox)this.getChildById("detailBoxTemp");
        UIConfigTabPane uiConfigTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
        UIFormCheckBoxInput enableToolBarField = (UIFormCheckBoxInput)this.getChildById("enableToolBar");
        UIFormCheckBoxInput enableRefDocField = (UIFormCheckBoxInput)this.getChildById("enableRefDoc");
        UIFormCheckBoxInput enableChildDocField = (UIFormCheckBoxInput)this.getChildById("enableChildDoc");
        UIFormCheckBoxInput enableTagMapField = (UIFormCheckBoxInput)this.getChildById("enableTagMap");
        UIFormCheckBoxInput enableCommentField = (UIFormCheckBoxInput)this.getChildById("enableComment");
        UIFormCheckBoxInput enableVoteField = (UIFormCheckBoxInput)this.getChildById("enableVote");
        if (this.isEdit_) {
            categoryPathSelect.setActionInfo("categoryPath", new String[]{"AddPath"});
            if (isAddNew) {
                templateField.setOptions(this.getTemplateOption(repository));
                detailtemField.setOptions(uiConfigTabPane.getBoxTemplateOption(repository));
                enableToolBarField.setChecked(Boolean.parseBoolean(hasToolBar));
                enableRefDocField.setChecked(Boolean.parseBoolean(hasRefDoc));
                enableChildDocField.setChecked(Boolean.parseBoolean(hasChildDoc));
                enableTagMapField.setChecked(Boolean.parseBoolean(hasTagMap));
                enableCommentField.setChecked(Boolean.parseBoolean(hasComment));
                enableVoteField.setChecked(Boolean.parseBoolean(hasVote));
                numbPerPageField.setValue(itemPerPage);
                this.setActions(UINewConfigForm.ADD_NEW_ACTION);
            } else {
                this.setActions(UINewConfigForm.NORMAL_ACTION);
            }
        } else {
            categoryPathSelect.setActionInfo("categoryPath", null);
            this.setActions(UINewConfigForm.DEFAULT_ACTION);
            repository = preference.getValue(Utils.REPOSITORY, "");
            workSpace = preference.getValue(Utils.WORKSPACE_NAME, "");
            template = preference.getValue("template", "");
            hasToolBar = preference.getValue(Utils.CB_VIEW_TOOLBAR, "");
            hasRefDoc = preference.getValue(Utils.CB_REF_DOCUMENT, "");
            hasChildDoc = preference.getValue(Utils.CB_CHILD_DOCUMENT, "");
            hasTagMap = preference.getValue(Utils.CB_VIEW_TAGMAP, "");
            hasComment = preference.getValue(Utils.CB_VIEW_COMMENT, "");
            hasVote = preference.getValue(Utils.CB_VIEW_VOTE, "");
            itemPerPage = preference.getValue(Utils.CB_NB_PER_PAGE, "");
            detailTemp = preference.getValue(Utils.CB_BOX_TEMPLATE, "");
            if (!this.repoNames_.contains(repository)) {
                repository = currentRepositoryName;
            }
            templateField.setOptions(this.getTemplateOption(repository));
            templateField.setValue(template);
            detailtemField.setOptions(uiConfigTabPane.getBoxTemplateOption(repository));
            detailtemField.setValue(detailTemp);
            repositoryField.setValue(repository);
            workSpaceField.setValue(workSpace);
            enableToolBarField.setChecked(Boolean.parseBoolean(hasToolBar));
            enableRefDocField.setChecked(Boolean.parseBoolean(hasRefDoc));
            enableChildDocField.setChecked(Boolean.parseBoolean(hasChildDoc));
            enableTagMapField.setChecked(Boolean.parseBoolean(hasTagMap));
            enableCommentField.setChecked(Boolean.parseBoolean(hasComment));
            enableVoteField.setChecked(Boolean.parseBoolean(hasVote));
            categoryPathField.setValue((Object)path);
            numbPerPageField.setValue(itemPerPage);
        }
        templateField.setEnable(this.isEdit_);
        detailtemField.setEnable(this.isEdit_);
        enableToolBarField.setEnable(this.isEdit_);
        enableRefDocField.setEnable(this.isEdit_);
        enableCommentField.setEnable(this.isEdit_);
        enableVoteField.setEnable(this.isEdit_);
        enableTagMapField.setEnable(this.isEdit_);
        numbPerPageField.setEditable(this.isEdit_);
        enableChildDocField.setEnable(this.isEdit_);
        repositoryField.setEnable(this.isEdit_);
        workSpaceField.setEnable(this.isEdit_);
    }

    public List<SelectItemOption<String>> getTemplateOption(String repository) throws Exception {
        ArrayList<SelectItemOption<String>> Options = new ArrayList<SelectItemOption<String>>();
        ManageViewService viewService = (ManageViewService)PortalContainer.getComponent(ManageViewService.class);
        List scriptTemplates = viewService.getAllTemplates("cbPathTemplates", repository, SessionsUtils.getSystemProvider());
        for (Node template : scriptTemplates) {
            Options.add((SelectItemOption<String>)new SelectItemOption(template.getName(), (Object)template.getName()));
        }
        return Options;
    }

    public void updateSelect(String selectField, String value) {
        UIFormInputSetWithAction categoryPathSelect = (UIFormInputSetWithAction)this.getChildById(FIELD_PATHSELECT);
        UIFormStringInput categoryPathField = (UIFormStringInput)categoryPathSelect.getChildById("categoryPath");
        categoryPathField.setValue((Object)value);
        UIConfigTabPane uiConfigTabPane = (UIConfigTabPane)this.getAncestorOfType(UIConfigTabPane.class);
        UIPopupWindow uiPopupWindow = (UIPopupWindow)uiConfigTabPane.getChild(UIPopupWindow.class);
        uiPopupWindow.setShow(false);
        this.isEdit_ = true;
        uiConfigTabPane.setNewConfig(true);
    }

    static /* synthetic */ List access$000(UIPathConfig x0, String x1) throws Exception {
        return x0.getWorkSpaceOption(x1);
    }
}

