/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.exoplatform.ecm.jcr.UIPopupComponent;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UISelectDocumentForm;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIDocumentFormController
extends UIContainer
implements UIPopupComponent {
    private String defaultDocument_;
    private static String DEFAULT_VALUE = "exo:article";
    private Node currentNode_;
    private String repository_;
    private String workspace_;

    public UIDocumentFormController() throws Exception {
        this.addChild(UISelectDocumentForm.class, null, null);
        UIDocumentForm uiDocumentForm = (UIDocumentForm)this.createUIComponent(UIDocumentForm.class, null, null);
        uiDocumentForm.setTemplateNode(DEFAULT_VALUE);
        uiDocumentForm.addNew(true);
        this.addChild((UIComponent)uiDocumentForm);
    }

    public void setCurrentNode(Node node) {
        this.currentNode_ = node;
    }

    public void setRepository(String repository) {
        this.repository_ = repository;
    }

    public void setWorkspace(String workspace) {
        this.workspace_ = workspace;
    }

    public void initPopup(UIComponent uiComp) throws Exception {
        this.removeChildById("PopupComponent");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "PopupComponent");
        uiPopup.setUIComponent(uiComp);
        uiPopup.setWindowSize(640, 300);
        uiPopup.setShow(true);
        uiPopup.setResizable(true);
    }

    public List<SelectItemOption<String>> getListFileType() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        ArrayList<String> nodeTypes = new ArrayList<String>();
        UISelectDocumentForm uiSelectForm = (UISelectDocumentForm)this.getChild(UISelectDocumentForm.class);
        UIFormSelectBox uiSelectBox = uiSelectForm.getUIFormSelectBox("selectTemplate");
        boolean hasDefaultDoc = false;
        NodeTypeManager ntManager = this.currentNode_.getSession().getWorkspace().getNodeTypeManager();
        NodeType currentNodeType = this.currentNode_.getPrimaryNodeType();
        NodeDefinition[] childDefs = currentNodeType.getChildNodeDefinitions();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List templates = templateService.getDocumentTemplates(this.repository_);
        try {
            block2: for (int i = 0; i < templates.size(); ++i) {
                String nodeTypeName = templates.get(i).toString();
                String label = templateService.getTemplateLabel(nodeTypeName, this.repository_);
                NodeType nodeType = ntManager.getNodeType(nodeTypeName);
                if (nodeType.isMixin() && !nodeTypes.contains(nodeTypeName)) {
                    options.add((SelectItemOption<String>)new SelectItemOption(label, (Object)nodeTypeName));
                    nodeTypes.add(nodeTypeName);
                    continue;
                }
                NodeType[] superTypes = nodeType.getSupertypes();
                boolean isCanCreateDocument = false;
                for (NodeDefinition nodeDefinition : childDefs) {
                    NodeType[] requiredChilds;
                    for (NodeType requiredChild : requiredChilds = nodeDefinition.getRequiredPrimaryTypes()) {
                        if (!nodeTypeName.equals(requiredChild.getName())) continue;
                        isCanCreateDocument = true;
                        break;
                    }
                    if (!nodeTypeName.equals(nodeDefinition.getName()) && !isCanCreateDocument) continue;
                    if (!hasDefaultDoc && nodeTypeName.equals(DEFAULT_VALUE)) {
                        this.defaultDocument_ = DEFAULT_VALUE;
                        hasDefaultDoc = true;
                    }
                    if (!nodeTypes.contains(nodeTypeName)) {
                        options.add((SelectItemOption<String>)new SelectItemOption(label, (Object)nodeTypeName));
                        nodeTypes.add(nodeTypeName);
                    }
                    isCanCreateDocument = true;
                }
                if (isCanCreateDocument) continue;
                for (NodeDefinition nodeDefinition : superTypes) {
                    for (NodeDefinition childDef : childDefs) {
                        for (NodeType requiredType : childDef.getRequiredPrimaryTypes()) {
                            if (!nodeDefinition.getName().equals(requiredType.getName())) continue;
                            if (!hasDefaultDoc && nodeTypeName.equals(DEFAULT_VALUE)) {
                                this.defaultDocument_ = DEFAULT_VALUE;
                                hasDefaultDoc = true;
                            }
                            if (!nodeTypes.contains(nodeTypeName)) {
                                options.add((SelectItemOption<String>)new SelectItemOption(label, (Object)nodeTypeName));
                                nodeTypes.add(nodeTypeName);
                            }
                            isCanCreateDocument = true;
                            break;
                        }
                        if (isCanCreateDocument) break;
                    }
                    if (isCanCreateDocument) continue block2;
                }
            }
            uiSelectBox.setOptions(options);
            if (hasDefaultDoc) {
                uiSelectBox.setValue(this.defaultDocument_);
            } else if (options.size() > 0) {
                this.defaultDocument_ = (String)((SelectItemOption)options.get(0)).getValue();
                uiSelectBox.setValue(this.defaultDocument_);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return options;
    }

    public void init() throws Exception {
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setRepositoryName(this.repository_);
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setTemplateNode(this.defaultDocument_);
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setWorkspace(this.workspace_);
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).setStoredPath(this.currentNode_.getPath());
        ((UIDocumentForm)this.getChild(UIDocumentForm.class)).resetProperties();
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }
}

