/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.jcr.UISelector;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.DialogFormFields;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionForm;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionList;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionListContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionManager;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={DialogFormFields.SaveActionListener.class}), @EventConfig(listeners={DialogFormFields.OnchangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE)})
public class UIActionForm
extends DialogFormFields
implements UISelector {
    private String parentPath_;
    private String nodeTypeName_ = null;
    private boolean isAddNew_;
    private String scriptPath_ = null;
    private boolean isEditInList_ = false;
    private String rootPath_ = null;

    public UIActionForm() throws Exception {
        this.setActions(new String[]{"Save", "Back"});
    }

    public void createNewAction(Node parentNode, String actionType, boolean isAddNew) throws Exception {
        this.reset();
        this.parentPath_ = parentNode.getPath();
        this.nodeTypeName_ = actionType;
        this.isAddNew_ = isAddNew;
        this.components.clear();
        this.properties.clear();
        this.getChildren().clear();
    }

    private Node getParentNode() throws Exception {
        return (Node)this.getSesssion().getItem(this.parentPath_);
    }

    public void updateSelect(String selectField, String value) {
        this.isUpdateSelect_ = true;
        this.getUIStringInput(selectField).setValue((Object)value);
        if (this.isEditInList_) {
            UIActionManager uiManager = (UIActionManager)this.getAncestorOfType(UIActionManager.class);
            UIActionListContainer uiActionListContainer = (UIActionListContainer)uiManager.getChild(UIActionListContainer.class);
            uiActionListContainer.removeChildById("PopupComponent");
        } else {
            UIActionContainer uiActionContainer = (UIActionContainer)this.getParent();
            uiActionContainer.removeChildById("PopupComponent");
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public String getTemplate() {
        return this.getDialogPath();
    }

    public String getDialogPath() {
        this.repositoryName_ = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        String dialogPath = null;
        if (this.nodeTypeName_ != null) {
            try {
                dialogPath = templateService.getTemplatePathByUser(true, this.nodeTypeName_, userName, this.repositoryName_);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return dialogPath;
    }

    public String getTenmplateNodeType() {
        return this.nodeTypeName_;
    }

    private void setPath(String scriptPath) {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (scriptPath.indexOf(":") < 0) {
            scriptPath = uiExplorer.getCurrentWorkspace() + ":" + scriptPath;
        }
        this.scriptPath_ = scriptPath;
    }

    public String getPath() {
        return this.scriptPath_;
    }

    public void setRootPath(String rootPath) {
        this.rootPath_ = rootPath;
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    public void setIsEditInList(boolean isEditInList) {
        this.isEditInList_ = isEditInList;
    }

    public void onchange(Event event) throws Exception {
        if (this.isEditInList_ || !this.isAddNew_) {
            event.getRequestContext().addUIComponentToUpdateByAjax(this.getParent());
            return;
        }
        UIActionManager uiManager = (UIActionManager)this.getAncestorOfType(UIActionManager.class);
        uiManager.setRenderedChild(UIActionContainer.class);
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
    }

    public Node storeValue(Event event) throws Exception {
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        ActionServiceContainer actionServiceContainer = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        Map sortedInputs = Utils.prepareMap((List)this.getChildren(), (Map)this.getInputProperties());
        Node currentNode = uiExplorer.getCurrentNode();
        if (!Utils.isAddNodeAuthorized((Node)currentNode) || !Utils.isSetPropertyNodeAuthorized((Node)currentNode)) {
            uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.no-permission-add", null));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        if (!this.isAddNew_) {
            CmsService cmsService = (CmsService)this.getApplicationComponent(CmsService.class);
            Node storedHomeNode = this.getNode().getParent();
            cmsService.storeNode(this.nodeTypeName_, storedHomeNode, sortedInputs, false, repository);
            if (!uiExplorer.getPreference().isJcrEnable()) {
                uiExplorer.getSession().save();
            }
            if (this.isEditInList_) {
                UIActionManager uiManager = (UIActionManager)this.getAncestorOfType(UIActionManager.class);
                UIPopupWindow uiPopup = (UIPopupWindow)uiManager.findComponentById("editActionPopup");
                uiPopup.setShow(false);
                uiPopup.setRendered(false);
                uiManager.setDefaultConfig();
                this.isEditInList_ = false;
                this.isAddNew_ = true;
                this.setIsOnchange(false);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
                uiExplorer.setIsHidePopup(true);
                uiExplorer.updateAjax(event);
            } else {
                uiExplorer.setIsHidePopup(false);
                uiExplorer.updateAjax(event);
            }
            this.setPath(storedHomeNode.getPath());
            return this.getNode();
        }
        try {
            JcrInputProperty rootProp = (JcrInputProperty)sortedInputs.get("/node");
            if (rootProp == null) {
                rootProp = new JcrInputProperty();
                rootProp.setJcrPath("/node");
                rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
                sortedInputs.put("/node", rootProp);
            } else {
                rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
            }
            String actionName = (String)((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue();
            if (this.getParentNode().hasNode(actionName)) {
                Object[] args = new Object[]{actionName};
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.existed-action", args));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return null;
            }
            if (this.getParentNode().isNew()) {
                Object[] args = new String[]{this.getParentNode().getPath()};
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.unable-add-action", args));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return null;
            }
            actionServiceContainer.addAction(this.getParentNode(), repository, this.nodeTypeName_, sortedInputs);
            this.setIsOnchange(false);
            if (!uiExplorer.getPreference().isJcrEnable()) {
                uiExplorer.getSession().save();
            }
            UIActionManager uiActionManager = (UIActionManager)this.getAncestorOfType(UIActionManager.class);
            this.createNewAction(uiExplorer.getCurrentNode(), this.nodeTypeName_, true);
            UIActionList uiActionList = (UIActionList)uiActionManager.findFirstComponentOfType(UIActionList.class);
            uiActionList.updateGrid(this.getParentNode());
            uiActionManager.setRenderedChild(UIActionListContainer.class);
            this.reset();
            this.isEditInList_ = false;
        }
        catch (RepositoryException repo) {
            String key = "UIActionForm.msg.repository-exception";
            uiApp.addMessage(new ApplicationMessage(key, null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        catch (NumberFormatException nume) {
            String key = "UIActionForm.msg.numberformat-exception";
            uiApp.addMessage(new ApplicationMessage(key, null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.unable-add", null));
            return null;
        }
        return null;
    }

    static /* synthetic */ boolean access$000(UIActionForm x0) {
        return x0.isEditInList_;
    }

    static /* synthetic */ boolean access$100(UIActionForm x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ boolean access$002(UIActionForm x0, boolean x1) {
        x0.isEditInList_ = x1;
        return x0.isEditInList_;
    }
}

