/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.benchmark.preparation.repository;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.wcm.benchmark.preparation.repository.FastAPI;
import org.exoplatform.wcm.benchmark.preparation.repository.RepoloadServiceImpl;

public class RepoloadWorker
extends Thread {
    RepoloadServiceImpl repoload = null;
    private static final String SPETIAL_TITLE = "eXoPlatformTitle";
    private int l1;
    private int firstWord;
    private int secontWord;
    private int startIndex;
    private int delitelFirstWord;
    private int delitelSecondWord;
    private int totalFile;
    protected Log log = ExoLogger.getLogger((String)"repload.RepoloadWorker");
    Session session = null;
    private String[] fileNames;
    private List<byte[]> fileBuffer;
    private final Random random;
    private long lastStop = 0L;
    private final CountDownLatch loch;
    private int spetialTitleCount = 0;
    private final boolean[] titlesMap;

    public RepoloadWorker(RepoloadServiceImpl repoload, int l1, int firstWord, int secondWord, int startIndex, boolean[] randomPeriod, CountDownLatch loch) throws IOException {
        this.repoload = repoload;
        this.l1 = l1;
        this.firstWord = firstWord;
        this.secontWord = secondWord;
        this.startIndex = startIndex;
        this.titlesMap = randomPeriod;
        this.loch = loch;
        this.random = new Random();
        this.delitelFirstWord = 100 / firstWord;
        this.delitelSecondWord = 100 / secondWord;
        this.totalFile = 0;
        this.setName("Repoload worker " + l1);
        this.fileNames = new String[]{"/conf/datafile.txt", "/conf/ferst_word.txt", "/conf/second_word.txt"};
        this.fileBuffer = new ArrayList<byte[]>(this.fileNames.length);
        this.loadFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Session session = null;
        FastAPI fastAPI = null;
        try {
            session = this.repoload.repositoryService.getRepository(this.repoload.repository).getSystemSession(this.repoload.workspace);
            fastAPI = new FastAPI((SessionImpl)session);
            TransientNodeData nodeL1 = fastAPI.addNode("node" + (this.l1 + this.startIndex), this.l1, (NodeImpl)this.repoload.rootNode);
            for (int l2 = 0; l2 < this.repoload.l2Count; ++l2) {
                TransientNodeData nodeL2 = fastAPI.addNode("node" + l2, l2, nodeL1);
                for (int l3 = 0; l3 < this.repoload.l3Count; ++l3) {
                    TransientNodeData nodeL3 = fastAPI.addNode("node" + l3, l3, nodeL2);
                    long before = System.currentTimeMillis();
                    String prefix = this.l1 + "-" + l2 + "-" + l3;
                    for (int l4 = 0; l4 < this.repoload.l4Count; ++l4) {
                        String fileName;
                        String title = fileName = prefix + "-" + l4;
                        if (this.titlesMap[this.totalFile]) {
                            title = SPETIAL_TITLE;
                            ++this.spetialTitleCount;
                        }
                        fastAPI.addNode_file(fileName + ".txt", l4, prefix, nodeL3, this.getFileValueData(), this.repoload.mimeType, title);
                    }
                    fastAPI.commit();
                    this.log.info((Object)(prefix + " loaded in " + (System.currentTimeMillis() - before) + "\t" + (this.totalFile - 1) + " document loaded."));
                }
                this.log.info((Object)(this.memoryInfo() + "\n"));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Exception in worker " + this.l1), (Throwable)e);
        }
        finally {
            try {
                fastAPI.release();
                this.loch.countDown();
            }
            catch (Exception exception) {}
        }
    }

    public int getSpetialTitleCount() {
        return this.spetialTitleCount;
    }

    public TransientValueData getFileValueData() {
        int fileNumber = 0;
        if (this.totalFile % this.delitelFirstWord == 0) {
            fileNumber = 1;
        }
        if (this.totalFile % this.delitelSecondWord == 1) {
            fileNumber = 2;
        }
        ++this.totalFile;
        return new TransientValueData((InputStream)new ByteArrayInputStream(this.fileBuffer.get(fileNumber)));
    }

    private void loadFiles() throws IOException {
        for (int i = 0; i < this.fileNames.length; ++i) {
            int len;
            InputStream is = this.getClass().getResourceAsStream(this.fileNames[i]);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > 0) {
                bos.write(buf, 0, len);
            }
            byte[] data = bos.toByteArray();
            this.fileBuffer.add(data);
        }
    }

    private String memoryInfo() {
        String info = "";
        info = "free: " + this.mb(Runtime.getRuntime().freeMemory()) + "M of " + this.mb(Runtime.getRuntime().totalMemory()) + "M (max: " + this.mb(Runtime.getRuntime().maxMemory()) + "M)";
        return info;
    }

    private String mb(long mem) {
        return String.valueOf((double)Math.round((double)mem * 100.0 / 1048576.0) / 100.0);
    }

    public int getTotalFile() {
        return this.totalFile;
    }

    public Random getRandom() {
        return this.random;
    }
}

