/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.benchmark.preparation.organization;

import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.picocontainer.Startable;

public class OrganizationCreationService
implements Startable {
    private String userNamePrefix;
    private String commonPassword;
    private int numberOfUsers;
    private OrganizationService organizationService;
    private static Log log = ExoLogger.getLogger((String)"lab:organization");

    public OrganizationCreationService(InitParams initParams, OrganizationService organizationService) {
        this.userNamePrefix = initParams.getValueParam("userNamePrefix").getValue();
        this.numberOfUsers = Integer.parseInt(initParams.getValueParam("numberOfUsers").getValue());
        this.commonPassword = initParams.getValueParam("commonPassword").getValue();
        this.organizationService = organizationService;
    }

    private void createUsers() {
        log.info((Object)("Start create users for organization with: " + this.numberOfUsers + " users, users name prefix: " + this.userNamePrefix + " and common password is: " + this.commonPassword));
        long start = System.currentTimeMillis();
        UserHandler handler = this.organizationService.getUserHandler();
        for (int i = 1; i < this.numberOfUsers; ++i) {
            String userName = this.userNamePrefix + Integer.toString(i);
            String email = userName.concat("@exoplatform.com");
            try {
                User user = handler.createUserInstance(userName);
                user.setEmail(email);
                user.setPassword(this.commonPassword);
                user.setFullName(userName);
                user.setFirstName(userName);
                user.setLastName("exo");
                handler.createUser(user, true);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Error when create user" + userName), e.fillInStackTrace());
            }
        }
        long creationTime = System.currentTimeMillis() - start;
        log.info((Object)("Create " + this.numberOfUsers + " users in " + creationTime / 1000L + "s"));
    }

    public void start() {
        this.createUsers();
    }

    public void stop() {
    }
}

