/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.webui.core.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterConstant {
    public static final String CATEGORIES_PROPERTY_ADDMINISTRATOR = "exo:newsletteraddministrator";
    public static final String CATEGORY_NODETYPE = "exo:newsletterCategory";
    public static final String CATEGORY_PROPERTY_TITLE = "exo:newsletterCategoryTitle";
    public static final String CATEGORY_PROPERTY_DESCRIPTION = "exo:newsletterCategoryDescription";
    public static final String SUBSCRIPTION_NODETYPE = "exo:newsletterSubscription";
    public static final String SUBSCRIPTION_PROPERTY_USER = "exo:newsletterSubscribedUser";
    public static final String SUBSCRIPTION_PROPERTY_TITLE = "exo:newsletterSubscriptionTitle";
    public static final String SUBSCRIPTION_PROPERTY_DECRIPTION = "exo:newsletterSubscriptionDecription";
    public static final String SUBSCRIPTION_PROPERTY_CATEGORY_NAME = "exo:newsletterSubscriptionCategoryName";
    public static final String ENTRY_NODETYPE = "exo:newsletterEntry";
    public static final String ENTRY_PROPERTY_TYPE = "exo:newsletterEntryType";
    public static final String ENTRY_PROPERTY_DATE = "exo:newsletterEntryDate";
    public static final String ENTRY_PROPERTY_STATUS = "exo:newsletterEntryStatus";
    public static final String ENTRY_PROPERTY_SUBSCRIPTION_NAME = "exo:newsletterEntrySubscriptionName";
    public static final String ENTRY_PROPERTY_CATEGORY_NAME = "exo:newsletterEntryCategoryName";
    public static final String ENTRY_PROPERTY_CONTENT_MAIN = "exo:newsletterEntryContentMain";
    public static final String ENTRY_PROPERTY_NAME = "exo:newsletterEntryName";
    public static final String ENTRY_PROPERTY_TITLE = "exo:newsletterEntryTitle";
    public static final String USER_NODETYPE = "exo:newsletterUser";
    public static final String USER_PROPERTY_MAIL = "exo:newsletterUserMail";
    public static final String USER_PROPERTY_BANNED = "exo:newsletterUserBanned";
    public static final String USER_PROPERTY_VALIDATION_CODE = "exo:newsletterUserValidationCode";
    public static final String USER_PROPERTY_IS_CONFIRM = "exo:newsletterUserConfirm";
    public static final String STATUS_DRAFT = "draft";
    public static final String STATUS_AWAITING = "awaiting";
    public static final String STATUS_SENT = "sent";
    public static final String PORTAL_NAME = "portalName";
    public static String TEMPLATE_BASE_PATH = "/sites content/live/portalName/ApplicationData/NewsletterApplication/DefaultTemplates";
    public static String CATEGORY_BASE_PATH = "/sites content/live/portalName/ApplicationData/NewsletterApplication/Categories";
    public static String USER_BASE_PATH = "/sites content/live/portalName/ApplicationData/NewsletterApplication/Users";
    private static UIComponent component;
    private static Session session;

    public static Session getSession() {
        return session;
    }

    public static void setSession(Session session) {
        NewsletterConstant.session = session;
    }

    public static UIComponent getComponent() {
        return component;
    }

    public static void setComponent(UIComponent component) {
        NewsletterConstant.component = component;
    }

    public static String generateDefaultTemplatePath(String portalName) {
        return TEMPLATE_BASE_PATH.replaceAll(PORTAL_NAME, portalName);
    }

    public static String generateCategoryTemplateBasePath(String portalName, String categoryName) {
        return NewsletterConstant.generateCategoryPath(portalName).concat("/" + categoryName).concat("/Templates");
    }

    public static String generateCategoryPath(String portalName) {
        return CATEGORY_BASE_PATH.replaceAll(PORTAL_NAME, portalName);
    }

    public static String generateUserPath(String portalName) {
        return USER_BASE_PATH.replaceAll(PORTAL_NAME, portalName);
    }

    public static String generateSubscriptionPath(String portalName, String categoryName, String subscriptionName) {
        return NewsletterConstant.generateCategoryPath(portalName).concat("/" + categoryName).concat("/" + subscriptionName);
    }

    public static String generateNewsletterPath(String portalName, String categoryName, String subscriptionName, String newsletterName) {
        return NewsletterConstant.generateSubscriptionPath(portalName, categoryName, subscriptionName).concat("/" + newsletterName);
    }

    public static List<String> getAllPermissionOfNode(Node node) throws Exception {
        ExtendedNode webContent = (ExtendedNode)node;
        Iterator permissionIterator = webContent.getACL().getPermissionEntries().iterator();
        HashMap<String, Integer> mapPermission = new HashMap<String, Integer>();
        while (permissionIterator.hasNext()) {
            AccessControlEntry accessControlEntry = (AccessControlEntry)permissionIterator.next();
            String currentIdentity = accessControlEntry.getIdentity();
            if (mapPermission.containsKey(currentIdentity)) {
                mapPermission.put(currentIdentity, (Integer)mapPermission.get(currentIdentity) + 1);
                continue;
            }
            mapPermission.put(currentIdentity, 1);
        }
        int size = PermissionType.ALL.length;
        ArrayList<String> listPermission = new ArrayList<String>();
        for (String key : mapPermission.keySet().toArray(new String[0])) {
            if ((Integer)mapPermission.get(key) != size) continue;
            listPermission.add(key);
        }
        return listPermission;
    }

    public static List<String> getAllGroupAndMembershipOfCurrentUser(String userId) throws Exception {
        OrganizationService oservice = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection memberships = oservice.getMembershipHandler().findMembershipsByUser(userId);
        if (memberships == null || memberships.size() < 0) {
            return userMemberships;
        }
        Object[] objects = memberships.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Membership membership = (Membership)objects[i];
            String role = membership.getMembershipType() + ":" + membership.getGroupId();
            userMemberships.add(role);
        }
        return userMemberships;
    }

    public static boolean havePermission(List<String> list1, List<String> list2) {
        for (String str : list1) {
            if (!list2.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static void addPermissionsFromCateToSubs(Node categoryNode, String[] userIds, String[] permissions) throws Exception {
        NodeIterator ni = categoryNode.getNodes();
        while (ni.hasNext()) {
            ExtendedNode extendSubscriptionNode;
            Node subscriptionNode = ni.nextNode();
            if (!subscriptionNode.isNodeType(SUBSCRIPTION_NODETYPE) || !(extendSubscriptionNode = (ExtendedNode)ExtendedNode.class.cast(subscriptionNode)).canAddMixin("exo:privilegeable") && !extendSubscriptionNode.isNodeType("exo:privilegeable")) continue;
            if (extendSubscriptionNode.canAddMixin("exo:privilegeable")) {
                extendSubscriptionNode.addMixin("exo:privilegeable");
            }
            for (String userId : userIds) {
                extendSubscriptionNode.setPermission(userId, permissions);
            }
        }
    }

    public static void updateAccessPermission(String[] accessPermissions, UIComponent component) throws Exception {
        NewsletterConstant.setComponent(component);
        UserPortalConfigService userService = (UserPortalConfigService)component.getApplicationComponent(UserPortalConfigService.class);
        Page page = userService.getPage(Util.getUIPortal().getSelectedNode().getPageReference());
        ArrayList<String> listAccess = new ArrayList<String>();
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)component.getApplicationComponent(WCMConfigurationService.class);
        String editSitePermission = Util.getUIPortal().getEditPermission();
        String redactorMembershipType = wcmConfigurationService.getRuntimeContextParam("redactorMembershipType");
        String groupName = null;
        if (editSitePermission.indexOf(":") != -1) {
            groupName = editSitePermission.substring(editSitePermission.indexOf(":") + 1);
        }
        OrganizationService organizationService = (OrganizationService)component.getApplicationComponent(OrganizationService.class);
        MembershipHandler memberShipHandler = organizationService.getMembershipHandler();
        Group group = organizationService.getGroupHandler().findGroupById(groupName);
        MembershipType membershipType = organizationService.getMembershipTypeHandler().findMembershipType(redactorMembershipType);
        UserHandler userHandler = organizationService.getUserHandler();
        listAccess.addAll(Arrays.asList(page.getAccessPermissions()));
        List<String> userViewAdminToolBar = NewsletterConstant.getUserPermission(new String[]{editSitePermission});
        for (String acc : accessPermissions) {
            if (listAccess.contains(acc)) continue;
            for (String uid : NewsletterConstant.getUserPermission(new String[]{acc})) {
                if (userViewAdminToolBar.contains(uid)) continue;
                userViewAdminToolBar.add(uid);
                memberShipHandler.linkMembership(userHandler.findUserByName(uid), group, membershipType, true);
            }
            listAccess.add(acc);
        }
        page.setAccessPermissions(listAccess.toArray(new String[0]));
        userService.update(page);
    }

    public static void removeAccessPermission(String[] removePermissions) {
        if (removePermissions == null) {
            return;
        }
        UserPortalConfigService userService = (UserPortalConfigService)component.getApplicationComponent(UserPortalConfigService.class);
        try {
            Page page = userService.getPage(Util.getUIPortal().getSelectedNode().getPageReference());
            ArrayList<String> listAccess = new ArrayList<String>();
            OrganizationService organizationService = (OrganizationService)component.getApplicationComponent(OrganizationService.class);
            MembershipHandler memberShipHandler = organizationService.getMembershipHandler();
            listAccess.addAll(Arrays.asList(page.getAccessPermissions()));
            for (String acc : removePermissions) {
                if (!listAccess.contains(acc)) continue;
                listAccess.remove(acc);
                memberShipHandler.removeMembershipByUser(acc, true);
            }
            page.setAccessPermissions(listAccess.toArray(new String[0]));
            userService.update(page);
        }
        catch (Exception e) {
            return;
        }
    }

    public static List<String> getUserPermission(String[] userGroupMembership) throws Exception {
        ArrayList<String> users = new ArrayList<String>();
        if (userGroupMembership == null || userGroupMembership.length <= 0 || userGroupMembership.length == 1 && userGroupMembership[0].equals(" ")) {
            return users;
        }
        OrganizationService organizationService = (OrganizationService)PortalContainer.getComponent(OrganizationService.class);
        for (String str : userGroupMembership) {
            if ((str = str.trim()).indexOf("/") >= 0) {
                if (str.indexOf(":") >= 0) {
                    String[] array = str.split(":");
                    List userList = organizationService.getUserHandler().findUsersByGroup(array[1]).getAll();
                    if (array[0].length() > 1) {
                        block1: for (User user : userList) {
                            if (users.contains(user.getUserName())) continue;
                            Collection memberships = organizationService.getMembershipHandler().findMembershipsByUser(user.getUserName());
                            for (Membership member : memberships) {
                                if (!member.getMembershipType().equals(array[0])) continue;
                                users.add(user.getUserName());
                                continue block1;
                            }
                        }
                        continue;
                    }
                    if (array[0].charAt(0) != '*') continue;
                    for (User user : userList) {
                        if (users.contains(user.getUserName())) continue;
                        users.add(user.getUserName());
                    }
                    continue;
                }
                List userList = organizationService.getUserHandler().findUsersByGroup(str).getAll();
                for (User user : userList) {
                    if (users.contains(user.getUserName())) continue;
                    users.add(user.getUserName());
                }
                continue;
            }
            if (users.contains(str)) continue;
            users.add(str);
        }
        return users;
    }

    public static NodeIterator getAllCategories(Session session) throws Exception {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String sqlQuery = "Select * from exo:newsletterCategory";
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        return queryResult.getNodes();
    }

    public static List<String> getAllRedactor(String portalName) throws Exception {
        Session session = NewsletterConstant.getSession();
        ArrayList<String> list = new ArrayList<String>();
        String path = NewsletterConstant.generateCategoryPath(portalName);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String sqlQuery = "select * from exo:newsletterSubscription where jcr:path LIKE '" + path + "[%]/%'";
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        while (nodeIterator.hasNext()) {
            Node subNode = nodeIterator.nextNode();
            for (String str : NewsletterConstant.getAllPermissionOfNode(subNode)) {
                if (list.contains(str)) continue;
                list.add(str);
            }
        }
        return list;
    }

    public static List<String> removePermission(Node subscriptionNode, Node categoryNode, List<String> candidateRemove, boolean isAddNew, String portalName, Session session) {
        NewsletterConstant.setSession(session);
        if (candidateRemove == null) {
            candidateRemove = new ArrayList<String>();
        }
        try {
            NodeIterator categoriesIterator = NewsletterConstant.getAllCategories(session);
            List<String> allRedactor = NewsletterConstant.getAllRedactor(portalName);
            List<String> allpermissions = null;
            block2: while (categoriesIterator.hasNext()) {
                allpermissions = NewsletterConstant.getAllPermissionOfNode(categoriesIterator.nextNode());
                for (String permission : allpermissions) {
                    if (candidateRemove.isEmpty()) continue block2;
                    if (!candidateRemove.contains(permission)) continue;
                    candidateRemove.remove(permission);
                }
            }
            for (String redactor : allRedactor) {
                if (!candidateRemove.isEmpty()) {
                    if (!candidateRemove.contains(redactor)) continue;
                    candidateRemove.remove(redactor);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
        return candidateRemove;
    }

    public static List<String> convertValuesToArray(Value[] values) {
        ArrayList<String> listString = new ArrayList<String>();
        for (Value value : values) {
            try {
                listString.add(value.getString());
            }
            catch (Exception e) {
                return null;
            }
        }
        return listString;
    }
}

