/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.post;

import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostCreateContentEventListener
extends Listener<CmsService, Node> {
    private WCMPublicationService publicationService;
    private WCMConfigurationService configurationService;
    private WebContentSchemaHandler webContentSchemaHandler;
    private static Log log = ExoLogger.getLogger(PostCreateContentEventListener.class);

    public PostCreateContentEventListener(WCMPublicationService publicationService, WCMConfigurationService configurationService, WebSchemaConfigService schemaConfigService) {
        this.publicationService = publicationService;
        this.configurationService = configurationService;
        this.webContentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
    }

    public void onEvent(Event<CmsService, Node> event) throws Exception {
        NodeLocation nodeLocation;
        Node currentNode = (Node)event.getData();
        if (currentNode.canAddMixin("exo:rss-enable")) {
            currentNode.addMixin("exo:rss-enable");
            if (!currentNode.hasProperty("exo:title")) {
                currentNode.setProperty("exo:title", currentNode.getName());
            }
        }
        if (this.webContentSchemaHandler.isWebcontentChildNode(currentNode) || currentNode.isNodeType("exo:cssFile") || currentNode.isNodeType("exo:jsFile") || currentNode.getParent().isNodeType("exo:actionStorage")) {
            return;
        }
        String repository = ((ManageableRepository)currentNode.getSession().getRepository()).getConfiguration().getName();
        String workspace = currentNode.getSession().getWorkspace().getName();
        if (!workspace.equalsIgnoreCase((nodeLocation = this.configurationService.getLivePortalsLocation(repository)).getWorkspace())) {
            return;
        }
        if (!currentNode.getPath().startsWith(nodeLocation.getPath())) {
            return;
        }
        String siteName = null;
        String remoteUser = null;
        try {
            siteName = Util.getPortalRequestContext().getPortalOwner();
            remoteUser = Util.getPortalRequestContext().getRemoteUser();
        }
        catch (Exception e) {
            log.error((Object)"Error when perform onEvent: ", e.fillInStackTrace());
        }
        this.publicationService.updateLifecyleOnChangeContent(currentNode, siteName, remoteUser);
    }
}

