/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.page;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationPlugin;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageEventListenerDelegate {
    private String lifecycleName;

    public PageEventListenerDelegate(String lifecycleName, ExoContainer container) {
        this.lifecycleName = lifecycleName;
    }

    public void updateLifecyleOnCreatePage(Page page, String remoteUser) throws Exception {
        this.updateAddedApplication(page, remoteUser);
    }

    public void updateLifecyleOnChangePage(Page page, String remoteUser) throws Exception {
        this.updateAddedApplication(page, remoteUser);
        this.updateRemovedApplication(page, remoteUser);
    }

    public void updateLifecycleOnRemovePage(Page page, String remoteUser) throws Exception {
        WCMConfigurationService wcmConfigurationService = StageAndVersionPublicationUtil.getServices(WCMConfigurationService.class);
        List<String> listPageApplicationId = StageAndVersionPublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("SCVPortlet"));
        for (String applicationId : listPageApplicationId) {
            Node content = StageAndVersionPublicationUtil.getNodeByApplicationId(applicationId);
            if (content == null) continue;
            this.saveRemovedApplication(page, applicationId, content, remoteUser);
        }
    }

    private void updateAddedApplication(Page page, String remoteUser) throws Exception {
        WCMConfigurationService wcmConfigurationService = StageAndVersionPublicationUtil.getServices(WCMConfigurationService.class);
        List<String> listPageApplicationId = StageAndVersionPublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("SCVPortlet"));
        for (String applicationtId : listPageApplicationId) {
            Node content = StageAndVersionPublicationUtil.getNodeByApplicationId(applicationtId);
            if (content == null) continue;
            this.saveAddedApplication(page, applicationtId, content, this.lifecycleName, remoteUser);
        }
    }

    private void updateRemovedApplication(Page page, String remoteUser) throws Exception {
        List<Node> listNode = this.getListNodeByApplicationId(page);
        WCMConfigurationService wcmConfigurationService = StageAndVersionPublicationUtil.getServices(WCMConfigurationService.class);
        List<String> listApplicationId = StageAndVersionPublicationUtil.getListApplicationIdByPage(page, wcmConfigurationService.getRuntimeContextParam("SCVPortlet"));
        for (Node content : listNode) {
            for (Value value : content.getProperty("publication:applicationIDs").getValues()) {
                String[] tmp = StageAndVersionPublicationUtil.parseMixedApplicationId(value.getString());
                String nodeApplicationId = tmp[1];
                if (!tmp[0].equals(page.getPageId()) || listApplicationId.contains(nodeApplicationId)) continue;
                this.saveRemovedApplication(page, nodeApplicationId, content, remoteUser);
            }
        }
    }

    private List<Node> getListNodeByApplicationId(Page page) throws Exception {
        RepositoryService repositoryService = StageAndVersionPublicationUtil.getServices(RepositoryService.class);
        WCMConfigurationService configurationService = StageAndVersionPublicationUtil.getServices(WCMConfigurationService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        NodeLocation nodeLocation = configurationService.getLivePortalsLocation(repository.getConfiguration().getName());
        String repositoryName = nodeLocation.getRepository();
        String workspaceName = nodeLocation.getWorkspace();
        String path = nodeLocation.getPath();
        SessionProvider sessionProvider = SessionProviderFactory.createSystemProvider();
        Session session = sessionProvider.getSession(workspaceName, repositoryService.getRepository(repositoryName));
        ArrayList<Node> listPublishedNode = new ArrayList<Node>();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery("select * from " + StageAndVersionPublicationConstant.PUBLICATION_LIFECYCLE_TYPE + " where publication:lifecycleName='" + this.lifecycleName + "' and publication:webPageIDs like '%" + page.getPageId() + "%' and jcr:path like '" + path + "/%' order by jcr:score", "sql");
        QueryResult results = query.execute();
        NodeIterator nodeIterator = results.getNodes();
        while (nodeIterator.hasNext()) {
            listPublishedNode.add(nodeIterator.nextNode());
        }
        sessionProvider.close();
        return listPublishedNode;
    }

    private void saveAddedApplication(Page page, String applicationId, Node content, String lifecycleName, String remoteUser) throws Exception {
        String mixedAppId;
        List<String> nodeAppIds;
        PublicationService publicationService = StageAndVersionPublicationUtil.getServices(PublicationService.class);
        String nodeLifecycleName = null;
        try {
            nodeLifecycleName = publicationService.getNodeLifecycleName(content);
        }
        catch (NotInPublicationLifecycleException e) {
            return;
        }
        if (!lifecycleName.equals(nodeLifecycleName)) {
            return;
        }
        WCMPublicationService presentationService = StageAndVersionPublicationUtil.getServices(WCMPublicationService.class);
        StageAndVersionPublicationPlugin publicationPlugin = (StageAndVersionPublicationPlugin)presentationService.getWebpagePublicationPlugins().get(StageAndVersionPublicationConstant.LIFECYCLE_NAME);
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        if (content.canAddMixin("publication:webpagesPublication")) {
            content.addMixin("publication:webpagesPublication");
        }
        if ((nodeAppIds = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:applicationIDs")).contains(mixedAppId = StageAndVersionPublicationUtil.setMixedApplicationId(page.getPageId(), applicationId))) {
            return;
        }
        List<String> listExistedNavigationNodeUri = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        List<String> listPageNavigationUri = publicationPlugin.getListPageNavigationUri(page, remoteUser);
        if (listPageNavigationUri.isEmpty()) {
            return;
        }
        for (String uri : listPageNavigationUri) {
            listExistedNavigationNodeUri.add(uri);
        }
        content.setProperty("publication:navigationNodeURIs", StageAndVersionPublicationUtil.toValues(valueFactory, listExistedNavigationNodeUri));
        List<String> nodeWebPageIds = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        nodeWebPageIds.add(page.getPageId());
        nodeAppIds.add(mixedAppId);
        content.setProperty("publication:applicationIDs", StageAndVersionPublicationUtil.toValues(valueFactory, nodeAppIds));
        content.setProperty("publication:webPageIDs", StageAndVersionPublicationUtil.toValues(valueFactory, nodeWebPageIds));
        session.save();
    }

    private void saveRemovedApplication(Page page, String applicationId, Node content, String remoteUser) throws Exception {
        WCMPublicationService presentationService = StageAndVersionPublicationUtil.getServices(WCMPublicationService.class);
        StageAndVersionPublicationPlugin publicationPlugin = (StageAndVersionPublicationPlugin)presentationService.getWebpagePublicationPlugins().get(StageAndVersionPublicationConstant.LIFECYCLE_NAME);
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedApplicationId = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:applicationIDs");
        listExistedApplicationId.remove(StageAndVersionPublicationUtil.setMixedApplicationId(page.getPageId(), applicationId));
        content.setProperty("publication:applicationIDs", StageAndVersionPublicationUtil.toValues(valueFactory, listExistedApplicationId));
        List<String> listExistedPageId = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        listExistedPageId.remove(page.getPageId());
        content.setProperty("publication:webPageIDs", StageAndVersionPublicationUtil.toValues(valueFactory, listExistedPageId));
        List<String> listPageNavigationUri = publicationPlugin.getListPageNavigationUri(page, remoteUser);
        List<String> listExistedNavigationNodeUri = StageAndVersionPublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        ArrayList<String> listExistedNavigationNodeUriTmp = new ArrayList<String>();
        listExistedNavigationNodeUriTmp.addAll(listExistedNavigationNodeUri);
        for (String existedNavigationNodeUri : listExistedNavigationNodeUriTmp) {
            if (!listPageNavigationUri.contains(existedNavigationNodeUri)) continue;
            listExistedNavigationNodeUri.remove(existedNavigationNodeUri);
            break;
        }
        content.setProperty("publication:navigationNodeURIs", StageAndVersionPublicationUtil.toValues(valueFactory, listExistedNavigationNodeUri));
        session.save();
    }
}

