/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationPagesContainer;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.ui.UIPublicationTree;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/wcm/webui/publication/lifecycle/stageversion/ui/UIPortalNavigationExplorer.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UIPortalNavigationExplorer
extends UIContainer {
    private String portalName;
    private List<String> runningPortals = new ArrayList<String>();
    private UIPublicationTree.TreeNode currentNode = null;

    public void init(String portalName, List<String> runningPortals) throws Exception {
        SessionProvider sessionProvider;
        this.portalName = portalName;
        this.runningPortals = runningPortals;
        ArrayList<UIPublicationTree.TreeNode> list = new ArrayList<UIPublicationTree.TreeNode>();
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        LocaleConfig localeConfig = ((LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class)).getLocaleConfig(portalApplication.getLocale().getLanguage());
        WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
        if (wcmService.isSharedPortal(sessionProvider = WCMCoreUtils.getSystemSessionProvider(), portalName)) {
            UIPublicationTree tree = (UIPublicationTree)this.addChild(UIPublicationTree.class, null, "UIPortalTree");
            for (String portal : this.runningPortals) {
                PageNavigation pageNavigation = this.getPortalNavigation(portal);
                ResourceBundle res = localeConfig.getNavigationResourceBundle(pageNavigation.getOwnerType(), pageNavigation.getOwnerId());
                UIPublicationTree.TreeNode treeNode = new UIPublicationTree.TreeNode(portal, pageNavigation, res, false);
                if (pageNavigation.getNodes() != null) {
                    treeNode.setChildrenByPageNodes(pageNavigation.getNodes());
                }
                list.add(treeNode);
            }
            tree.setSibbling(list);
            tree.setBeanIdField("uri");
            tree.setBeanLabelField("resolvedLabel");
            tree.setIcon("DefaultPageIcon");
            tree.setSelectedIcon("DefaultPageIcon");
        } else {
            UIPublicationTree tree = (UIPublicationTree)this.addChild(UIPublicationTree.class, null, "UIPageNodeTree");
            PageNavigation navigation = this.getPortalNavigation(portalName);
            ResourceBundle res = localeConfig.getNavigationResourceBundle(navigation.getOwnerType(), navigation.getOwnerId());
            UIPublicationTree.TreeNode treeNode = new UIPublicationTree.TreeNode(portalName, navigation, res, true);
            if (navigation.getNodes() != null) {
                treeNode.setChildrenByPageNodes(navigation.getNodes());
            }
            tree.setSibbling(treeNode.getTreeNodeChildren());
            tree.setBeanIdField("uri");
            tree.setBeanLabelField("resolvedLabel");
            tree.setIcon("DefaultPageIcon");
            tree.setSelectedIcon("DefaultPageIcon");
        }
    }

    private PageNavigation getPortalNavigation(String portalName) throws Exception {
        Query query;
        DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        LazyPageList list = dataStorage.find(query = new Query("portal", portalName, PageNavigation.class));
        Iterator i$ = list.getAll().iterator();
        if (i$.hasNext()) {
            Object object = i$.next();
            return (PageNavigation)PageNavigation.class.cast(object);
        }
        return null;
    }

    public void selectTreeNodeByUri(String uri) throws Exception {
        UIPublicationTree.TreeNode selected;
        UIPublicationTree tree = (UIPublicationTree)this.getChild(UIPublicationTree.class);
        if (this.currentNode == null) {
            List sibbling = tree.getSibbling();
            for (UIPublicationTree.TreeNode childNode : sibbling) {
                if (!childNode.getUri().equals(uri)) continue;
                this.currentNode = childNode;
                break;
            }
            tree.setSelected(this.currentNode);
            List<UIPublicationTree.TreeNode> listChildNode = this.currentNode.getTreeNodeChildren();
            tree.setChildren(listChildNode);
            tree.setParentSelected(null);
            tree.setSibbling(sibbling);
            return;
        }
        if (tree.getId().equals("UIPortalTree") && !uri.startsWith(this.currentNode.getUri())) {
            List sibbling = tree.getSibbling();
            for (UIPublicationTree.TreeNode childNode : sibbling) {
                if (!childNode.getUri().equals(uri)) continue;
                this.currentNode = childNode;
                break;
            }
            tree.setSelected(this.currentNode);
            List<UIPublicationTree.TreeNode> listChildNode = this.currentNode.getTreeNodeChildren();
            tree.setChildren(listChildNode);
            tree.setParentSelected(null);
            tree.setSibbling(sibbling);
        }
        if ((selected = this.currentNode.searchTreeNodeByURI(uri)) == null) {
            return;
        }
        String parentURI = StringUtils.substringBeforeLast((String)uri, (String)"/");
        UIPublicationTree.TreeNode parent = this.currentNode.searchTreeNodeByURI(parentURI);
        if (!selected.isPageNode()) {
            if (!tree.getId().equals("UIPortalTree")) {
                return;
            }
            ArrayList<UIPublicationTree.TreeNode> list = new ArrayList<UIPublicationTree.TreeNode>();
            for (String portal : this.runningPortals) {
                PageNavigation pageNavigation = this.getPortalNavigation(portal);
                UIPortalApplication portalApplication = Util.getUIPortalApplication();
                LocaleConfig localeConfig = ((LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class)).getLocaleConfig(portalApplication.getLocale().getLanguage());
                ResourceBundle res = localeConfig.getNavigationResourceBundle(pageNavigation.getOwnerType(), pageNavigation.getOwnerId());
                UIPublicationTree.TreeNode treeNode = new UIPublicationTree.TreeNode(portal, pageNavigation, res, false);
                if (pageNavigation.getNodes() != null) {
                    treeNode.setChildrenByPageNodes(pageNavigation.getNodes());
                }
                list.add(treeNode);
            }
            tree.setSibbling(list);
            tree.setSelected(selected);
            List<UIPublicationTree.TreeNode> listChildNode = selected.getTreeNodeChildren();
            if (listChildNode == null) {
                tree.setChildren(null);
            }
            tree.setChildren(listChildNode);
            tree.setParentSelected(null);
            this.currentNode = selected;
            return;
        }
        if (parent.isPageNode()) {
            tree.setSelected(selected);
            tree.setChildren(selected.getTreeNodeChildren());
            tree.setParentSelected(parent);
            List<UIPublicationTree.TreeNode> sibling = parent.getTreeNodeChildren();
            if (sibling != null) {
                tree.setSibbling(sibling);
            }
            this.currentNode = selected;
        } else if (!parent.isPageNode()) {
            tree.setSelected(selected);
            tree.setChildren(selected.getTreeNodeChildren());
            this.currentNode = selected;
            tree.setParentSelected(parent);
            List<UIPublicationTree.TreeNode> sibbling = parent.getTreeNodeChildren();
            if (sibbling != null) {
                tree.setSibbling(sibbling);
            }
        }
    }

    public UIPublicationTree.TreeNode getSelectedNode() {
        return this.currentNode;
    }

    public void setSelectedNode(UIPublicationTree.TreeNode selectedNode) {
        this.currentNode = selectedNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeNodeActionListener
    extends EventListener<UIPortalNavigationExplorer> {
        public void execute(Event<UIPortalNavigationExplorer> event) throws Exception {
            String uri = event.getRequestContext().getRequestParameter("objectId");
            UIPortalNavigationExplorer portalNavigationExplorer = (UIPortalNavigationExplorer)((Object)event.getSource());
            portalNavigationExplorer.selectTreeNodeByUri(uri);
            UIPublicationContainer publicationContainer = (UIPublicationContainer)portalNavigationExplorer.getAncestorOfType(UIPublicationContainer.class);
            UIPublicationPagesContainer publicationPagesContainer = (UIPublicationPagesContainer)portalNavigationExplorer.getAncestorOfType(UIPublicationPagesContainer.class);
            publicationContainer.setActiveTab((UIComponent)publicationPagesContainer, event.getRequestContext());
        }
    }
}

