/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core.impl;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;

public class WCMServiceImpl
implements WCMService {
    public Node getReferencedContent(SessionProvider sessionProvider, String repository, String workspace, String nodeIdentifier) throws Exception {
        if (repository == null || workspace == null || nodeIdentifier == null) {
            throw new ItemNotFoundException();
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        Node content = null;
        try {
            content = session.getNodeByUUID(nodeIdentifier);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            try {
                content = (Node)session.getItem(nodeIdentifier);
            }
            catch (Exception exception) {
                content = null;
            }
        }
        return content;
    }

    public boolean isSharedPortal(SessionProvider sessionProvider, String portalName) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)container.getComponentInstanceOfType(LivePortalManagerService.class);
        boolean isShared = false;
        Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
        isShared = sharedPortal.getName().equals(portalName);
        return isShared;
    }
}

