/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.webcontent;

import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalPlugin;
import org.exoplatform.services.wcm.webcontent.LinkDeploymentDescriptor;

public class InitialSymlinkPlugin
extends CreatePortalPlugin {
    private InitParams initParams;
    private RepositoryService repositoryService;
    private LinkManager linkManager;
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public InitialSymlinkPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService, LinkManager linkManager) {
        super(initParams, configurationManager, repositoryService);
        this.initParams = initParams;
        this.repositoryService = repositoryService;
        this.linkManager = linkManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployToPortal(SessionProvider sessionProvider, String portalName) throws Exception {
        ValueParam portalValue = this.initParams.getValueParam("portal");
        if (portalValue == null || portalValue != null && !portalName.equals(portalValue.getValue())) {
            return;
        }
        Iterator iterator = this.initParams.getObjectParamIterator();
        while (iterator.hasNext()) {
            ObjectParameter objectParameter = (ObjectParameter)iterator.next();
            LinkDeploymentDescriptor deploymentDescriptor = (LinkDeploymentDescriptor)objectParameter.getObject();
            String sourcePath = deploymentDescriptor.getSourcePath();
            String targetPath = deploymentDescriptor.getTargetPath();
            String[] src = sourcePath.split(":");
            String[] tgt = targetPath.split(":");
            if (src.length != 3 || tgt.length != 3) continue;
            ManageableRepository repository = this.repositoryService.getRepository(src[0]);
            Session session = sessionProvider.getSession(src[1], repository);
            ManageableRepository repository2 = this.repositoryService.getRepository(tgt[0]);
            Session session2 = sessionProvider.getSession(tgt[1], repository2);
            try {
                Node nodeSrc = session.getRootNode().getNode(src[2].substring(1));
                Node nodeTgt = session2.getRootNode().getNode(tgt[2].substring(1));
                this.linkManager.createLink(nodeTgt, "exo:taxonomyLink", nodeSrc);
                this.log.info((Object)(sourcePath + " has a link into " + targetPath));
            }
            finally {
                session.logout();
                session2.logout();
            }
        }
    }
}

