/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal.artifacts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalArtifactsService;
import org.exoplatform.services.wcm.portal.artifacts.CreatePortalPlugin;

public class CreatePortalArtifactsServiceImpl
implements CreatePortalArtifactsService {
    public static final String CREATE_PORTAL_EVENT = "PortalArtifactsInitializerServiceImpl.portal.onCreate";
    private List<CreatePortalPlugin> artifactPlugins = new ArrayList<CreatePortalPlugin>();
    private ListenerService listenerService;

    public CreatePortalArtifactsServiceImpl(ListenerService listenerService) {
        this.listenerService = listenerService;
    }

    public void addPlugin(CreatePortalPlugin artifactsPlugin) throws Exception {
        this.artifactPlugins.add(artifactsPlugin);
        Collections.sort(this.artifactPlugins, new Comparator<CreatePortalPlugin>(){

            @Override
            public int compare(CreatePortalPlugin plugin1, CreatePortalPlugin plugin2) {
                return plugin1.getPriority() - plugin2.getPriority();
            }
        });
    }

    public void deployArtifactsToPortal(SessionProvider sessionProvider, String portalName) throws Exception {
        for (CreatePortalPlugin plugin : this.artifactPlugins) {
            plugin.deployToPortal(sessionProvider, portalName);
        }
        this.listenerService.broadcast(CREATE_PORTAL_EVENT, (Object)portalName, (Object)sessionProvider);
    }
}

