/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.classify.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.jcr.ext.classify.NodeClassifyPlugin;

public class DateTimeClassifyPlugin
extends NodeClassifyPlugin {
    private static final int MONTHS = 12;
    private String templateDateTime;
    private String propertyDateTime;
    private Calendar startDateTime;
    private Calendar endDateTime;
    private int increment;
    private char incrementType;

    public DateTimeClassifyPlugin(InitParams initParams) {
        try {
            PropertiesParam propertiesParam = initParams.getPropertiesParam("plugin-params");
            String templDateTimeParam = propertiesParam.getProperty("DateTimeTemplate");
            String startDateTimeParam = propertiesParam.getProperty("StartTime");
            String endDateTimeParam = propertiesParam.getProperty("EndTime");
            this.propertyDateTime = propertiesParam.getProperty("DateTimePropertyName");
            if ("".equals(this.propertyDateTime)) {
                this.propertyDateTime = "exo:dateCreated";
            }
            this.templateDateTime = this.getWellTemplDateTime(templDateTimeParam);
            this.startDateTime = this.getCalendar(startDateTimeParam);
            this.endDateTime = this.getCalendar(endDateTimeParam);
            this.setIncrement();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void classifyChildrenNode(Node parent) throws Exception {
        Session session = parent.getSession();
        NodeIterator nodes = parent.getNodes();
        while (nodes.hasNext()) {
            Node node = nodes.nextNode();
            Calendar calNode = node.getProperty(this.propertyDateTime).getDate();
            if (calNode.before(this.startDateTime) || calNode.after(this.endDateTime)) continue;
            Node currentNode = this.createNewDateTimeNode(parent, this.getDateTimeStructured(this.templateDateTime, calNode));
            String srcPath = node.getPath();
            String destPath = currentNode.getPath() + "/" + node.getName();
            session.move(srcPath, destPath);
            session.save();
        }
    }

    private String getDateTimeStructured(String templDateTime, Calendar calendar) {
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int woy = calendar.get(3);
        int wom = calendar.get(4);
        int dom = calendar.get(5);
        int dow = calendar.get(7);
        int startYear = this.startDateTime.get(1);
        int startMonth = this.startDateTime.get(2);
        switch (this.incrementType) {
            case 'Y': {
                int n = (year - startYear) / (this.increment + 1);
                year = n * (this.increment + 1) + startYear;
                break;
            }
            case 'M': {
                if (year != startYear) {
                    startMonth = 1;
                }
                int m = (month - startMonth) / (this.increment + 1);
                month = m * (this.increment + 1) + startMonth;
                break;
            }
        }
        templDateTime = templDateTime.replace("YYYY", Integer.toString(year)).replace("MM", Integer.toString(month)).replace("WW", Integer.toString(woy)).replace("ww", Integer.toString(wom)).replace("DD", Integer.toString(dom)).replace("dd", Integer.toString(dow));
        String expr = templDateTime.substring(templDateTime.indexOf("{") + 1, templDateTime.indexOf("}"));
        templDateTime = templDateTime.replace(expr, this.operateExpression(expr)).replace("#", "").replace("{", "").replace("}", "");
        return templDateTime;
    }

    private String operateExpression(String expression) {
        String[] items = StringUtils.split((String)expression, (String)"+");
        int rel = Integer.parseInt(items[0]) + Integer.parseInt(items[1]);
        int endTime = this.endDateTime.get(1);
        if (this.incrementType == 'Y' && rel > endTime) {
            rel = endTime;
        } else if (this.incrementType == 'M' && rel > 12) {
            rel = 12;
        }
        String result = Integer.toString(rel);
        return result;
    }

    private Node createNewDateTimeNode(Node parentNode, String path) throws Exception {
        String[] items = path.split("/");
        Node currNode = null;
        for (int i = 0; i < items.length; ++i) {
            try {
                currNode = parentNode.getNode(items[i]);
            }
            catch (Exception e) {
                currNode = parentNode.addNode(items[i]);
            }
            parentNode = currNode;
        }
        return currNode;
    }

    private String getWellTemplDateTime(String templ) {
        String[] items;
        templ = templ.replace(" ", "");
        ArrayList<String> temp = new ArrayList<String>();
        for (String item : items = templ.split("/")) {
            if (item.contains("-")) {
                String[] subItems;
                if (item.contains("#")) {
                    String subStr = item.substring(item.indexOf("+") + 1, item.indexOf("}"));
                    try {
                        Integer.parseInt(subStr);
                        item = item.replace("+", "").replace(subStr, "");
                        if ("YYYY-#{YYYY}".equals(item) || "MM-#{MM}".equals(item)) continue;
                        templ = "";
                    }
                    catch (Exception e) {
                        templ = "";
                    }
                    break;
                }
                for (String subItem : subItems = item.split("-")) {
                    temp.add(subItem);
                }
                continue;
            }
            if (this.isValidField(item)) continue;
            templ = "";
            break;
        }
        return templ;
    }

    private boolean isValidField(String field) {
        return "YYYY".equals(field) || "MM".equals(field) || "WW".equals(field.toUpperCase()) || "DD".equals(field.toUpperCase());
    }

    private Calendar getCalendar(String datetime) {
        Calendar calendar = new GregorianCalendar();
        try {
            calendar = ISO8601.parse((String)datetime);
            return calendar;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void setIncrement() {
        String subStr = this.templateDateTime.substring(this.templateDateTime.indexOf("+") + 1, this.templateDateTime.indexOf("}"));
        this.increment = Integer.parseInt(subStr);
        this.incrementType = this.templateDateTime.charAt(this.templateDateTime.indexOf("{") + 1);
    }
}

