/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.category;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.impl.ActionConfig;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyAlreadyExistsException;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.wcm.portal.artifacts.BasePortalArtifactsPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialTaxonomyPlugin
extends BasePortalArtifactsPlugin {
    private String workspace = "";
    private String path = "";
    private String treeName = "";
    private List<TaxonomyConfig.Permission> permissions = new ArrayList<TaxonomyConfig.Permission>(4);
    private boolean autoCreateInNewRepository_ = true;
    private RepositoryService repositoryService_;
    private TaxonomyService taxonomyService_;
    private String baseTaxonomiesStorage_;
    private ActionServiceContainer actionServiceContainer_;
    private InitParams params_;
    private DMSConfiguration dmsConfiguration_;
    private String portalName;
    private String name;

    public InitialTaxonomyPlugin(InitParams params, ConfigurationManager configurationManager, RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, TaxonomyService taxonomyService, ActionServiceContainer actionServiceContainer, DMSConfiguration dmsConfiguration) throws Exception {
        super(params, configurationManager, repositoryService);
        this.repositoryService_ = repositoryService;
        this.baseTaxonomiesStorage_ = nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
        this.taxonomyService_ = taxonomyService;
        this.actionServiceContainer_ = actionServiceContainer;
        this.params_ = params;
        ValueParam autoCreated = this.params_.getValueParam("autoCreateInNewRepository");
        ValueParam workspaceParam = this.params_.getValueParam("workspace");
        ValueParam pathParam = this.params_.getValueParam("path");
        ValueParam nameParam = this.params_.getValueParam("treeName");
        if (autoCreated != null) {
            this.autoCreateInNewRepository_ = Boolean.parseBoolean(autoCreated.getValue());
        }
        if (pathParam == null || workspaceParam == null || workspaceParam.getValue().trim().length() == 0) {
            this.path = this.baseTaxonomiesStorage_;
        } else {
            this.path = pathParam.getValue();
            this.workspace = workspaceParam.getValue();
        }
        if (nameParam != null) {
            this.treeName = nameParam.getValue();
        }
        this.dmsConfiguration_ = dmsConfiguration;
    }

    @Override
    public void deployToPortal(String portalName, SessionProvider sessionProvider) throws Exception {
        this.portalName = portalName;
        String firstCharactor = portalName.substring(0, 1).toUpperCase();
        this.treeName = StringUtils.replace((String)this.treeName, (String)"{treeName}", (String)(firstCharactor + portalName.substring(1, portalName.length())));
        this.path = StringUtils.replace((String)this.path, (String)"{portalName}", (String)portalName);
        this.init();
    }

    public void init() throws Exception {
        if (this.autoCreateInNewRepository_) {
            for (RepositoryEntry repositoryEntry : this.repositoryService_.getConfig().getRepositoryConfigurations()) {
                this.importPredefineTaxonomies(repositoryEntry.getName());
            }
            return;
        }
        ValueParam param = this.params_.getValueParam("repository");
        String repository = null;
        repository = param == null ? this.repositoryService_.getDefaultRepository().getConfiguration().getName() : param.getValue();
        this.importPredefineTaxonomies(repository);
    }

    public void init(String repository) throws Exception {
        if (!this.autoCreateInNewRepository_) {
            return;
        }
        this.importPredefineTaxonomies(repository);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<TaxonomyConfig.Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<TaxonomyConfig.Permission> permissions) {
        this.permissions = permissions;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    private void importPredefineTaxonomies(String repository) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig(repository);
        if ("".equals(this.workspace)) {
            this.workspace = dmsRepoConfig.getSystemWorkspace();
        }
        Session session = manageableRepository.getSystemSession(this.workspace);
        Node taxonomyStorageNode = (Node)session.getItem(this.path);
        Node taxonomyStorageNodeSystem = null;
        if (taxonomyStorageNode.hasProperty("exo:isImportedChildren")) {
            session.logout();
            return;
        }
        taxonomyStorageNode.setProperty("exo:isImportedChildren", true);
        Iterator it = this.params_.getObjectParamIterator();
        while (it.hasNext()) {
            TaxonomyConfig config;
            ObjectParameter objectParam = (ObjectParameter)it.next();
            if (objectParam.getName().equals("permission.configuration")) {
                taxonomyStorageNodeSystem = Utils.makePath((Node)taxonomyStorageNode, (String)this.treeName, (String)"exo:taxonomy", null);
                session.save();
                config = (TaxonomyConfig)objectParam.getObject();
                for (TaxonomyConfig.Taxonomy taxonomy : config.getTaxonomies()) {
                    Map<String, String[]> mapPermissions = this.getPermissions(taxonomy.getPermissions());
                    if (mapPermissions != null) {
                        ((ExtendedNode)taxonomyStorageNodeSystem).setPermissions(mapPermissions);
                    }
                    if (!taxonomyStorageNodeSystem.canAddMixin("mix:referenceable")) continue;
                    taxonomyStorageNodeSystem.addMixin("mix:referenceable");
                }
                continue;
            }
            if (objectParam.getName().equals("taxonomy.configuration")) {
                config = (TaxonomyConfig)objectParam.getObject();
                for (TaxonomyConfig.Taxonomy taxonomy : config.getTaxonomies()) {
                    Node taxonomyNode = Utils.makePath((Node)taxonomyStorageNodeSystem, (String)taxonomy.getPath(), (String)"exo:taxonomy", this.getPermissions(taxonomy.getPermissions()));
                    if (taxonomyNode.canAddMixin("mix:referenceable")) {
                        taxonomyNode.addMixin("mix:referenceable");
                    }
                    taxonomyNode.getSession().save();
                }
                continue;
            }
            if (!objectParam.getName().equals("predefined.actions")) continue;
            taxonomyStorageNodeSystem = Utils.makePath((Node)taxonomyStorageNode, (String)this.treeName, (String)"exo:taxonomy", null);
            session.save();
            config = (ActionConfig)objectParam.getObject();
            List actions = config.getActions();
            for (ActionConfig.TaxonomyAction action : actions) {
                String homePath = action.getHomePath();
                homePath = StringUtils.replace((String)homePath, (String)"{treeName}", (String)this.treeName);
                homePath = StringUtils.replace((String)homePath, (String)"{portalName}", (String)this.portalName);
                action.setHomePath(homePath);
                action.setTargetPath(StringUtils.replace((String)action.getTargetPath(), (String)"{portalName}", (String)this.portalName));
                this.addAction(action, taxonomyStorageNodeSystem, repository);
            }
        }
        taxonomyStorageNode.save();
        try {
            this.taxonomyService_.addTaxonomyTree(taxonomyStorageNodeSystem);
        }
        catch (TaxonomyAlreadyExistsException e) {
            e.printStackTrace();
        }
        session.save();
        session.logout();
    }

    private void addAction(ActionConfig.TaxonomyAction action, Node srcNode, String repository) throws Exception {
        HashMap<String, JcrInputProperty> sortedInputs = new HashMap<String, JcrInputProperty>();
        JcrInputProperty jcrInputName = new JcrInputProperty();
        jcrInputName.setJcrPath("/node/exo:name");
        jcrInputName.setValue((Object)action.getName());
        sortedInputs.put("/node/exo:name", jcrInputName);
        JcrInputProperty jcrInputDes = new JcrInputProperty();
        jcrInputDes.setJcrPath("/node/exo:description");
        jcrInputDes.setValue((Object)action.getDescription());
        sortedInputs.put("/node/exo:description", jcrInputDes);
        JcrInputProperty jcrInputLife = new JcrInputProperty();
        jcrInputLife.setJcrPath("/node/exo:lifecyclePhase");
        jcrInputLife.setValue((Object)action.getLifecyclePhase());
        sortedInputs.put("/node/exo:lifecyclePhase", jcrInputLife);
        JcrInputProperty jcrInputHomePath = new JcrInputProperty();
        jcrInputHomePath.setJcrPath("/node/exo:storeHomePath");
        jcrInputHomePath.setValue((Object)action.getHomePath());
        sortedInputs.put("/node/exo:storeHomePath", jcrInputHomePath);
        JcrInputProperty jcrInputTargetWspace = new JcrInputProperty();
        jcrInputTargetWspace.setJcrPath("/node/exo:targetWorkspace");
        jcrInputTargetWspace.setValue((Object)action.getTargetWspace());
        sortedInputs.put("/node/exo:targetWorkspace", jcrInputTargetWspace);
        JcrInputProperty jcrInputTargetPath = new JcrInputProperty();
        jcrInputTargetPath.setJcrPath("/node/exo:targetPath");
        jcrInputTargetPath.setValue((Object)action.getTargetPath());
        sortedInputs.put("/node/exo:targetPath", jcrInputTargetPath);
        JcrInputProperty rootProp = (JcrInputProperty)sortedInputs.get("/node");
        if (rootProp == null) {
            rootProp = new JcrInputProperty();
            rootProp.setJcrPath("/node");
            rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
            sortedInputs.put("/node", rootProp);
        } else {
            rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
        }
        this.actionServiceContainer_.addAction(srcNode, repository, action.getType(), sortedInputs);
        Node actionNode = this.actionServiceContainer_.getAction(srcNode, action.getName());
        if (action.getRoles() != null) {
            String[] roles = StringUtils.split((String)action.getRoles(), (String)";");
            actionNode.setProperty("exo:roles", roles);
        }
        for (ActionConfig.Mixin mixin : action.getMixins()) {
            actionNode.addMixin(mixin.getName());
            Map props = mixin.getParsedProperties();
            Set keys = props.keySet();
            for (String key : keys) {
                actionNode.setProperty(key, (String)props.get(key));
            }
        }
        actionNode.getSession().save();
    }

    private Map<String, String[]> getPermissions(List<TaxonomyConfig.Permission> listPermissions) {
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        for (TaxonomyConfig.Permission permission : listPermissions) {
            StringBuilder strPer = new StringBuilder();
            if ("true".equals(permission.getRead())) {
                strPer.append("read");
            }
            if ("true".equals(permission.getAddNode())) {
                strPer.append(",").append("add_node");
            }
            if ("true".equals(permission.getSetProperty())) {
                strPer.append(",").append("set_property");
            }
            if ("true".equals(permission.getRemove())) {
                strPer.append(",").append("remove");
            }
            permissionsMap.put(permission.getIdentity(), strPer.toString().split(","));
        }
        return permissionsMap;
    }
}

