/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.Arrays;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.UICategoryForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NameValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteModeratorActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectMemberActionListener.class}, phase=Event.Phase.DECODE)})
public class UICategoryForm
extends UIForm
implements UIPopupComponent,
UISelectable {
    private NewsletterCategoryConfig categoryConfig;
    private String popupId;
    public static final String INPUT_CATEGORY_NAME = "CategoryName";
    public static final String INPUT_CATEGORY_TITLE = "CategoryTitle";
    public static final String INPUT_CATEGORY_DESCRIPTION = "CategoryDescription";
    public static final String FORM_CATEGORY_MODERATOR = "FormCategoryModerator";
    public static final String INPUT_CATEGORY_MODERATOR = "CategoryModerator";

    public UICategoryForm() throws Exception {
        UIFormStringInput inputCateName = new UIFormStringInput(INPUT_CATEGORY_NAME, null, null);
        UIFormStringInput inputCateTitle = new UIFormStringInput(INPUT_CATEGORY_TITLE, null, null);
        this.getChildren().clear();
        UIFormTextAreaInput inputCateDescription = new UIFormTextAreaInput(INPUT_CATEGORY_DESCRIPTION, null, null);
        UIFormStringInput inputModerator = new UIFormStringInput(INPUT_CATEGORY_MODERATOR, INPUT_CATEGORY_MODERATOR, null);
        inputModerator.setEditable(false);
        UIFormInputSetWithAction formCategoryModerator = new UIFormInputSetWithAction(FORM_CATEGORY_MODERATOR);
        formCategoryModerator.addChild((UIComponent)inputModerator);
        formCategoryModerator.setActionInfo(INPUT_CATEGORY_MODERATOR, new String[]{"SelectUser", "SelectMember", "DeleteModerator"});
        formCategoryModerator.showActionInfo(true);
        inputCateName.addValidator(MandatoryValidator.class, new Object[0]).addValidator(NameValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]);
        inputCateTitle.addValidator(MandatoryValidator.class, new Object[0]);
        inputModerator.addValidator(MandatoryValidator.class, new Object[0]);
        this.addChild((UIComponent)inputCateName);
        this.addChild((UIComponent)inputCateTitle);
        this.addChild((UIComponent)inputCateDescription);
        this.addChild((UIComponent)formCategoryModerator);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String result;
        UIFormInputSetWithAction formCategoryModerator = (UIFormInputSetWithAction)this.getChildById(FORM_CATEGORY_MODERATOR);
        UIFormStringInput stringInput = (UIFormStringInput)formCategoryModerator.getChildById(selectField);
        ArrayList<String> values = new ArrayList<String>();
        String oldValue = (String)stringInput.getValue();
        if (oldValue != null && oldValue.length() > 0) {
            values.addAll(Arrays.asList(oldValue.split(",")));
        }
        if (!values.contains(result = (String)value)) {
            values.add(result);
        }
        result = "";
        for (String str : values) {
            if (result.trim().length() > 0) {
                result = result + ",";
            }
            result = result + str;
        }
        stringInput.setValue((Object)result);
        Utils.closePopupWindow((UIContainer)this, (String)this.popupId);
    }

    public String getPopupId() {
        return this.popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void setCategoryInfo(NewsletterCategoryConfig categoryConfig) {
        this.categoryConfig = categoryConfig;
        UIFormStringInput inputCateName = (UIFormStringInput)this.getChildById(INPUT_CATEGORY_NAME);
        inputCateName.setValue((Object)categoryConfig.getName());
        inputCateName.setEditable(false);
        UIFormStringInput inputCateTitle = (UIFormStringInput)this.getChildById(INPUT_CATEGORY_TITLE);
        inputCateTitle.setValue((Object)categoryConfig.getTitle());
        UIFormTextAreaInput inputCateDescription = (UIFormTextAreaInput)this.getChildById(INPUT_CATEGORY_DESCRIPTION);
        inputCateDescription.setValue((Object)categoryConfig.getDescription());
        UIFormInputSetWithAction inputSetWithAction = (UIFormInputSetWithAction)this.getChildById(FORM_CATEGORY_MODERATOR);
        UIFormStringInput inputModerator = (UIFormStringInput)inputSetWithAction.getChildById(INPUT_CATEGORY_MODERATOR);
        inputModerator.setValue((Object)categoryConfig.getModerator());
    }

    static /* synthetic */ NewsletterCategoryConfig access$000(UICategoryForm x0) {
        return x0.categoryConfig;
    }
}

