/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.newsletter.manager.NewsLetterUtil;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryContainer;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryDialogSelector;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryForm;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterEntryManager;
import org.exoplatform.wcm.webui.newsletter.manager.UINewsletterManagerPortlet;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SendActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UINewsletterEntryForm
extends UIDialogForm {
    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            return templateService.getTemplatePathByUser(true, "exo:webContent", userName, this.repositoryName);
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UINewsletterEntryForm.msg.get-template", null, (int)0);
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            if (this.resourceResolver == null) {
                DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
                String workspace = dmsConfiguration.getConfig(this.repositoryName).getSystemWorkspace();
                this.resourceResolver = new JCRResourceResolver(this.repositoryName, workspace, TemplateService.EXO_TEMPLATE_FILE_PROP);
            }
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UINewsletterEntryForm.msg.get-template-resource", null, (int)0);
        }
        return this.resourceResolver;
    }

    private Node saveContent(boolean isSend) throws Exception {
        boolean isNull = true;
        UINewsletterEntryContainer newsletterEntryContainer = (UINewsletterEntryContainer)this.getAncestorOfType(UINewsletterEntryContainer.class);
        UINewsletterEntryDialogSelector newsletterEntryDialogSelector = (UINewsletterEntryDialogSelector)newsletterEntryContainer.getChild(UINewsletterEntryDialogSelector.class);
        String selectedCategory = (String)((UIFormSelectBox)newsletterEntryDialogSelector.getChildById("UINewsletterEntryCategorySelectBox")).getValue();
        String selectedSubsctiption = (String)((UIFormSelectBox)newsletterEntryDialogSelector.getChildById("UINewsletterEntrySubscriptionSelectBox")).getValue();
        this.setStoredPath(NewsletterConstant.generateSubscriptionPath((String)Util.getUIPortal().getName(), (String)selectedCategory, (String)selectedSubsctiption));
        Map inputProperties = DialogFormUtil.prepareMap((List)this.getChildren(), (Map)this.getInputProperties());
        if (this.isAddNew()) {
            String nodeName = Utils.cleanString((String)((String)this.getUIStringInput("title").getValue()));
            ((JcrInputProperty)inputProperties.get("/node")).setValue((Object)nodeName);
        }
        String storedPath = this.getStoredPath().replace("portalName", NewsLetterUtil.getPortalName());
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(this.repositoryName);
        Session session = Utils.getSessionProvider().getSession(this.workspaceName, manageableRepository);
        Node storedNode = (Node)session.getItem(storedPath);
        CmsService cmsService = (CmsService)this.getApplicationComponent(CmsService.class);
        String newsletterNodePath = cmsService.storeNode("exo:webContent", storedNode, inputProperties, this.isAddNew(), this.repositoryName);
        Node newsletterNode = (Node)session.getItem(newsletterNodePath);
        if (this.isAddNew() && newsletterNode.canAddMixin("exo:newsletterEntry")) {
            newsletterNode.addMixin("exo:newsletterEntry");
        }
        newsletterNode.setProperty("exo:newsletterEntryCategoryName", selectedCategory);
        newsletterNode.setProperty("exo:newsletterEntrySubscriptionName", selectedSubsctiption);
        newsletterNode.setProperty("exo:newsletterEntryType", newsletterEntryDialogSelector.getDialog());
        Calendar calendar = ((UIFormDateTimeInput)newsletterEntryDialogSelector.getChildById("UINewsletterEntrySendDate")).getCalendar();
        if (calendar == null) {
            calendar = Calendar.getInstance();
        }
        newsletterNode.setProperty("exo:newsletterEntryDate", calendar);
        Date currentDate = new Date();
        if (isSend) {
            if (calendar.getTimeInMillis() >= currentDate.getTime()) {
                newsletterNode.setProperty("exo:newsletterEntryStatus", "awaiting");
                isNull = true;
            } else {
                isNull = false;
                newsletterNode.setProperty("exo:newsletterEntryStatus", "sent");
            }
        } else {
            newsletterNode.setProperty("exo:newsletterEntryStatus", "draft");
        }
        session.save();
        UINewsletterManagerPortlet managerPortlet = (UINewsletterManagerPortlet)this.getAncestorOfType(UINewsletterManagerPortlet.class);
        UINewsletterEntryManager entryManager = (UINewsletterEntryManager)managerPortlet.getChild(UINewsletterEntryManager.class);
        if (entryManager.isRendered()) {
            entryManager.init();
        }
        Utils.closePopupWindow((UIContainer)this, (String)"UINewsletterEntryFormPopupWindow");
        if (isNull) {
            return null;
        }
        return newsletterNode;
    }

    static /* synthetic */ Node access$000(UINewsletterEntryForm x0, boolean x1) throws Exception {
        return x0.saveContent(x1);
    }
}

