/*
 * Copyright (C) 2003-2009 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;

/**
 * The Class NewsLetterUtil.
 */
public class NewsLetterUtil {
  /**
   * Get all group and membership of current user
   * @return
   * @throws Exception
   */
  public static List<String> getAllGroupAndMembershipOfCurrentUser() throws Exception{
    String userId = getCurrentUser();
    OrganizationService oservice = (OrganizationService)
    ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
    List<String> userMemberships = new ArrayList<String> ();
    userMemberships.add(userId);
    Collection<?> memberships = oservice.getMembershipHandler().findMembershipsByUser(userId);
    if(memberships == null || memberships.size() < 0) return userMemberships;
    Object[] objects = memberships.toArray();
    for(int i = 0; i < objects.length; i ++ ){
      Membership membership = (Membership)objects[i];
      String role = membership.getMembershipType() + ":" + membership.getGroupId();
      userMemberships.add(role);     
    }
    return userMemberships;
  }
  
	/**
	 * Gets the portal name.
	 * 
	 * @return the portal name
	 */
	public static String getPortalName() {
	  return Util.getUIPortalApplication().getOwner();
	}
	
	/**
	 * Generate link.
	 * 
	 * @param url the url
	 * 
	 * @return the string
	 */
	public static String generateLink(String url) throws Exception {
    String link = url.replaceFirst("Subcribe", "ConfirmUserCode")
                      .replaceFirst("UINewsletterViewerForm", "UINewsletterViewerPortlet")
                      .replaceAll("&amp;", "&");
    String selectedNode = Util.getUIPortal().getSelectedNode().getUri() ;
    String portalName = "/" + getPortalName() ;
    if(link.indexOf(portalName) > 0) {
      if(link.indexOf(portalName + "/" + selectedNode) < 0){
        link = link.replaceFirst(portalName, portalName + "/" + selectedNode) ;
      }                 
    } 
    PortalRequestContext portalContext = Util.getPortalRequestContext();
    url = portalContext.getRequest().getRequestURL().toString();
    url = url.replaceFirst("http://", "") ;
    url = url.substring(0, url.indexOf("/")) ;
    link = "http://" + url + link;
    return link.replaceFirst("private", "public");
	}
	
	/**
	 * Get current user
	 * @return
	 * @throws Exception
	 */
	static public String getCurrentUser() throws Exception {
    return Util.getPortalRequestContext().getRemoteUser();
  }
	
	/**
	 * Check permission of current user with category.
	 * @param categoryConfig   The category which you want check
	 * @return                 <code>True</code> if current user is moderator of the category and <code>False</code> if not
	 * @throws Exception       The Exception
	 */
  public static boolean isModeratorOfCategory(NewsletterCategoryConfig categoryConfig) throws Exception{
    List<String> listModerators = Arrays.asList(categoryConfig.getModerator().split(","));
    if(listModerators.contains("any")) return true;
    else{
      for(String str : getAllGroupAndMembershipOfCurrentUser()){
        if(listModerators.contains(str)){
          return true;
        }
      }
    }
    return false;
  }
}
