/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter;

import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class NoneHTMLValidator
implements Validator {
    private String fullHtmltag = ".*<.*>.*</.*>.*";
    private String startHtmlTag = ".*<.*>.*";
    private String finishHtmlTag = ".*</.*>.*";

    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        String input;
        if (!(uiInput.getValue() == null || (input = ((String)uiInput.getValue()).trim()).length() <= 0 || input.matches(this.fullHtmltag) || input.matches(this.startHtmlTag) || input.matches(this.finishHtmlTag))) {
            return;
        }
        UIComponent uiComponent = (UIComponent)uiInput;
        UIForm uiForm = (UIForm)uiComponent.getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getLabel(uiInput.getName());
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        label = label.trim();
        if (label.charAt(label.length() - 1) == ':') {
            label = label.substring(0, label.length() - 1);
        }
        Object[] args = new Object[]{label, uiInput.getBindingField()};
        throw new MessageException(new ApplicationMessage("NoneHTMLValidator.msg.invalid", args, 1));
    }
}

