/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.newsletter.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class NewsLetterUtil {
    public static List<String> getAllGroupAndMembershipOfCurrentUser() throws Exception {
        String userId = NewsLetterUtil.getCurrentUser();
        OrganizationService oservice = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection memberships = oservice.getMembershipHandler().findMembershipsByUser(userId);
        if (memberships == null || memberships.size() < 0) {
            return userMemberships;
        }
        Object[] objects = memberships.toArray();
        for (int i = 0; i < objects.length; ++i) {
            Membership membership = (Membership)objects[i];
            String role = membership.getMembershipType() + ":" + membership.getGroupId();
            userMemberships.add(role);
        }
        return userMemberships;
    }

    public static String getPortalName() {
        return Util.getUIPortalApplication().getOwner();
    }

    public static String generateLink(String url) throws Exception {
        String link = url.replaceFirst("Subcribe", "ConfirmUserCode").replaceFirst("UINewsletterViewerForm", "UINewsletterViewerPortlet").replaceAll("&amp;", "&");
        String selectedNode = Util.getUIPortal().getSelectedNode().getUri();
        String portalName = "/" + NewsLetterUtil.getPortalName();
        if (link.indexOf(portalName) > 0 && link.indexOf(portalName + "/" + selectedNode) < 0) {
            link = link.replaceFirst(portalName, portalName + "/" + selectedNode);
        }
        PortalRequestContext portalContext = Util.getPortalRequestContext();
        url = portalContext.getRequest().getRequestURL().toString();
        url = url.replaceFirst("http://", "");
        url = url.substring(0, url.indexOf("/"));
        link = "http://" + url + link;
        return link.replaceFirst("private", "public");
    }

    public static String getCurrentUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static boolean isModeratorOfCategory(NewsletterCategoryConfig categoryConfig) throws Exception {
        List<String> listModerators = Arrays.asList(categoryConfig.getModerator().split(","));
        if (listModerators.contains("any")) {
            return true;
        }
        for (String str : NewsLetterUtil.getAllGroupAndMembershipOfCurrentUser()) {
            if (!listModerators.contains(str)) continue;
            return true;
        }
        return false;
    }
}

