/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVContainer;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ContentListViewer/UICLVManualMode.gtmpl", events={@EventConfig(listeners={UICLVContainer.QuickEditActionListener.class})})
public class UICLVManualMode
extends UICLVContainer {
    public void init() throws Exception {
        PortletPreferences portletPreferences = this.getPortletPreference();
        this.setViewAbleContent(true);
        String repositoryName = portletPreferences.getValue("repository", null);
        String workspaceName = portletPreferences.getValue("workspace", null);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository repository = repositoryService.getRepository(repositoryName);
        Session session = Utils.getSessionProvider((UIComponent)this).getSession(workspaceName, repository);
        Node root = session.getRootNode();
        String[] listContent = portletPreferences.getValues("contents", null);
        if (listContent == null || listContent.length == 0) {
            this.messageKey = "UIMessageBoard.msg.contents-not-found";
            this.setViewAbleContent(false);
            return;
        }
        List<String> contents = Arrays.asList(listContent);
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (contents != null && contents.size() != 0) {
            for (int i = 0; i < contents.size(); ++i) {
                String path = contents.get(i);
                try {
                    Node originalNode = root.getNode(path.substring(1, path.length()));
                    Node viewNode = Utils.getNodeView((Node)originalNode);
                    if (viewNode == null) continue;
                    nodes.add(viewNode);
                    continue;
                }
                catch (Exception e) {
                    Utils.createPopupMessage((UIContainer)this, (String)"UIMessageBoard.msg.add-node-error", null, (int)0);
                }
            }
        }
        if (nodes.size() == 0) {
            this.messageKey = "UIMessageBoard.msg.contents-not-found";
            this.setViewAbleContent(false);
            return;
        }
        this.getChildren().clear();
        ObjectPageList pageList = new ObjectPageList(nodes, itemsPerPage);
        String templatePath = this.getFormViewTemplatePath();
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        UICLVPresentation clvPresentation = (UICLVPresentation)this.addChild(UICLVPresentation.class, null, null);
        clvPresentation.init(templatePath, resourceResolver, (PageList)pageList);
        clvPresentation.setContentColumn(portletPreferences.getValue("header", null));
        clvPresentation.setShowLink(Boolean.parseBoolean(portletPreferences.getValue("showLink", null)));
        clvPresentation.setShowHeader(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        clvPresentation.setShowReadmore(Boolean.parseBoolean(portletPreferences.getValue("showReadmore", null)));
        clvPresentation.setHeader(portletPreferences.getValue("header", null));
    }
}

