/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import javax.jcr.Node;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.WebUIPropertiesConfigService;
import org.exoplatform.wcm.webui.scv.UIPresentation;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.config.UIPortletConfig;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UISingleContentViewerPortlet
extends UIPortletApplication {
    public static String REPOSITORY = "repository";
    public static String WORKSPACE = "workspace";
    public static String IDENTIFIER = "nodeIdentifier";
    private PortletMode mode = PortletMode.VIEW;

    public UISingleContentViewerPortlet() throws Exception {
        this.activateMode(this.mode);
    }

    public void activateMode(PortletMode mode) throws Exception {
        this.addChild(UIPopupContainer.class, null, null);
        if (PortletMode.VIEW.equals((Object)mode)) {
            if (this.getChild(UIPresentationContainer.class) == null) {
                this.addChild(UIPresentationContainer.class, null, null);
            }
        } else if (PortletMode.EDIT.equals((Object)mode)) {
            WebUIPropertiesConfigService propertiesConfigService = (WebUIPropertiesConfigService)this.getApplicationComponent(WebUIPropertiesConfigService.class);
            WebUIPropertiesConfigService.PopupWindowProperties popupProperties = (WebUIPropertiesConfigService.PopupWindowProperties)propertiesConfigService.getProperties(WebUIPropertiesConfigService.SCV_POPUP_SIZE_EDIT_PORTLET_MODE);
            UIPortletConfig portletConfig = (UIPortletConfig)this.createUIComponent(UIPortletConfig.class, null, null);
            Utils.createPopupWindow((UIContainer)this, (UIComponent)portletConfig, (String)"UIContentDialogFormPopupWindow", (int)popupProperties.getWidth(), (int)popupProperties.getHeight());
            portletConfig.init();
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext pContext = (PortletRequestContext)context;
        PortletMode newMode = pContext.getApplicationMode();
        if (!this.mode.equals((Object)newMode)) {
            this.activateMode(newMode);
            this.mode = newMode;
        }
        super.processRender(app, context);
    }

    public Node getNodeView() {
        try {
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
            String repository = preferences.getValue(REPOSITORY, null);
            String workspace = preferences.getValue(WORKSPACE, null);
            String nodeIdentifier = preferences.getValue(IDENTIFIER, null);
            WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
            Node originalNode = wcmService.getReferencedContent(Utils.getSessionProvider((UIComponent)this), repository, workspace, nodeIdentifier);
            Node viewNode = Utils.getNodeView((Node)originalNode);
            UIPresentation presentation = (UIPresentation)this.findFirstComponentOfType(UIPresentation.class);
            if (viewNode != null && viewNode.isNodeType("nt:frozenNode")) {
                String nodeUUID = viewNode.getProperty("jcr:frozenUuid").getString();
                presentation.setOriginalNode(viewNode.getSession().getNodeByUUID(nodeUUID));
                presentation.setNode(viewNode);
            } else {
                presentation.setOriginalNode(viewNode);
                presentation.setNode(viewNode);
            }
            return viewNode;
        }
        catch (Exception e) {
            return null;
        }
    }
}

