/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.util.Calendar;
import javax.jcr.Node;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.WebUIPropertiesConfigService;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.config.UIPortletConfig;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/SingleContentViewer/UISingleContentView.gtmpl")
public class UISingleContentViewerPortlet
extends UIPortletApplication {
    public static String REPOSITORY = "repository";
    public static String WORKSPACE = "workspace";
    public static String IDENTIFIER = "nodeIdentifier";
    private PortletMode mode = PortletMode.VIEW;

    public UISingleContentViewerPortlet() throws Exception {
        this.activateMode(this.mode);
    }

    public void activateMode(PortletMode mode) throws Exception {
        Calendar lCDateCalendar = Calendar.getInstance();
        this.addChild(UIPopupContainer.class, null, "UIPopupContainer-" + lCDateCalendar.getTimeInMillis());
        if (PortletMode.VIEW.equals((Object)mode)) {
            if (this.getChild(UIPresentationContainer.class) == null) {
                this.addChild(UIPresentationContainer.class, null, UIPortletApplication.VIEW_MODE + "-" + lCDateCalendar.getTimeInMillis());
            }
        } else if (PortletMode.EDIT.equals((Object)mode)) {
            WebUIPropertiesConfigService propertiesConfigService = (WebUIPropertiesConfigService)this.getApplicationComponent(WebUIPropertiesConfigService.class);
            WebUIPropertiesConfigService.PopupWindowProperties popupProperties = (WebUIPropertiesConfigService.PopupWindowProperties)propertiesConfigService.getProperties(WebUIPropertiesConfigService.SCV_POPUP_SIZE_EDIT_PORTLET_MODE);
            UIPortletConfig portletConfig = (UIPortletConfig)this.createUIComponent(UIPortletConfig.class, null, null);
            Utils.createPopupWindow((UIContainer)this, (UIComponent)portletConfig, (String)"UIContentDialogFormPopupWindow", (int)popupProperties.getWidth(), (int)popupProperties.getHeight());
            portletConfig.init();
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        PortletRequestContext pContext = (PortletRequestContext)context;
        PortletMode newMode = pContext.getApplicationMode();
        if (!this.mode.equals((Object)newMode)) {
            this.activateMode(newMode);
            this.mode = newMode;
        }
        super.processRender(app, context);
    }

    public Node getNodeByPreference() {
        try {
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
            String repository = preferences.getValue(REPOSITORY, null);
            String workspace = preferences.getValue(WORKSPACE, null);
            String nodeIdentifier = preferences.getValue(IDENTIFIER, null);
            WCMService wcmService = (WCMService)this.getApplicationComponent(WCMService.class);
            return wcmService.getReferencedContent(Utils.getSessionProvider(), repository, workspace, nodeIdentifier);
        }
        catch (Exception e) {
            return null;
        }
    }
}

