/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVContainer;
import org.exoplatform.wcm.webui.clv.UICLVPortlet;
import org.exoplatform.wcm.webui.clv.config.UICLVConfig;
import org.exoplatform.wcm.webui.selector.UISourceGridUpdatable;
import org.exoplatform.wcm.webui.validator.ZeroNumberValidator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.ext.UIFormInputSetWithAction;
import org.exoplatform.webui.form.validator.PositiveNumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/ContentListViewer/config/UICLVConfig.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectFolderPathActionListener.class}), @EventConfig(listeners={IncreaseActionListener.class}), @EventConfig(listeners={DecreaseActionListener.class}), @EventConfig(listeners={SelectBasePathActionListener.class}), @EventConfig(listeners={DeleteActionListener.class})})
public class UICLVConfig
extends UIForm
implements UISelectable,
UISourceGridUpdatable {
    private List<String> contentList = new ArrayList();
    private List<String> oldContentList = new ArrayList();
    public static final String HEADER = "Header";
    public static final String PORTLET_NAME = "Content List Viewer";
    public static final String FORM_VIEW_TEMPLATE_CATEGORY = "list-by-folder";
    public static final String PAGINATOR_TEMPLATE_CATEGORY = "paginators";
    public static final String FOLDER_PATH_INPUTSET = "FolderPathInputSet";
    public static final String FOLDER_PATH_INPUT = "FolderPathInput";
    public static final String FORM_VIEW_TEMPLATES_SELECTOR = "FormViewTemplate";
    public static final String PAGINATOR_TEMPLATES_SELECTOR = "PaginatorTemplate";
    public static final String ITEMS_PER_PAGE_INPUT = "ItemsPerPage";
    public static final String VIEWER_BUTTON_REFRESH = "ViewerButtonRefresh";
    public static final String VIEWER_READMORE = "ViewerReadmore";
    public static final String VIEWER_THUMBNAILS_IMAGE = "ViewerThumbnailsView";
    public static final String VIEWER_TITLE = "ViewerTitle";
    public static final String VIEWER_DATE_CREATED = "ViewerDateCreated";
    public static final String VIEWER_SUMMARY = "ViewerSummary";
    public static final String VIEWER_HEADER = "ViewerHeader";
    public static final String VIEWER_LINK = "ViewerLink";
    public static final String VIEWER_MODES = "ViewerMode";
    public static final String VIEWER_MANUAL_MODE = "ManualViewerMode";
    public static final String VIEWER_AUTO_MODE = "AutoViewerMode";
    public static final String ORDER_BY = "OrderBy";
    public static final String ORDER_BY_TITLE = "OrderByTitle";
    public static final String ORDER_BY_DATE_CREATED = "OrderByDateCreated";
    public static final String ORDER_BY_DATE_MODIFIED = "OrderByDateModified";
    public static final String ORDER_BY_DATE_PUBLISHED = "OrderByDatePublished";
    public static final String ORDER_TYPES = "OrderTypes";
    public static final String ORDER_DESC = "OrderDesc";
    public static final String ORDER_ASC = "OrderAsc";
    public static final int popupWidth = 700;
    public static final String FOLDER_PATH_SELECTOR_POPUP_WINDOW = "FolderPathSelectorPopupWindow";
    public static final String CORRECT_CONTENT_SELECTOR_POPUP_WINDOW = "CorrectContentSelectorPopupWindow";
    public static final String BASE_PATH_INPUT = "UICLVBasePathInput";
    public static final String BASE_PATH_SELECTOR_POPUP_WINDOW = "UICLVBasePathPopupWindow";
    public static final String BASE_PATH_INPUT_SET_ACTION = "UICLVBasePathInputSetAction";
    private String popupId;

    public String getPopupId() {
        return this.popupId;
    }

    public void setPopupId(String popupId) {
        this.popupId = popupId;
    }

    public UICLVConfig() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = context.getRequest().getPreferences();
        String folderPath = portletPreferences.getValue("folderPath", "folderPath");
        UIFormStringInput headerInput = new UIFormStringInput("Header", "Header", null);
        String headerValue = portletPreferences.getValue("header", null);
        headerInput.setValue((Object)headerValue);
        List formViewerTemplateList = this.getTemplateList("Content List Viewer", "list-by-folder");
        List paginatorTemplateList = this.getTemplateList("Content List Viewer", "paginators");
        ArrayList<SelectItemOption> viewerModeOptions = new ArrayList<SelectItemOption>();
        viewerModeOptions.add(new SelectItemOption("AutoViewerMode", (Object)"AutoViewerMode"));
        viewerModeOptions.add(new SelectItemOption("ManualViewerMode", (Object)"ManualViewerMode"));
        ArrayList<SelectItemOption> orderTypeOptions = new ArrayList<SelectItemOption>();
        orderTypeOptions.add(new SelectItemOption("OrderDesc", (Object)"DESC"));
        orderTypeOptions.add(new SelectItemOption("OrderAsc", (Object)"ASC"));
        UIFormRadioBoxInput orderTypeRadioBoxInput = new UIFormRadioBoxInput("OrderTypes", "OrderTypes", orderTypeOptions);
        String orderTypePref = portletPreferences.getValue("orderType", null);
        if (orderTypePref == null) {
            orderTypeRadioBoxInput.setValue((Object)"DESC");
        } else {
            orderTypeRadioBoxInput.setValue((Object)orderTypePref);
        }
        ArrayList<SelectItemOption> orderByOptions = new ArrayList<SelectItemOption>();
        orderByOptions.add(new SelectItemOption("OrderByTitle", (Object)"exo:title"));
        orderByOptions.add(new SelectItemOption("OrderByDateCreated", (Object)"exo:dateCreated"));
        orderByOptions.add(new SelectItemOption("OrderByDateModified", (Object)"exo:dateModified"));
        orderByOptions.add(new SelectItemOption("OrderByDatePublished", (Object)"publication:liveDate"));
        UIFormRadioBoxInput viewerModeRadioBoxInput = new UIFormRadioBoxInput("ViewerMode", "ViewerMode", viewerModeOptions);
        UIFormSelectBox orderBySelectBox = new UIFormSelectBox("OrderBy", "OrderBy", orderByOptions);
        String orderByPref = portletPreferences.getValue("orderBy", null);
        orderBySelectBox.setValue(orderByPref);
        UIFormInputSetWithAction folderPathInputSet = new UIFormInputSetWithAction("FolderPathInputSet");
        UIFormStringInput folderPathInput = new UIFormStringInput("FolderPathInput", "FolderPathInput", null);
        folderPathInput.setEditable(false);
        if (folderPath != null) {
            folderPathInput.setValue((Object)folderPath);
        }
        folderPathInputSet.addChild((UIComponent)folderPathInput);
        folderPathInputSet.setActionInfo("FolderPathInput", new String[]{"SelectFolderPath"});
        UIFormStringInput itemsPerPageStringInput = new UIFormStringInput("ItemsPerPage", "ItemsPerPage", null);
        UIFormSelectBox formViewTemplateSelector = new UIFormSelectBox("FormViewTemplate", "FormViewTemplate", formViewerTemplateList);
        UIFormSelectBox paginatorTemplateSelector = new UIFormSelectBox("PaginatorTemplate", "PaginatorTemplate", paginatorTemplateList);
        UIFormCheckBoxInput viewerButtonRefreshCheckbox = new UIFormCheckBoxInput("ViewerButtonRefresh", "ViewerButtonRefresh", null);
        viewerButtonRefreshCheckbox.setChecked(true);
        UIFormCheckBoxInput viewerReadmoreCheckbox = new UIFormCheckBoxInput("ViewerReadmore", "ViewerReadmore", null);
        viewerReadmoreCheckbox.setChecked(true);
        UIFormCheckBoxInput thumbnailsViewCheckbox = new UIFormCheckBoxInput("ViewerThumbnailsView", "ViewerThumbnailsView", null);
        thumbnailsViewCheckbox.setChecked(true);
        UIFormCheckBoxInput titleViewerCheckbox = new UIFormCheckBoxInput("ViewerTitle", "ViewerTitle", null);
        titleViewerCheckbox.setChecked(true);
        UIFormCheckBoxInput summaryViewerCheckbox = new UIFormCheckBoxInput("ViewerSummary", "ViewerSummary", null);
        summaryViewerCheckbox.setChecked(true);
        UIFormCheckBoxInput dateCreatedViewerCheckbox = new UIFormCheckBoxInput("ViewerDateCreated", "ViewerDateCreated", null);
        dateCreatedViewerCheckbox.setChecked(true);
        UIFormCheckBoxInput viewerHeader = new UIFormCheckBoxInput("ViewerHeader", "ViewerHeader", null);
        viewerHeader.setChecked(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        UIFormCheckBoxInput viewerLink = new UIFormCheckBoxInput("ViewerLink", "ViewerLink", null);
        viewerLink.setChecked(Boolean.parseBoolean(portletPreferences.getValue("showLink", null)));
        String refreshAble = portletPreferences.getValue("showRefreshButton", null);
        viewerButtonRefreshCheckbox.setChecked(Boolean.parseBoolean(refreshAble));
        String refreshAbleRM = portletPreferences.getValue("showReadmore", null);
        viewerReadmoreCheckbox.setChecked(Boolean.parseBoolean(refreshAbleRM));
        String imageShowAble = portletPreferences.getValue("showThumbnailsView", null);
        thumbnailsViewCheckbox.setChecked(Boolean.parseBoolean(imageShowAble));
        String titleShowAble = portletPreferences.getValue("showTitle", null);
        titleViewerCheckbox.setChecked(Boolean.parseBoolean(titleShowAble));
        String summaryShowAble = portletPreferences.getValue("showSummary", null);
        summaryViewerCheckbox.setChecked(Boolean.parseBoolean(summaryShowAble));
        String dateShowAble = portletPreferences.getValue("showDateCreated", null);
        dateCreatedViewerCheckbox.setChecked(Boolean.parseBoolean(dateShowAble));
        String formViewTemplate = portletPreferences.getValue("formViewTemplatePath", null);
        formViewTemplateSelector.setValue(formViewTemplate);
        String paginatorTemplate = portletPreferences.getValue("paginatorTemplatePath", null);
        paginatorTemplateSelector.setValue(paginatorTemplate);
        String itemsPerPageVal = portletPreferences.getValue("itemsPerPage", null);
        itemsPerPageStringInput.setValue((Object)itemsPerPageVal);
        itemsPerPageStringInput.addValidator(ZeroNumberValidator.class, new Object[0]);
        itemsPerPageStringInput.addValidator(PositiveNumberFormatValidator.class, new Object[0]);
        itemsPerPageStringInput.setMaxLength(3);
        if (this.isManualMode()) {
            orderBySelectBox.setRendered(false);
            viewerModeRadioBoxInput.setValue((Object)"ManualViewerMode");
            String[] listContent = UICLVPortlet.getContentsByPreference();
            if (listContent != null && listContent.length != 0) {
                this.contentList = Arrays.asList(listContent);
                this.oldContentList = this.contentList;
            }
        } else {
            viewerModeRadioBoxInput.setValue((Object)"AutoViewerMode");
            orderBySelectBox.setRendered(true);
        }
        String preferenceBasePath = portletPreferences.getValue("basePath", null);
        UIFormInputSetWithAction targetPathFormInputSet = new UIFormInputSetWithAction("UICLVBasePathInputSetAction");
        UIFormStringInput targetPathFormStringInput = new UIFormStringInput("UICLVBasePathInput", "UICLVBasePathInput", preferenceBasePath);
        targetPathFormStringInput.setValue((Object)preferenceBasePath);
        targetPathFormStringInput.setEditable(false);
        targetPathFormInputSet.setActionInfo("UICLVBasePathInput", new String[]{"SelectBasePath"});
        targetPathFormInputSet.addUIFormInput((UIFormInput)targetPathFormStringInput);
        this.addChild((UIComponent)viewerModeRadioBoxInput);
        this.addChild((UIComponent)folderPathInputSet);
        this.addChild((UIComponent)orderBySelectBox);
        this.addChild((UIComponent)orderTypeRadioBoxInput);
        this.addChild((UIComponent)headerInput);
        this.addChild((UIComponent)formViewTemplateSelector);
        this.addChild((UIComponent)paginatorTemplateSelector);
        this.addChild((UIComponent)itemsPerPageStringInput);
        this.addChild((UIComponent)viewerButtonRefreshCheckbox);
        this.addChild((UIComponent)thumbnailsViewCheckbox);
        this.addChild((UIComponent)titleViewerCheckbox);
        this.addChild((UIComponent)dateCreatedViewerCheckbox);
        this.addChild((UIComponent)summaryViewerCheckbox);
        this.addChild((UIComponent)viewerHeader);
        this.addChild((UIComponent)viewerLink);
        this.addChild((UIComponent)viewerReadmoreCheckbox);
        this.addChild((UIComponent)targetPathFormInputSet);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void setViewAbleContentList(List<String> list) {
        this.contentList = list;
    }

    public List<String> getViewAbleContentList() {
        return this.contentList;
    }

    public List<String> getOldContentList() {
        return this.oldContentList;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.getUIStringInput(selectField).setValue((Object)((String)value));
        Utils.closePopupWindow((UIContainer)this, (String)this.popupId);
    }

    public boolean isManualMode() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = context.getRequest().getPreferences();
        String viewerMode = preferences.getValue("mode", null);
        return viewerMode != null && !"AutoViewerMode".equals(viewerMode.toString());
    }

    private List<SelectItemOption<String>> getTemplateList(String portletName, String category) throws Exception {
        ArrayList<SelectItemOption<String>> templateOptionList = new ArrayList<SelectItemOption<String>>();
        ApplicationTemplateManagerService templateManagerService = (ApplicationTemplateManagerService)this.getApplicationComponent(ApplicationTemplateManagerService.class);
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        String repository = manageableRepository.getConfiguration().getName();
        List templateNodeList = templateManagerService.getTemplatesByCategory(repository, portletName, category, Utils.getSessionProvider());
        for (Node templateNode : templateNodeList) {
            String templateName = templateNode.getName();
            String templatePath = templateNode.getPath();
            templateOptionList.add((SelectItemOption<String>)new SelectItemOption(templateName, (Object)templatePath));
        }
        return templateOptionList;
    }

    public void activeNewViewerMode(UICLVContainer uiNewViewer) throws Exception {
        UICLVPortlet uiListViewerPortlet = (UICLVPortlet)this.getAncestorOfType(UICLVPortlet.class);
        uiListViewerPortlet.removeChild(UICLVContainer.class);
        uiListViewerPortlet.addChild((UIComponent)uiNewViewer);
        uiNewViewer.init();
    }

    public void resetViewerMode(UICLVContainer uiViewer) throws Exception {
        uiViewer.getChildren().clear();
        uiViewer.init();
    }

    private void doPublication(String repository, String workspaceName, PortletRequestContext portletRequestContext, List<String> selectedList, String portletId) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        Session session = Utils.getSessionProvider().getSession(workspaceName, manageableRepository);
        WCMPublicationService publicationService = (WCMPublicationService)this.getApplicationComponent(WCMPublicationService.class);
        String pageId = Util.getUIPortal().getSelectedNode().getPageReference();
        UserPortalConfigService upcService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        Page page = upcService.getPage(pageId);
        String siteName = Util.getPortalRequestContext().getPortalOwner();
        String remoteUser = portletRequestContext.getRemoteUser();
        for (String nodePath : selectedList) {
            Node tempNode = (Node)session.getItem(nodePath);
            if (!publicationService.isEnrolledInWCMLifecycle(tempNode)) {
                publicationService.updateLifecyleOnChangeContent(tempNode, siteName, remoteUser);
            }
            publicationService.publishContentCLV(tempNode, page, portletId, siteName, remoteUser);
        }
    }

    private void doSuspendPublication(String repository, String workspaceName, PortletRequestContext portletRequestContext, List<String> oldList, String portletId) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(repository);
        Session session = Utils.getSessionProvider().getSession(workspaceName, manageableRepository);
        WCMPublicationService publicationService = (WCMPublicationService)this.getApplicationComponent(WCMPublicationService.class);
        String pageId = Util.getUIPortal().getSelectedNode().getPageReference();
        UserPortalConfigService upcService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        Page page = upcService.getPage(pageId);
        for (String nodePath : oldList) {
            publicationService.suspendPublishedContentFromPage((Node)session.getItem(nodePath), page, portletRequestContext.getRemoteUser());
        }
    }

    private static String generatePorletId(String windowId, PortletRequestContext portletRequestContext) {
        WCMConfigurationService configurationService = (WCMConfigurationService)PublicationUtil.getServices(WCMConfigurationService.class);
        StringBuilder porletId = new StringBuilder();
        porletId.append("portal").append("#").append(Util.getPortalRequestContext().getPortalOwner()).append(":").append(configurationService.getRuntimeContextParam("CLVPortlet")).append("/").append(windowId);
        return porletId.toString();
    }

    public void doSave(List<String> returnRecords) {
        this.setViewAbleContentList(returnRecords);
    }

    static /* synthetic */ String access$000(String x0, PortletRequestContext x1) {
        return UICLVConfig.generatePorletId((String)x0, (PortletRequestContext)x1);
    }

    static /* synthetic */ void access$100(UICLVConfig x0, String x1, String x2, PortletRequestContext x3, List x4, String x5) throws Exception {
        x0.doSuspendPublication(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ void access$200(UICLVConfig x0, String x1, String x2, PortletRequestContext x3, List x4, String x5) throws Exception {
        x0.doPublication(x1, x2, x3, x4, x5);
    }
}

