/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.scv.UIPresentation;
import org.exoplatform.wcm.webui.scv.UIPresentationContainer;
import org.exoplatform.wcm.webui.scv.UISingleContentViewerPortlet;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/SingleContentViewer/UIPresentationContainer.gtmpl", events={@EventConfig(listeners={QuickEditActionListener.class})})
public class UIPresentationContainer
extends UIContainer {
    public UIPresentationContainer() throws Exception {
        this.addChild(UIPresentation.class, null, null);
    }

    public String getTitle(Node node) throws Exception {
        String title = null;
        if (node.hasNode("jcr:content")) {
            Node content = node.getNode("jcr:content");
            if (content.hasProperty("dc:title")) {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
        } else if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        }
        if (title == null) {
            title = node.getName();
        }
        return title;
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return new SimpleDateFormat("dd.MM.yyyy '|' hh'h'mm").format(calendar.getTime());
        }
        return null;
    }

    public Node getNodeView() {
        try {
            UIPresentation presentation = (UIPresentation)this.getChild(UIPresentation.class);
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
            String repository = preferences.getValue(UISingleContentViewerPortlet.REPOSITORY, null);
            String workspace = preferences.getValue(UISingleContentViewerPortlet.WORKSPACE, null);
            String nodeIdentifier = preferences.getValue(UISingleContentViewerPortlet.IDENTIFIER, null);
            Node viewNode = Utils.getViewableNodeByComposer((String)repository, (String)workspace, (String)nodeIdentifier);
            presentation.setNode(viewNode);
            Node orgNode = Utils.getViewableNodeByComposer((String)repository, (String)workspace, (String)nodeIdentifier, (String)"base");
            presentation.setOriginalNode(orgNode);
            return viewNode;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPrintUrl() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        String repository = preferences.getValue(UISingleContentViewerPortlet.REPOSITORY, null);
        String workspace = preferences.getValue(UISingleContentViewerPortlet.WORKSPACE, null);
        String path = preferences.getValue(UISingleContentViewerPortlet.IDENTIFIER, null);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String portalURI = Util.getPortalRequestContext().getPortalURI();
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)this.getApplicationComponent(WCMConfigurationService.class);
        String printPageUrl = wcmConfigurationService.getRuntimeContextParam("printViewerPage");
        String printUrl = portalURI + printPageUrl + "/" + repository + "/" + workspace + path + "?isPrint=true";
        return printUrl;
    }
}

