/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.category;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.portlet.PortletPreferences;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.wcm.webui.category.UICategoryNavigationUtils;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class})})
public class UICategoryNavigationTreeBase
extends UITree {
    public String renderNode(Object obj) throws Exception {
        String beanIconField;
        Node node = (Node)obj;
        String nodeTypeIcon = Utils.getNodeTypeIcon((Node)node, (String)"16x16Icon");
        String nodeIcon = this.getExpandIcon();
        String iconGroup = this.getIcon();
        String note = "";
        if (this.isSelected(obj)) {
            nodeIcon = this.getColapseIcon();
            iconGroup = this.getSelectedIcon();
            note = " NodeSelected";
        }
        if ((beanIconField = this.getBeanIconField()) != null && beanIconField.length() > 0 && this.getFieldValue(obj, beanIconField) != null) {
            iconGroup = (String)this.getFieldValue(obj, beanIconField);
        }
        this.renderCategoryLink(node);
        String objId = String.valueOf(this.getId(obj));
        StringBuilder builder = new StringBuilder();
        if (nodeIcon.equals(this.getExpandIcon())) {
            builder.append(" <a class=\"").append(nodeIcon).append(" ").append(nodeTypeIcon).append("\" href=\"").append(objId).append("\">");
        } else {
            builder.append(" <a class=\"").append(nodeIcon).append(" ").append(nodeTypeIcon).append("\" onclick=\"eXo.portal.UIPortalControl.collapseTree(this)").append("\">");
        }
        UIRightClickPopupMenu popupMenu = this.getUiPopupMenu();
        String beanLabelField = this.getBeanLabelField();
        String className = "NodeIcon";
        boolean flgSymlink = false;
        if (Utils.isSymLink((Node)node)) {
            flgSymlink = true;
            className = "NodeIconLink";
        }
        if (popupMenu == null) {
            builder.append(" <div class=\"").append(className).append(" ").append(iconGroup).append(" ").append(nodeTypeIcon).append(note).append("\"").append(" title=\"").append(this.getFieldValue(obj, beanLabelField)).append("\"").append(">");
            if (flgSymlink) {
                builder.append("  <div class=\"LinkSmall\">").append(this.getFieldValue(obj, beanLabelField)).append("</div>");
            } else {
                builder.append(this.getFieldValue(obj, beanLabelField));
            }
            builder.append("</div>");
        } else {
            builder.append(" <div class=\"").append(className).append(" ").append(iconGroup).append(" ").append(nodeTypeIcon).append(note).append("\" ").append(popupMenu.getJSOnclickShowPopup(objId, null)).append(" title=\"").append(this.getFieldValue(obj, beanLabelField)).append("\"").append(">");
            if (flgSymlink) {
                builder.append("  <div class=\"LinkSmall\">").append(this.getFieldValue(obj, beanLabelField)).append("</div>");
            } else {
                builder.append(this.getFieldValue(obj, beanLabelField));
            }
            builder.append("</div>");
        }
        builder.append(" </a>");
        return builder.toString();
    }

    public String getTemplate() {
        return UICategoryNavigationUtils.getPortletPreferences().getValue("templatePath", null);
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        String repository = UICategoryNavigationUtils.getPortletPreferences().getValue("repository", null);
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig(repository).getSystemWorkspace();
        return new JCRResourceResolver(repository, workspace, TemplateService.EXO_TEMPLATE_FILE_PROP);
    }

    public String getActionLink() throws Exception {
        PortletRequestContext porletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        String requestURI = requestWrapper.getRequestURI();
        PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        String preferenceTargetPage = portletPreferences.getValue("targetPath", "");
        String backPath = requestURI.substring(0, requestURI.lastIndexOf("/"));
        if (backPath.endsWith(preferenceTargetPage) || requestURI.endsWith(Util.getUIPortal().getSelectedNode().getUri())) {
            backPath = "javascript:void(0)";
        } else if (backPath.endsWith(preferenceTreeName)) {
            backPath = backPath.substring(0, backPath.lastIndexOf("/"));
        }
        return backPath;
    }

    public boolean isSelected(Object obj) throws Exception {
        Node selectedNode = (Node)this.getSelected();
        Node node = (Node)obj;
        if (selectedNode == null) {
            return false;
        }
        return selectedNode.getPath().equals(node.getPath());
    }

    public List<Node> getSubcategories(String categoryPath) throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceRepository = portletPreferences.getValue("repository", "");
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        Node treeNode = taxonomyService.getTaxonomyTree(preferenceRepository, preferenceTreeName);
        Node categoryNode = null;
        categoryNode = "".equals(categoryPath) ? treeNode : treeNode.getNode(categoryPath);
        NodeIterator nodeIterator = categoryNode.getNodes();
        ArrayList<Node> subcategories = new ArrayList<Node>();
        while (nodeIterator.hasNext()) {
            Node subcategory = nodeIterator.nextNode();
            if (!subcategory.isNodeType("exo:taxonomy")) continue;
            subcategories.add(subcategory);
        }
        return subcategories;
    }

    public String resolveCategoryPathByUri(WebuiRequestContext context) {
        PortletRequestContext porletRequestContext = (PortletRequestContext)context;
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)porletRequestContext.getRequest();
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        UIPortal uiPortal = Util.getUIPortal();
        String portalURI = portalRequestContext.getPortalURI();
        String requestURI = requestWrapper.getRequestURI();
        String pageNodeSelected = uiPortal.getSelectedNode().getName();
        String parameters = null;
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)requestURI, (String)portalURI.concat(pageNodeSelected)), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        String categoryPath = parameters.indexOf("/") >= 0 ? parameters.substring(parameters.indexOf("/")) : "";
        return categoryPath;
    }

    public List<String> getCategoriesByUri(String categoryUri) throws Exception {
        PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        if (preferenceTreeName.equals(categoryUri)) {
            categoryUri = "";
        }
        ArrayList<String> categories = new ArrayList<String>();
        String[] tempCategories = categoryUri.split("/");
        String tempCategory = "";
        for (int i = 0; i < tempCategories.length; ++i) {
            tempCategory = i == 0 ? "" : (i == 1 ? tempCategories[1] : tempCategory + "/" + tempCategories[i]);
            categories.add(tempCategory);
        }
        return categories;
    }

    public String renderCategoryLink(Node node) throws Exception {
        String portalURI = Util.getPortalRequestContext().getPortalURI();
        PortletPreferences portletPreferences = UICategoryNavigationUtils.getPortletPreferences();
        String preferenceTargetPage = portletPreferences.getValue("targetPath", "");
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)this.getApplicationComponent(LivePortalManagerService.class);
        Node portalNode = livePortalManagerService.getLivePortalByChild(node);
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        String categoryPath = node.getPath().replaceFirst(portalNode.getPath(), "");
        categoryPath = categoryPath.substring(categoryPath.indexOf(preferenceTreeName) + preferenceTreeName.length());
        return portalURI + preferenceTargetPage + categoryPath;
    }
}

