/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pclv;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.wcm.core.WebSchemaConfigService;
import org.exoplatform.services.wcm.images.RESTImagesRendererService;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.paginator.UICustomizeablePaginator;
import org.exoplatform.wcm.webui.pclv.UIPCLVForm;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={RefreshActionListener.class})}), @ComponentConfig(type=UICustomizeablePaginator.class, events={@EventConfig(listeners={UICustomizeablePaginator.ShowPageActionListener.class})})})
public class UIPCLVForm
extends UIForm {
    private String templatePath;
    private ResourceResolver resourceResolver;
    private UICustomizeablePaginator uiPaginator;
    private String contentColumn;
    private boolean showLink;
    private boolean showHeader;
    private boolean showReadmore;
    private String header;
    private DateFormat dateFormatter = null;
    private String autoDetection;
    private String showMoreLink;
    private String showRSSLink;
    private String rssLink;

    public String getRssLink() {
        return this.rssLink;
    }

    public void setRssLink(String rssLink) {
        this.rssLink = rssLink;
    }

    public void init(String templatePath, ResourceResolver resourceResolver, PageList dataPageList) throws Exception {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String paginatorTemplatePath = portletPreferences.getValue("paginatorTemplatePath", null);
        this.templatePath = templatePath;
        this.resourceResolver = resourceResolver;
        this.uiPaginator = (UICustomizeablePaginator)this.addChild(UICustomizeablePaginator.class, null, null);
        this.uiPaginator.setTemplatePath(paginatorTemplatePath);
        this.uiPaginator.setResourceResolver(resourceResolver);
        this.uiPaginator.setPageList(dataPageList);
        Locale locale = Util.getPortalRequestContext().getLocale();
        this.dateFormatter = SimpleDateFormat.getDateTimeInstance(2, 2, locale);
    }

    public boolean showRefreshButton() {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String isShow = portletPreferences.getValue("showRefreshButton", null);
        return isShow != null ? Boolean.parseBoolean(isShow) : false;
    }

    public boolean showRSSLink() {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String isShow = portletPreferences.getValue("showRssLink", null);
        return isShow != null ? Boolean.parseBoolean(isShow) : false;
    }

    public boolean isShowField(String field) {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String showAble = portletPreferences.getValue(field, null);
        return showAble != null ? Boolean.parseBoolean(showAble) : false;
    }

    public boolean showPaginator() throws Exception {
        PortletPreferences portletPreferences = this.getPortletPreferences();
        String itemsPerPage = portletPreferences.getValue("itemsPerPage", null);
        int totalItems = this.uiPaginator.getTotalItems();
        return totalItems > Integer.parseInt(itemsPerPage);
    }

    public DateFormat getDatetimeFommatter() {
        return this.dateFormatter;
    }

    public void setDateTimeFormat(String format) {
        ((SimpleDateFormat)this.dateFormatter).applyPattern(format);
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPaginator;
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return this.resourceResolver;
    }

    public List getCurrentPageData() throws Exception {
        return this.uiPaginator.getCurrentPageData();
    }

    public String getTitle(Node node) throws Exception {
        return node.hasProperty("exo:title") ? node.getProperty("exo:title").getString() : node.getName();
    }

    public String getSummary(Node node) throws Exception {
        if (node.hasProperty("exo:summary")) {
            return node.getProperty("exo:summary").getValue().getString();
        }
        return null;
    }

    public String getCreatedDate(Node node) throws Exception {
        if (node.hasProperty("exo:dateCreated")) {
            Calendar calendar = node.getProperty("exo:dateCreated").getValue().getDate();
            return this.dateFormatter.format(calendar.getTime());
        }
        return null;
    }

    public String getIllustrativeImage(Node node) throws Exception {
        WebSchemaConfigService schemaConfigService = (WebSchemaConfigService)this.getApplicationComponent(WebSchemaConfigService.class);
        WebContentSchemaHandler contentSchemaHandler = (WebContentSchemaHandler)schemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
        Node illustrativeImage = null;
        RESTImagesRendererService imagesRendererService = (RESTImagesRendererService)this.getApplicationComponent(RESTImagesRendererService.class);
        String uri = null;
        try {
            illustrativeImage = contentSchemaHandler.getIllustrationImage(node);
            uri = imagesRendererService.generateURI(illustrativeImage);
        }
        catch (Exception e) {
            // empty catch block
        }
        return uri;
    }

    public String generateLink(Node node) throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)portletRequestContext.getRequest();
        PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
        UIPortal uiPortal = Util.getUIPortal();
        String link = null;
        String portalURI = portalRequestContext.getPortalURI();
        String requestURI = requestWrapper.getRequestURI();
        String pageNodeSelected = uiPortal.getSelectedNode().getUri();
        String parameters = null;
        try {
            parameters = URLDecoder.decode(StringUtils.substringAfter((String)requestURI, (String)portalURI.concat(pageNodeSelected + "/")), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        PortletRequest portletRequest = portletRequestContext.getRequest();
        PortletPreferences portletPreferences = portletRequest.getPreferences();
        String preferenceRepository = portletPreferences.getValue("repository", "");
        String preferenceTreeName = portletPreferences.getValue("treeName", "");
        String preferenceTargetPage = portletPreferences.getValue("targetPage", "");
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        Node treeNode = taxonomyService.getTaxonomyTree(preferenceRepository, preferenceTreeName);
        String categoryPath = parameters.substring(parameters.indexOf("/") + 1);
        if (preferenceTreeName.equals(categoryPath)) {
            categoryPath = "";
        }
        Node categoryNode = treeNode.getNode(categoryPath);
        Node newNode = categoryNode.getNode(node.getName());
        String path = newNode.getPath();
        String itemPath = path.substring(path.indexOf(preferenceTreeName));
        String backToCategory = "";
        backToCategory = categoryPath.equals("") ? pageNodeSelected : itemPath.substring(0, itemPath.indexOf(newNode.getName()) - 1);
        link = portalURI + preferenceTargetPage + "/" + itemPath + "?back" + "=" + "/" + backToCategory;
        return link;
    }

    private PortletPreferences getPortletPreferences() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPreferences = context.getRequest().getPreferences();
        return portletPreferences;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public UICustomizeablePaginator getUiPaginator() {
        return this.uiPaginator;
    }

    public void setUiPaginator(UICustomizeablePaginator uiPaginator) {
        this.uiPaginator = uiPaginator;
    }

    public String getContentColumn() {
        return this.contentColumn;
    }

    public void setContentColumn(String contentColumn) {
        this.contentColumn = contentColumn;
    }

    public boolean isShowLink() {
        return this.showLink;
    }

    public void setShowLink(boolean showLink) {
        this.showLink = showLink;
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public boolean isShowReadmore() {
        return this.showReadmore;
    }

    public void setShowReadmore(boolean showReadmore) {
        this.showReadmore = showReadmore;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public DateFormat getDateFormatter() {
        return this.dateFormatter;
    }

    public void setDateFormatter(DateFormat dateFormatter) {
        this.dateFormatter = dateFormatter;
    }

    public String getAutoDetection() {
        return this.autoDetection;
    }

    public void setAutoDetection(String autoDetection) {
        this.autoDetection = autoDetection;
    }

    public String getShowMoreLink() {
        return this.showMoreLink;
    }

    public void setShowMoreLink(String showMoreLink) {
        this.showMoreLink = showMoreLink;
    }

    public String getShowRSSLink() {
        return this.showRSSLink;
    }

    public void setShowRSSLink(String showRSSLink) {
        this.showRSSLink = showRSSLink;
    }

    public String getTemplate() {
        return this.templatePath;
    }

    public Node getNodeView(Node node) throws Exception {
        String realNodeUUID = node.getProperty("exo:uuid").getString();
        Node realNode = node.getSession().getNodeByUUID(realNodeUUID);
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("filter-mode", Utils.getCurrentMode());
        String lifecyleName = null;
        try {
            lifecyleName = publicationService.getNodeLifecycleName(realNode);
        }
        catch (NotInPublicationLifecycleException e) {
            // empty catch block
        }
        if (lifecyleName == null) {
            return realNode;
        }
        PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(lifecyleName);
        Node viewNode = publicationPlugin.getNodeView(realNode, context);
        return viewNode;
    }
}

