/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.pcv;

import javax.jcr.Node;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.pcv.UIPCVContentDialog;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveDraftActionListener.class}), @EventConfig(listeners={FastPublishActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIPCVContentDialog
extends UIDialogForm {
    private Node documentNode;

    public void setDocumentNode(Node node) {
        this.documentNode = node;
    }

    public Node getDocumentNode() {
        return this.documentNode;
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            return templateService.getTemplatePathByUser(true, this.contentType, userName, this.repositoryName);
        }
        catch (Exception e) {
            Utils.createPopupMessage((UIContainer)this, (String)"UIDocumentForm.msg.not-support", (Object[])new Object[]{this.contentType}, (int)0);
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        try {
            if (this.resourceResolver == null) {
                RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
                DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
                String workspace = dmsConfiguration.getConfig(this.repositoryName).getSystemWorkspace();
                this.resourceResolver = new JCRResourceResolver(this.repositoryName, workspace, TemplateService.EXO_TEMPLATE_FILE_PROP);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.resourceResolver;
    }

    static /* synthetic */ boolean access$000(UIPCVContentDialog x0) {
        return x0.isAddNew;
    }

    static /* synthetic */ String access$100(UIPCVContentDialog x0) {
        return x0.repositoryName;
    }

    static /* synthetic */ boolean access$200(UIPCVContentDialog x0) {
        return x0.isAddNew;
    }

    static /* synthetic */ String access$300(UIPCVContentDialog x0) {
        return x0.repositoryName;
    }
}

