/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.scv.config.access;

import java.util.Iterator;
import java.util.List;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.wcm.webui.scv.config.access.UIPermissionSetting;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ResetActionListener.class}), @EventConfig(listeners={SelectUserActionListener.class}), @EventConfig(listeners={SelectMemberActionListener.class}), @EventConfig(listeners={AddAnyActionListener.class})})
public class UIPermissionSetting
extends UIForm
implements UISelectable {
    public static final String USERS_INPUTSET = "usersInputSet";
    public static final String USERS_STRINGINPUT = "usersStringInput";
    public static final String PERMISSION = "permission";
    public static final String POPUP_SELECT = "SelectUserOrGroup";
    public static final String ACCESSIBLE = "accessible";
    public static final String EDITABLE = "editable";

    public UIPermissionSetting() throws Exception {
        UIFormInputSetWithAction permissionInputSet = new UIFormInputSetWithAction(USERS_INPUTSET);
        UIFormStringInput formStringInput = new UIFormStringInput(USERS_STRINGINPUT, USERS_STRINGINPUT, null);
        formStringInput.setEditable(false);
        permissionInputSet.addChild((UIComponent)formStringInput);
        permissionInputSet.setActionInfo(USERS_STRINGINPUT, new String[]{"SelectUser", "SelectMember", "AddAny"});
        permissionInputSet.showActionInfo(true);
        this.addChild((UIComponent)permissionInputSet);
        this.addChild((UIComponent)new UIFormCheckBoxInput(ACCESSIBLE, ACCESSIBLE, null));
        this.addChild((UIComponent)new UIFormCheckBoxInput(EDITABLE, EDITABLE, null));
        this.setActions(new String[]{"Save", "Reset"});
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.getUIStringInput(selectField).setValue((Object)((String)value));
    }

    public void fillForm(String user, ExtendedNode node) throws Exception {
        UIFormInputSetWithAction inputSet = (UIFormInputSetWithAction)this.getChildById(USERS_INPUTSET);
        inputSet.getUIStringInput(USERS_STRINGINPUT).setValue((Object)user);
        String owner = node.getProperty("exo:owner").getString();
        if (user.equals(owner)) {
            this.getUIFormCheckBoxInput(ACCESSIBLE).setChecked(true);
            this.getUIFormCheckBoxInput(EDITABLE).setChecked(true);
        } else {
            List permsList = node.getACL().getPermissionEntries();
            Iterator perIter = permsList.iterator();
            StringBuilder userPermission = new StringBuilder();
            while (perIter.hasNext()) {
                AccessControlEntry accessControlEntry = (AccessControlEntry)perIter.next();
                if (!user.equals(accessControlEntry.getIdentity())) continue;
                userPermission.append(accessControlEntry.getPermission()).append(" ");
            }
            int numPermission = 0;
            for (String perm : PermissionType.ALL) {
                if (!userPermission.toString().contains(perm)) continue;
                ++numPermission;
            }
            if (numPermission == PermissionType.ALL.length) {
                this.getUIFormCheckBoxInput(EDITABLE).setChecked(true);
                this.getUIFormCheckBoxInput(ACCESSIBLE).setChecked(true);
            } else {
                this.getUIFormCheckBoxInput(ACCESSIBLE).setChecked(true);
            }
        }
    }

    protected void lockForm(boolean isLock) {
        UIFormInputSetWithAction inputSet = (UIFormInputSetWithAction)this.getChildById(USERS_INPUTSET);
        if (isLock) {
            this.setActions(new String[]{"Reset"});
            inputSet.setActionInfo(USERS_STRINGINPUT, null);
        } else {
            this.setActions(new String[]{"Save", "Reset"});
            inputSet.setActionInfo(USERS_STRINGINPUT, new String[]{"SelectUser", "SelectMember", "AddAny"});
        }
        this.getUIFormCheckBoxInput(ACCESSIBLE).setEnable(!isLock);
        this.getUIFormCheckBoxInput(EDITABLE).setEnable(!isLock);
    }
}

