/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.dialog;

import java.security.AccessControlException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.DialogFormActionListeners;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationConstant;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.dialog.UIContentDialogPreference;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveDraftActionListener.class}), @EventConfig(listeners={FastPublishActionListener.class}), @EventConfig(listeners={PreferencesActionListener.class}), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={DialogFormActionListeners.RemoveDataActionListener.class})})
public class UIContentDialogForm
extends UIDialogForm {
    public static final String CONTENT_DIALOG_FORM_POPUP_WINDOW = "UIContentDialogFormPopupWindow";
    private NodeLocation webcontentNodeLocation;
    private Class<? extends UIContentDialogPreference> preferenceComponent;

    public NodeLocation getWebcontentNodeLocation() {
        return this.webcontentNodeLocation;
    }

    public void setWebcontentNodeLocation(NodeLocation webcontentNodeLocation) {
        this.webcontentNodeLocation = webcontentNodeLocation;
    }

    public Class<? extends UIContentDialogPreference> getPreferenceComponent() {
        return this.preferenceComponent;
    }

    public void setPreferenceComponent(Class<? extends UIContentDialogPreference> preferenceComponent) {
        this.preferenceComponent = preferenceComponent;
    }

    public UIContentDialogForm() throws Exception {
        this.setActions(new String[]{"SaveDraft", "FastPublish", "Preferences", "Close"});
    }

    public void init(Node webcontent, boolean isAddNew) throws Exception {
        NodeLocation webcontentNodeLocation;
        this.webcontentNodeLocation = webcontentNodeLocation = NodeLocation.make((Node)webcontent);
        this.repositoryName = webcontentNodeLocation.getRepository();
        this.workspaceName = webcontentNodeLocation.getWorkspace();
        this.contentType = webcontent.getPrimaryNodeType().getName();
        this.nodePath = webcontent.getPath();
        this.isAddNew = isAddNew;
        this.setStoredPath(webcontent.getParent().getPath());
        this.resetProperties();
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            return templateService.getTemplatePathByUser(true, this.contentType, userName, this.repositoryName);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.contentType};
            uiApp.addMessage(new ApplicationMessage("UIDocumentForm.msg.not-support", arg, 0));
            return null;
        }
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        String workspace = dmsConfiguration.getConfig(this.repositoryName).getSystemWorkspace();
        return new JCRResourceResolver(this.repositoryName, workspace, TemplateService.EXO_TEMPLATE_FILE_PROP);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FastPublishActionListener
    extends EventListener<UIContentDialogForm> {
        public void execute(Event<UIContentDialogForm> event) throws Exception {
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)((Object)event.getSource());
            try {
                Node webContentNode = contentDialogForm.getNode();
                if (!webContentNode.isCheckedOut()) {
                    webContentNode.checkout();
                }
                List inputs = contentDialogForm.getChildren();
                Map inputProperties = DialogFormUtil.prepareMap((List)inputs, (Map)contentDialogForm.getInputProperties());
                CmsService cmsService = (CmsService)contentDialogForm.getApplicationComponent(CmsService.class);
                cmsService.storeNode(contentDialogForm.contentType, contentDialogForm.getNode().getParent(), inputProperties, contentDialogForm.isAddNew, contentDialogForm.repositoryName);
                PublicationService publicationService = (PublicationService)contentDialogForm.getApplicationComponent(PublicationService.class);
                PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get(publicationService.getNodeLifecycleName(webContentNode));
                HashMap<String, String> context = new HashMap<String, String>();
                if (webContentNode != null) {
                    context.put(StageAndVersionPublicationConstant.CURRENT_REVISION_NAME, webContentNode.getName());
                }
                publicationPlugin.changeState(webContentNode, "published", context);
            }
            catch (AccessControlException ace) {
            }
            catch (VersionException ve) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.in-versioning", null, 1);
            }
            catch (ItemNotFoundException item) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.item-not-found", null, 1);
            }
            catch (RepositoryException repo) {
                String key = "UIDocumentForm.msg.repository-exception";
                if (ItemExistsException.class.isInstance((Object)repo)) {
                    key = "UIDocumentForm.msg.not-allowed-same-name-sibling";
                }
                Utils.createPopupMessage((UIContainer)contentDialogForm, key, null, 1);
            }
            catch (NumberFormatException nfe) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.numberformat-exception", null, 1);
            }
            catch (Exception e) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.cannot-save", null, 1);
            }
            Utils.closePopupWindow((UIContainer)contentDialogForm, UIContentDialogForm.CONTENT_DIALOG_FORM_POPUP_WINDOW);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveDraftActionListener
    extends EventListener<UIContentDialogForm> {
        public void execute(Event<UIContentDialogForm> event) throws Exception {
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)((Object)event.getSource());
            try {
                Node webContentNode = contentDialogForm.getNode();
                if (!webContentNode.isCheckedOut()) {
                    webContentNode.checkout();
                }
                List inputs = contentDialogForm.getChildren();
                Map inputProperties = DialogFormUtil.prepareMap((List)inputs, (Map)contentDialogForm.getInputProperties());
                CmsService cmsService = (CmsService)contentDialogForm.getApplicationComponent(CmsService.class);
                cmsService.storeNode(contentDialogForm.contentType, contentDialogForm.getNode().getParent(), inputProperties, contentDialogForm.isAddNew, contentDialogForm.repositoryName);
            }
            catch (AccessControlException ace) {
            }
            catch (VersionException ve) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.in-versioning", null, 1);
            }
            catch (ItemNotFoundException item) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.item-not-found", null, 1);
            }
            catch (RepositoryException repo) {
                String key = "UIDocumentForm.msg.repository-exception";
                if (ItemExistsException.class.isInstance((Object)repo)) {
                    key = "UIDocumentForm.msg.not-allowed-same-name-sibling";
                }
                Utils.createPopupMessage((UIContainer)contentDialogForm, key, null, 1);
            }
            catch (NumberFormatException nfe) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.numberformat-exception", null, 1);
            }
            catch (Exception e) {
                Utils.createPopupMessage((UIContainer)contentDialogForm, "UIDocumentForm.msg.cannot-save", null, 1);
            }
            Utils.closePopupWindow((UIContainer)contentDialogForm, UIContentDialogForm.CONTENT_DIALOG_FORM_POPUP_WINDOW);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PreferencesActionListener
    extends EventListener<UIContentDialogForm> {
        public void execute(Event<UIContentDialogForm> event) throws Exception {
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)((Object)event.getSource());
            UIPopupContainer popupContainer = Utils.getPopupContainer((UIContainer)contentDialogForm);
            popupContainer.addChild((UIComponent)contentDialogForm);
            contentDialogForm.setParent((UIComponent)popupContainer);
            UIContentDialogPreference contentDialogPreference = null;
            contentDialogPreference = contentDialogForm.getPreferenceComponent() != null ? (UIContentDialogPreference)contentDialogForm.createUIComponent(contentDialogForm.getPreferenceComponent(), null, null) : (UIContentDialogPreference)contentDialogForm.createUIComponent(UIContentDialogPreference.class, null, null);
            Utils.updatePopupWindow((UIContainer)contentDialogForm, (UIComponent)contentDialogPreference, UIContentDialogForm.CONTENT_DIALOG_FORM_POPUP_WINDOW);
            contentDialogPreference.init();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIContentDialogForm> {
        public void execute(Event<UIContentDialogForm> event) throws Exception {
            UIContentDialogForm contentDialogForm = (UIContentDialogForm)((Object)event.getSource());
            Utils.closePopupWindow((UIContainer)contentDialogForm, UIContentDialogForm.CONTENT_DIALOG_FORM_POPUP_WINDOW);
        }
    }
}

