/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.wcm.webui.selector.UISelectPathPanel;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(lifecycle=Lifecycle.class, template="classpath:groovy/wcm/webui/selector/content/UIContentBrowsePanel.gtmpl", events={@EventConfig(listeners={ChangeContentTypeActionListener.class})}), @ComponentConfig(type=UISelectPathPanel.class, id="UIContentBrowsePathSelector", template="classpath:groovy/wcm/webui/selector/content/UIContentBrowsePathSelector.gtmpl", events={@EventConfig(listeners={UISelectPathPanel.SelectActionListener.class})})})
public abstract class UIContentBrowsePanel
extends UIBaseNodeTreeSelector
implements UIPopupComponent {
    public static final String WEBCONENT = "WebContent";
    public static final String DMSDOCUMENT = "DMSDocument";
    public static final String MEDIA = "Media";
    public final String SELECT_TYPE_CONTENT = "selectTypeContent";
    public String[] types = new String[]{"WebContent", "DMSDocument", "Media"};
    public String selectedValues = "WebContent";
    private NodeLocation currentPortalLocation;
    public String contentType = "WebContent";
    String[] acceptedNodeTypes = null;

    public void reRenderChild(String typeContent) throws Exception {
        if (typeContent == null || typeContent.equals(WEBCONENT)) {
            this.contentType = WEBCONENT;
        } else if (typeContent.equals(DMSDOCUMENT)) {
            this.contentType = DMSDOCUMENT;
        }
    }

    public abstract void doSelect(Node var1, WebuiRequestContext var2) throws Exception;

    public void init() throws Exception {
        Node currentPortal = this.getCurrentPortal();
        if (this.contentType == null || this.contentType.equals(WEBCONENT)) {
            this.acceptedNodeTypes = new String[]{"exo:webContent"};
        } else if (this.contentType.equals(DMSDOCUMENT)) {
            String repositoryName = ((ManageableRepository)currentPortal.getSession().getRepository()).getConfiguration().getName();
            List listAcceptedNodeTypes = ((TemplateService)this.getApplicationComponent(TemplateService.class)).getDocumentTemplates(repositoryName);
            ArrayList<String> listAcceptedNodeTypesTemp = new ArrayList<String>();
            for (String acceptedNodetype : listAcceptedNodeTypes) {
                if ("exo:webContent".equals(acceptedNodetype) || "exo:pictureOnHeadWebcontent".equals(acceptedNodetype)) continue;
                listAcceptedNodeTypesTemp.add(acceptedNodetype);
            }
            this.acceptedNodeTypes = new String[listAcceptedNodeTypesTemp.size()];
            listAcceptedNodeTypesTemp.toArray(this.acceptedNodeTypes);
        }
        UISelectPathPanel selectPathPanel = (UISelectPathPanel)this.getChild(UISelectPathPanel.class);
        selectPathPanel.setAcceptedNodeTypes(this.acceptedNodeTypes);
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)this.getApplicationComponent(LivePortalManagerService.class);
        String currentPortalName = Util.getUIPortal().getName();
        SessionProvider provider = SessionProviderFactory.createSessionProvider();
        currentPortal = livePortalManagerService.getLivePortal(provider, currentPortalName);
        this.currentPortalLocation = NodeLocation.make((Node)currentPortal);
        provider.close();
    }

    public void onChange(Node node, Object context) throws Exception {
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public Node getCurrentPortal() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentPortalLocation);
    }

    public void setCurrentPortal(Node currentPortal) {
        this.currentPortalLocation = NodeLocation.make((Node)currentPortal);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeContentTypeActionListener
    extends EventListener<UIContentBrowsePanel> {
        public void execute(Event<UIContentBrowsePanel> event) throws Exception {
            UIContentBrowsePanel contentBrowsePanel = (UIContentBrowsePanel)((Object)event.getSource());
            String type = event.getRequestContext().getRequestParameter("objectId");
            if (type.equals(contentBrowsePanel.selectedValues)) {
                return;
            }
            contentBrowsePanel.selectedValues = type;
            UISelectPathPanel selectPathPanel = (UISelectPathPanel)contentBrowsePanel.getChild(UISelectPathPanel.class);
            selectPathPanel.setParentNode(null);
            selectPathPanel.updateGrid();
            contentBrowsePanel.reRenderChild(contentBrowsePanel.selectedValues);
            contentBrowsePanel.init();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)contentBrowsePanel);
        }
    }
}

