/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.folder;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.selector.UISelectPathPanel;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/wcm/webui/selector/UISelectPathPanel.gtmpl", events={@EventConfig(listeners={UISelectPathPanel.SelectActionListener.class})})
public class UISelectPathPanelFolder
extends UISelectPathPanel {
    private String repositoryName_;

    public UISelectPathPanelFolder() throws Exception {
        RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        this.repositoryName_ = repoService.getCurrentRepository().getConfiguration().getName();
    }

    public String getRepositoryName() {
        return this.repositoryName_;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName_ = repositoryName;
    }

    @Override
    public List<Node> getListSelectableNodes() throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.parentNode == null) {
            return list;
        }
        Node realNode = Utils.getNodeSymLink((Node)this.parentNode);
        NodeIterator iterator = realNode.getNodes();
        while (iterator.hasNext()) {
            Node symChild;
            Node child = iterator.nextNode();
            if (child.isNodeType("exo:hiddenable") || !this.isFolder(symChild = Utils.getNodeSymLink((Node)child))) continue;
            list.add(child);
        }
        ArrayList<Node> listNodeCheck = new ArrayList<Node>();
        for (Node node : list) {
            this.addNodePublish(listNodeCheck, node, this.publicationService_);
        }
        return listNodeCheck;
    }

    private boolean isFolder(Node node) throws Exception {
        return !this.isDocumentType(node) && (node.isNodeType("nt:folder") || node.isNodeType("nt:unstructured") || node.isNodeType("exo:taxonomy"));
    }

    private boolean isDocumentType(Node node) throws Exception {
        if (this.repositoryName_.equals(null)) {
            RepositoryService repoService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            this.repositoryName_ = repoService.getCurrentRepository().getConfiguration().getName();
        }
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        List documentList = templateService.getAllDocumentNodeTypes(this.repositoryName_);
        for (String documentType : documentList) {
            if (!node.getPrimaryNodeType().isNodeType(documentType)) continue;
            return true;
        }
        return false;
    }
}

