/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui;

import com.ibm.icu.text.Transliterator;
import java.util.HashMap;
import javax.jcr.Node;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.core.UIPopupWindow;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String TURN_ON_QUICK_EDIT = "turnOnQuickEdit";

    public static boolean isEditPortletInCreatePageWizard() {
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)portalApplication.getChildById("UIMaskWorkspace");
        return uiMaskWS.getWindowWidth() > 0 && uiMaskWS.getWindowHeight() < 0;
    }

    public static boolean isQuickEditMode(UIContainer container, String popupWindowId) {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        if (popupContainer == null) {
            return false;
        }
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.getChildById(popupWindowId);
        return popupWindow != null;
    }

    public static String getRealPortletId(PortletRequestContext portletRequestContext) {
        String portletId = portletRequestContext.getWindowId();
        int modeState = Util.getUIPortalApplication().getModeState();
        switch (modeState) {
            case 0: {
                return portletId;
            }
            case 1: {
                return "UIPortlet-" + portletId;
            }
            case 2: {
                return "EditMode-" + portletId;
            }
        }
        return null;
    }

    public static boolean canEditCurrentPortal(String remoteUser) throws Exception {
        if (remoteUser == null) {
            return false;
        }
        IdentityRegistry identityRegistry = (IdentityRegistry)Util.getUIPortalApplication().getApplicationComponent(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(remoteUser);
        if (identity == null) {
            return false;
        }
        UIPortal uiPortal = Util.getUIPortal();
        String editPermission = uiPortal.getEditPermission();
        MembershipEntry membershipEntry = MembershipEntry.parse((String)editPermission);
        return identity.isMemberOf(membershipEntry);
    }

    public static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        str = accentsconverter.transliterate(str);
        StringBuffer cleanedStr = new StringBuffer(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '_') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '_';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (i > 0 && !Character.isLetterOrDigit(c) && c != '_') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 95 || cleanedStr.charAt(i - 1) != '_') continue;
            cleanedStr.deleteCharAt(i--);
        }
        return cleanedStr.toString().toLowerCase();
    }

    public static void updatePortal(PortletRequestContext context) {
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        PortalRequestContext portalRequestContext = (PortalRequestContext)context.getParentAppRequestContext();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApplication.getChildById("UIWorkingWorkspace");
        portalRequestContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        portalRequestContext.setFullRender(true);
    }

    public static Node getViewableNodeByComposer(String repository, String workspace, String nodeIdentifier) {
        return Utils.getViewableNodeByComposer(repository, workspace, nodeIdentifier, null);
    }

    public static Node getViewableNodeByComposer(String repository, String workspace, String nodeIdentifier, String version) {
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            filters.put("filter-mode", Utils.getCurrentMode());
            if (version != null) {
                filters.put("filter-version", version);
            }
            return Utils.getService(WCMComposer.class).getContent(repository, workspace, nodeIdentifier, filters, Utils.getSessionProvider());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCurrentMode() {
        Object isQuickEditable = Util.getPortalRequestContext().getRequest().getSession().getAttribute(TURN_ON_QUICK_EDIT);
        if (isQuickEditable == null) {
            return "Live";
        }
        boolean turnOnQuickEdit = Boolean.parseBoolean(isQuickEditable.toString());
        return turnOnQuickEdit ? "Edit" : "Live";
    }

    public static boolean isShowDraft(Node content) {
        if (content == null) {
            return false;
        }
        try {
            if (content.isNodeType("nt:frozenNode")) {
                return false;
            }
            WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
            String contentState = wcmPublicationService.getContentState(content);
            boolean isDraftContent = false;
            if ("draft".equals(contentState)) {
                isDraftContent = true;
            }
            boolean isShowDraft = false;
            if ("Edit".equals(Utils.getCurrentMode())) {
                isShowDraft = true;
            }
            return isDraftContent && isShowDraft;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isShowQuickEdit() {
        try {
            boolean isEditMode = false;
            if ("Edit".equals(Utils.getCurrentMode())) {
                isEditMode = true;
            }
            return isEditMode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isShowQuickEdit(Node content) {
        if (content == null) {
            return true;
        }
        try {
            boolean isEditMode = false;
            if ("Edit".equals(Utils.getCurrentMode())) {
                isEditMode = true;
            }
            ((ExtendedNode)content).checkPermission("set_property");
            ((ExtendedNode)content).checkPermission("add_node");
            ((ExtendedNode)content).checkPermission("remove");
            return isEditMode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void createPopupWindow(UIContainer container, UIComponent component, String popupWindowId, int width) throws Exception {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        popupContainer.removeChildById(popupWindowId);
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.addChild(UIPopupWindow.class, null, popupWindowId);
        popupWindow.setUIComponent(component);
        popupWindow.setWindowSize(width, 0);
        popupWindow.setShow(true);
        popupWindow.setRendered(true);
        popupWindow.setResizable(true);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
    }

    public static void closePopupWindow(UIContainer container, String popupWindowId) {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        popupContainer.removeChildById(popupWindowId);
    }

    public static void updatePopupWindow(UIContainer container, UIComponent component, String popupWindowId) {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.getChildById(popupWindowId);
        popupWindow.setUIComponent(component);
    }

    public static UIPopupContainer getPopupContainer(UIContainer container) {
        if (container instanceof UIPortletApplication) {
            return (UIPopupContainer)container.getChild(UIPopupContainer.class);
        }
        UIPortletApplication portletApplication = (UIPortletApplication)container.getAncestorOfType(UIPortletApplication.class);
        return (UIPopupContainer)portletApplication.getChild(UIPopupContainer.class);
    }

    public static void createPopupMessage(UIContainer container, String message, Object[] args, int type) {
        UIApplication application = (UIApplication)container.getAncestorOfType(UIApplication.class);
        application.addMessage(new ApplicationMessage(message, args, type));
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        requestContext.addUIComponentToUpdateByAjax((UIComponent)application.getUIPopupMessages());
    }

    public static <T> T getService(Class<T> clazz) {
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        return clazz.cast(portalApplication.getApplicationComponent(clazz));
    }

    public static SessionProvider getSessionProvider() {
        return WCMCoreUtils.getUserSessionProvider();
    }

    public static SessionProvider getSystemSessionProvider() {
        return WCMCoreUtils.getSystemSessionProvider();
    }
}

