/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.selector.content;

import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.wcm.core.NodeIdentifier;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.NotInWCMPublicationException;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/wcm/webui/selector/content/UIContentResultViewer.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UIContentResultViewer
extends UIContainer {
    private NodeLocation presentNodeLocation;

    public String[] getActions() {
        return new String[]{"Select"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UIContentResultViewer> {
        public void execute(Event<UIContentResultViewer> event) throws Exception {
            Node presentNode;
            UIContentResultViewer contentResultView = (UIContentResultViewer)((Object)event.getSource());
            Node webContent = presentNode = NodeLocation.getNodeByLocation((NodeLocation)contentResultView.presentNodeLocation);
            NodeIdentifier nodeIdentifier = NodeIdentifier.make((Node)webContent);
            PortletRequestContext pContext = (PortletRequestContext)event.getRequestContext();
            PortletPreferences prefs = pContext.getRequest().getPreferences();
            prefs.setValue("repository", nodeIdentifier.getRepository());
            prefs.setValue("workspace", nodeIdentifier.getWorkspace());
            prefs.setValue("nodeIdentifier", nodeIdentifier.getUUID());
            prefs.store();
            String remoteUser = Util.getPortalRequestContext().getRemoteUser();
            String currentSite = Util.getPortalRequestContext().getPortalOwner();
            WCMPublicationService wcmPublicationService = (WCMPublicationService)contentResultView.getApplicationComponent(WCMPublicationService.class);
            try {
                wcmPublicationService.isEnrolledInWCMLifecycle(webContent);
            }
            catch (NotInWCMPublicationException e) {
                wcmPublicationService.unsubcribeLifecycle(webContent);
                wcmPublicationService.enrollNodeInLifecycle(webContent, currentSite, remoteUser);
            }
            UIPortal uiPortal = Util.getUIPortal();
            UIPageBody uiPageBody = (UIPageBody)uiPortal.findFirstComponentOfType(UIPageBody.class);
            uiPageBody.setUIComponent(null);
            uiPageBody.setMaximizedUIComponent(null);
            Utils.updatePortal((PortletRequestContext)event.getRequestContext());
        }
    }
}

