/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import org.exoplatform.ecm.webui.form.validator.CronExpressionValidator;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.form.validator.RepeatCountValidator;
import org.exoplatform.ecm.webui.form.validator.RepeatIntervalValidator;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogFormUtil {
    public static Map<String, JcrInputProperty> prepareMap(List inputs, Map properties) throws Exception {
        HashMap<String, JcrInputProperty> rawinputs = new HashMap<String, JcrInputProperty>();
        HashMap<String, JcrInputProperty> hasMap = new HashMap<String, JcrInputProperty>();
        for (int i = 0; i < inputs.size(); ++i) {
            JcrInputProperty property = null;
            if (inputs.get(i) instanceof UIFormMultiValueInputSet) {
                String inputName = ((UIFormMultiValueInputSet)inputs.get(i)).getName();
                if (!hasMap.containsKey(inputName)) {
                    List values = ((UIFormMultiValueInputSet)inputs.get(i)).getValue();
                    property = (JcrInputProperty)properties.get(inputName);
                    if (property != null) {
                        property.setValue((Object)values.toArray(new String[values.size()]));
                    }
                }
                hasMap.put(inputName, property);
                continue;
            }
            UIFormInputBase input = (UIFormInputBase)inputs.get(i);
            property = (JcrInputProperty)properties.get(input.getName());
            if (property == null) continue;
            if (input instanceof UIFormUploadInput) {
                byte[] content = ((UIFormUploadInput)input).getUploadData();
                property.setValue((Object)content);
                continue;
            }
            if (input instanceof UIFormDateTimeInput) {
                property.setValue((Object)((UIFormDateTimeInput)input).getCalendar());
                continue;
            }
            if (input instanceof UIFormSelectBox) {
                UIFormSelectBox uiSelectBox = (UIFormSelectBox)input;
                if (!uiSelectBox.isMultiple()) {
                    property.setValue(uiSelectBox.getValue());
                    continue;
                }
                property.setValue((Object)uiSelectBox.getSelectedValues());
                continue;
            }
            property.setValue(input.getValue());
        }
        for (JcrInputProperty property : properties.values()) {
            rawinputs.put(property.getJcrPath(), property);
        }
        return rawinputs;
    }

    public static <T extends UIFormInputBase> T createFormInput(Class<T> type, String name, String label, String validateType, Class valueType) throws Exception {
        Object[] args = new Object[]{name, null, valueType};
        UIFormInputBase formInput = (UIFormInputBase)type.getConstructor(new Class[0]).newInstance(args);
        if (validateType != null) {
            String[] validatorList = null;
            validatorList = validateType.indexOf(44) > -1 ? validateType.split(",") : new String[]{validateType};
            for (String validator : validatorList) {
                formInput.addValidator(DialogFormUtil.getValidator(validator.trim()), new Object[0]);
            }
        }
        if (label != null && label.length() != 0) {
            formInput.setLabel(label);
        }
        return (T)((UIFormInputBase)type.cast(formInput));
    }

    public static String getPropertyValueAsString(Node node, String propertyName) throws Exception {
        Property property = null;
        try {
            property = node.getProperty(propertyName);
        }
        catch (PathNotFoundException e) {
            return "";
        }
        int valueType = property.getType();
        switch (valueType) {
            case 1: {
                return property.getString();
            }
            case 3: {
                return Long.toString(property.getLong());
            }
            case 4: {
                return Double.toString(property.getDouble());
            }
            case 5: {
                return property.getDate().getTime().toString();
            }
            case 6: {
                return Boolean.toString(property.getBoolean());
            }
            case 7: {
                return property.getName();
            }
        }
        return "";
    }

    public static Class getValidator(String validatorType) throws ClassNotFoundException {
        if (validatorType.equals("name")) {
            return ECMNameValidator.class;
        }
        if (validatorType.equals("email")) {
            return EmailAddressValidator.class;
        }
        if (validatorType.equals("number")) {
            return NumberFormatValidator.class;
        }
        if (validatorType.equals("empty")) {
            return MandatoryValidator.class;
        }
        if (validatorType.equals("datetime")) {
            return DateTimeValidator.class;
        }
        if (validatorType.equals("cronExpressionValidator")) {
            return CronExpressionValidator.class;
        }
        if (validatorType.equals("repeatCountValidator")) {
            return RepeatCountValidator.class;
        }
        if (validatorType.equals("repeatIntervalValidator")) {
            return RepeatIntervalValidator.class;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.loadClass(validatorType);
    }

    public static void addValidators(UIFormInputBase uiInput, String validators) throws Exception {
        String[] validatorList = null;
        validatorList = validators.indexOf(44) > -1 ? validators.split(",") : new String[]{validators};
        for (String validator : validatorList) {
            uiInput.addValidator(DialogFormUtil.getValidator(validator.trim()), new Object[0]);
        }
    }
}

