/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterCategoryHandler {
    private static Log log = ExoLogger.getLogger(NewsletterCategoryHandler.class);
    private RepositoryService repositoryService = (RepositoryService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(RepositoryService.class);
    private ThreadLocalSessionProviderService threadLocalSessionProviderService = (ThreadLocalSessionProviderService)ThreadLocalSessionProviderService.class.cast(ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ThreadLocalSessionProviderService.class));
    private String repository;
    private String workspace;

    public NewsletterCategoryHandler(String repository, String workspace) {
        this.repository = repository;
        this.workspace = workspace;
    }

    protected NewsletterCategoryConfig getCategoryFromNode(Node categoryNode) throws Exception {
        NewsletterCategoryConfig categoryConfig = null;
        categoryConfig = new NewsletterCategoryConfig();
        categoryConfig.setName(categoryNode.getName());
        categoryConfig.setTitle(categoryNode.getProperty("exo:newsletterCategoryTitle").getString());
        if (categoryNode.hasProperty("exo:newsletterCategoryDescription")) {
            categoryConfig.setDescription(categoryNode.getProperty("exo:newsletterCategoryDescription").getString());
        }
        ExtendedNode webContent = (ExtendedNode)categoryNode;
        Iterator permissionIterator = webContent.getACL().getPermissionEntries().iterator();
        ArrayList<String> listPermission = new ArrayList<String>();
        String permission = "";
        while (permissionIterator.hasNext()) {
            AccessControlEntry accessControlEntry = (AccessControlEntry)permissionIterator.next();
            String currentIdentity = accessControlEntry.getIdentity();
            if (listPermission.contains(currentIdentity)) continue;
            listPermission.add(currentIdentity);
            if (permission.length() > 0) {
                permission = permission + ",";
            }
            permission = permission + currentIdentity;
        }
        categoryConfig.setModerator(permission);
        return categoryConfig;
    }

    public void add(String portalName, NewsletterCategoryConfig categoryConfig, SessionProvider sessionProvider) {
        log.info((Object)("Trying to add category " + categoryConfig.getName()));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoriesNode = (Node)session.getItem(categoryPath);
            Node categoryNode = categoriesNode.addNode(categoryConfig.getName(), "exo:newsletterCategory");
            categoryNode.addNode("Templates", "nt:unstructured");
            ExtendedNode extendedCategoryNode = (ExtendedNode)ExtendedNode.class.cast(categoryNode);
            extendedCategoryNode.setProperty("exo:newsletterCategoryTitle", categoryConfig.getTitle());
            extendedCategoryNode.setProperty("exo:newsletterCategoryDescription", categoryConfig.getDescription());
            if (extendedCategoryNode.canAddMixin("exo:privilegeable")) {
                extendedCategoryNode.addMixin("exo:privilegeable");
                extendedCategoryNode.setPermission(categoryConfig.getModerator(), PermissionType.ALL);
            }
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Add category " + categoryConfig.getName() + " failed because of " + e.getMessage()));
        }
    }

    public void edit(String portalName, NewsletterCategoryConfig categoryConfig) {
        log.info((Object)("Trying to edit category " + categoryConfig.getName()));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = this.threadLocalSessionProviderService.getSessionProvider(null).getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoryNode = ((Node)session.getItem(categoryPath)).getNode(categoryConfig.getName());
            categoryNode.setProperty("exo:newsletterCategoryDescription", categoryConfig.getDescription());
            categoryNode.setProperty("exo:newsletterCategoryTitle", categoryConfig.getTitle());
            ExtendedNode extendedCategoryNode = (ExtendedNode)ExtendedNode.class.cast(categoryNode);
            if (extendedCategoryNode.canAddMixin("exo:privilegeable")) {
                extendedCategoryNode.addMixin("exo:privilegeable");
                extendedCategoryNode.setPermission(categoryConfig.getModerator(), PermissionType.ALL);
            }
            session.save();
        }
        catch (Exception e) {
            log.info((Object)("Edit category " + categoryConfig.getName() + " failed because of " + e.getMessage()));
        }
    }

    public void delete(String portalName, String categoryName) {
        log.info((Object)("Trying to delete category " + categoryName));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = this.threadLocalSessionProviderService.getSessionProvider(null).getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoryNode = ((Node)session.getItem(categoryPath)).getNode(categoryName);
            categoryNode.remove();
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Delete category " + categoryName + " failed because of " + e.getMessage()));
        }
    }

    public NewsletterCategoryConfig getCategoryByName(String portalName, String categoryName) throws Exception {
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = this.threadLocalSessionProviderService.getSessionProvider(null).getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoriesNode = (Node)session.getItem(categoryPath);
            return this.getCategoryFromNode(categoriesNode.getNode(categoryName));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public List<NewsletterCategoryConfig> getListCategories(String portalName) throws Exception {
        ArrayList<NewsletterCategoryConfig> listCategories = new ArrayList<NewsletterCategoryConfig>();
        try {
            ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repository);
            Session session = this.threadLocalSessionProviderService.getSessionProvider(null).getSession(this.workspace, manageableRepository);
            String categoryPath = NewsletterConstant.generateCategoryPath(portalName);
            Node categoriesNode = (Node)session.getItem(categoryPath);
            NodeIterator nodeIterator = categoriesNode.getNodes();
            while (nodeIterator.hasNext()) {
                try {
                    listCategories.add(this.getCategoryFromNode(nodeIterator.nextNode()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listCategories;
    }
}

