/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter;

import java.util.List;
import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.wcm.deployment.WCMContentInitializerService;
import org.exoplatform.services.wcm.newsletter.NewsletterCategoryConfig;
import org.exoplatform.services.wcm.newsletter.NewsletterInitializationService;
import org.exoplatform.services.wcm.newsletter.NewsletterManagerService;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.newsletter.config.NewsletterUserConfig;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.portal.artifacts.BasePortalArtifactsPlugin;

public class InitialNewsletterPlugin
extends BasePortalArtifactsPlugin {
    private List<NewsletterCategoryConfig> categoryConfigs;
    private List<NewsletterSubscriptionConfig> subscriptionConfigs;
    private List<NewsletterUserConfig> userConfigs;
    private NewsletterManagerService newsletterManagerService;
    private LivePortalManagerService livePortalManagerService;
    private static Log log = ExoLogger.getLogger(NewsletterInitializationService.class);

    public InitialNewsletterPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService, NewsletterManagerService newsletterManagerService, LivePortalManagerService livePortalManagerService, WCMContentInitializerService wcmContentInitializerService) {
        super(initParams, configurationManager, repositoryService);
        this.categoryConfigs = initParams.getObjectParamValues(NewsletterCategoryConfig.class);
        this.subscriptionConfigs = initParams.getObjectParamValues(NewsletterSubscriptionConfig.class);
        this.userConfigs = initParams.getObjectParamValues(NewsletterUserConfig.class);
        this.livePortalManagerService = livePortalManagerService;
        this.newsletterManagerService = newsletterManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deployToPortal(String portalName, SessionProvider sessionProvider) throws Exception {
        try {
            NewsletterCategoryHandler categoryHandler = this.newsletterManagerService.getCategoryHandler();
            for (NewsletterCategoryConfig categoryConfig : this.categoryConfigs) {
                categoryHandler.add(portalName, categoryConfig, sessionProvider);
            }
            NewsletterSubscriptionHandler subscriptionHandler = this.newsletterManagerService.getSubscriptionHandler();
            for (NewsletterSubscriptionConfig subscriptionConfig : this.subscriptionConfigs) {
                subscriptionHandler.add(sessionProvider, portalName, subscriptionConfig);
            }
            Node userNode = null;
            NewsletterManageUserHandler manageUserHandler = this.newsletterManagerService.getManageUserHandler();
            for (NewsletterUserConfig userConfig : this.userConfigs) {
                userNode = manageUserHandler.add(portalName, userConfig.getMail(), sessionProvider);
            }
            ExtendedNode userFolderNode = (ExtendedNode)userNode.getParent();
            if (userFolderNode.canAddMixin("exo:privilegeable")) {
                userFolderNode.addMixin("exo:privilegeable");
            }
            userFolderNode.setPermission("any", PermissionType.ALL);
        }
        catch (Throwable e) {
            log.info((Object)("Starting NewsletterInitializationService fail because of " + e.getMessage()));
        }
        finally {
            sessionProvider.close();
        }
    }
}

